/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.preferences.fonts.wizard;

import com.jaspersoft.studio.jface.dialogs.LocaleDialog;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.preferences.editor.table.TableLabelProvider;
import com.jaspersoft.studio.swt.widgets.table.DeleteButton;
import com.jaspersoft.studio.swt.widgets.table.INewElement;
import com.jaspersoft.studio.swt.widgets.table.ListContentProvider;
import com.jaspersoft.studio.swt.widgets.table.NewButton;
import com.jaspersoft.studio.wizards.ContextHelpIDs;
import com.jaspersoft.studio.wizards.JSSHelpWizardPage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.sf.jasperreports.engine.fonts.FontFamily;
import net.sf.jasperreports.engine.fonts.SimpleFontFamily;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;

public class FontLocalesPage
extends JSSHelpWizardPage {
    private SimpleFontFamily fontFamily;
    private Table table;
    private TableViewer tableViewer;

    public FontLocalesPage(FontFamily fontFamily) {
        super("fontlocalespage");
        this.setTitle(Messages.FontLocalesPage_pageTitle);
        this.setDescription(Messages.FontLocalesPage_pageDescrtiption);
        this.fontFamily = (SimpleFontFamily)fontFamily;
    }

    public void dispose() {
        List inlist = (List)this.tableViewer.getInput();
        HashSet locales = new HashSet(inlist);
        if (locales.isEmpty()) {
            this.fontFamily.setLocales(null);
        } else {
            this.fontFamily.setLocales(locales);
        }
        super.dispose();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        this.setControl((Control)composite);
        Label lbl = new Label(composite, 64);
        lbl.setText(Messages.FontLocalesPage_labelText);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.widthHint = 300;
        lbl.setLayoutData((Object)gd);
        this.buildTable(composite);
        this.table.setLayoutData((Object)new GridData(1808));
        Composite bGroup = new Composite(composite, 0);
        bGroup.setLayout((Layout)new GridLayout(1, false));
        bGroup.setLayoutData((Object)new GridData(1040));
        new NewButton().createNewButtons(bGroup, this.tableViewer, new INewElement(){

            @Override
            public Object newElement(List<?> input, int pos) {
                LocaleDialog ld = new LocaleDialog(Display.getCurrent().getActiveShell(), null);
                if (ld.open() == 0) {
                    Locale l = ld.getLocale();
                    if (FontLocalesPage.this.fontFamily.getLocales() == null) {
                        FontLocalesPage.this.fontFamily.setLocales(new HashSet());
                    }
                    if (!FontLocalesPage.this.fontFamily.getLocales().contains(l)) {
                        FontLocalesPage.this.fontFamily.getLocales().add(l.toString());
                        return l.toString();
                    }
                }
                return null;
            }
        });
        new DeleteButton().createDeleteButton(bGroup, this.tableViewer);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "Jaspersoft.wizard");
    }

    private void buildTable(Composite composite) {
        this.table = new Table(composite, 68100);
        this.table.setHeaderVisible(true);
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        TableLayout tlayout = new TableLayout();
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, 75, true));
        this.table.setLayout((Layout)tlayout);
        TableColumn[] column = new TableColumn[]{new TableColumn(this.table, 0)};
        column[0].setText(Messages.FontLocalesPage_colHeader);
        int i = 0;
        int n = column.length;
        while (i < n) {
            column[i].pack();
            ++i;
        }
        this.fillTable(this.table);
    }

    private void fillTable(Table table) {
        ArrayList lst = new ArrayList();
        Set locales = this.fontFamily.getLocales();
        if (locales != null) {
            lst.addAll(this.fontFamily.getLocales());
        }
        this.tableViewer.setInput(lst);
    }

    @Override
    protected String getContextName() {
        return ContextHelpIDs.WIZARD_FONT_EXTENSION;
    }
}

