/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.preferences.fonts.wizard;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.property.descriptor.combo.RWComboBoxCellEditor;
import com.jaspersoft.studio.swt.widgets.table.DeleteButton;
import com.jaspersoft.studio.swt.widgets.table.INewElement;
import com.jaspersoft.studio.swt.widgets.table.ListContentProvider;
import com.jaspersoft.studio.swt.widgets.table.NewButton;
import com.jaspersoft.studio.wizards.ContextHelpIDs;
import com.jaspersoft.studio.wizards.JSSHelpWizardPage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.fonts.FontFamily;
import net.sf.jasperreports.engine.fonts.SimpleFontFamily;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class FontMappingPage
extends JSSHelpWizardPage {
    private SimpleFontFamily fontFamily;
    private Table table;
    private TableViewer tableViewer;
    private Text defaultfont;

    public FontMappingPage(FontFamily fontFamily) {
        super("fontmappingpage");
        this.setTitle(Messages.FontMappingPage_2);
        this.setDescription(Messages.FontMappingPage_3);
        this.fontFamily = (SimpleFontFamily)fontFamily;
    }

    public void dispose() {
        HashMap<String, String> map = new HashMap<String, String>();
        List inlist = (List)this.tableViewer.getInput();
        for (List str : inlist) {
            map.put((String)str.get(0), (String)str.get(1));
        }
        this.fontFamily.setExportFonts(map);
        super.dispose();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        this.setControl((Control)composite);
        Label lbl = new Label(composite, 64);
        lbl.setText(Messages.FontMappingPage_4);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        gd.widthHint = 300;
        lbl.setLayoutData((Object)gd);
        new Label(composite, 0).setText(Messages.FontMappingPage_5);
        this.defaultfont = new Text(composite, 2048);
        this.defaultfont.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FontMappingPage.this.fontFamily.setDefaultExportFont(FontMappingPage.this.defaultfont.getText());
            }
        });
        this.defaultfont.setLayoutData((Object)new GridData(768));
        Composite c = new Composite(composite, 0);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        c.setLayoutData((Object)gd);
        c.setLayout((Layout)new GridLayout(2, false));
        this.buildTable(c);
        this.table.setLayoutData((Object)new GridData(1808));
        Composite bGroup = new Composite(c, 0);
        bGroup.setLayout((Layout)new GridLayout(1, false));
        bGroup.setLayoutData((Object)new GridData(1040));
        new NewButton().createNewButtons(bGroup, this.tableViewer, new INewElement(){

            @Override
            public Object newElement(List<?> input, int pos) {
                ArrayList<String> lst = new ArrayList<String>(2);
                lst.add("html");
                lst.add(Messages.FontMappingPage_7);
                return lst;
            }
        });
        new DeleteButton().createDeleteButton(bGroup, this.tableViewer);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "Jaspersoft.wizard");
        this.fillWidgets();
    }

    private void buildTable(Composite composite) {
        this.table = new Table(composite, 68100);
        this.table.setHeaderVisible(true);
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.attachCellEditors(this.tableViewer, (Composite)this.table);
        TableLayout tlayout = new TableLayout();
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, 75, true));
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, 75, true));
        this.table.setLayout((Layout)tlayout);
        TableColumn[] column = new TableColumn[2];
        column[0] = new TableColumn(this.table, 0);
        column[0].setText(Messages.FontMappingPage_8);
        column[1] = new TableColumn(this.table, 0);
        column[1].setText(Messages.FontMappingPage_9);
        int i = 0;
        int n = column.length;
        while (i < n) {
            column[i].pack();
            ++i;
        }
        this.fillTable(this.table);
    }

    private void attachCellEditors(TableViewer viewer, Composite parent) {
        viewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                if (property.equals("EXPORTER")) {
                    return true;
                }
                return property.equals("MAPPING");
            }

            public Object getValue(Object element, String property) {
                List data = (List)element;
                if ("EXPORTER".equals(property)) {
                    return data.get(0);
                }
                if ("MAPPING".equals(property)) {
                    return data.get(0);
                }
                return "";
            }

            public void modify(Object element, String property, Object value) {
                TableItem tableItem = (TableItem)element;
                FontMappingPage.this.setErrorMessage(null);
                FontMappingPage.this.setMessage(FontMappingPage.this.getDescription());
                List data = (List)tableItem.getData();
                if ("EXPORTER".equals(property)) {
                    List inlist = (List)FontMappingPage.this.tableViewer.getInput();
                    for (List s : inlist) {
                        if (!((String)s.get(0)).equals(value)) continue;
                        return;
                    }
                    data.add(0, (String)value);
                } else if ("MAPPING".equals(property)) {
                    data.add(1, (String)value);
                }
                FontMappingPage.this.tableViewer.update(element, new String[]{property});
                FontMappingPage.this.tableViewer.refresh();
            }
        });
        viewer.setCellEditors(new CellEditor[]{new RWComboBoxCellEditor(parent, new String[]{"", "html", "xhtml", "rtf"}), new TextCellEditor(parent)});
        viewer.setColumnProperties(new String[]{"EXPORTER", "MAPPING"});
    }

    private void fillTable(Table table) {
        ArrayList lst = new ArrayList();
        Map map = this.fontFamily.getExportFonts();
        if (map != null) {
            for (String key : map.keySet()) {
                ArrayList<String> l = new ArrayList<String>(2);
                l.add(key);
                l.add((String)map.get(key));
                lst.add(l);
            }
        }
        this.tableViewer.setInput(lst);
    }

    private void fillWidgets() {
        if (this.fontFamily.getDefaultExportFont() != null) {
            this.defaultfont.setText(this.fontFamily.getDefaultExportFont());
        }
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    @Override
    protected String getContextName() {
        return ContextHelpIDs.WIZARD_FONT_EXTENSION;
    }

    public class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof List) {
                List el = (List)element;
                switch (columnIndex) {
                    case 0: {
                        return (String)el.get(0);
                    }
                    case 1: {
                        return (String)el.get(1);
                    }
                }
                return element != null ? element.toString() : "";
            }
            return Misc.nvl((Object)element, (String)"");
        }

        public void dispose() {
        }
    }
}

