/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.preferences.theme;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.preferences.theme.ATheme;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.DataFormatException;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class UITheme
extends ATheme {
    public UITheme() {
        this.addProperty("gridColor", "192,192,192");
        this.addProperty("containerMarginColor", "170,168,255");
        this.addProperty("pageBackground", "255,255,255");
        this.addProperty("pageMarginColor", "170,168,255");
        this.addProperty("elementDesignBorderColor", "0,0,0");
    }

    @Override
    public Composite createControl(Composite parent, IPreferenceStore store) {
        Composite cmp = new Composite(parent, 0);
        cmp.setLayout((Layout)new GridLayout(2, false));
        this.createColorProperty(cmp, "gridColor", Messages.RulersGridPreferencePage_common_gridcolor, store);
        this.createColorProperty(cmp, "containerMarginColor", Messages.DesignerPreferencePage_common_bandmargincolor, store);
        this.createColorProperty(cmp, "pageMarginColor", Messages.DesignerPreferencePage_pageprintmargincolor, store);
        this.createColorProperty(cmp, "pageBackground", Messages.DesignerPreferencePage_pagebackground, store);
        this.createColorProperty(cmp, "elementDesignBorderColor", Messages.DesignerPreferencePage_elementbordercolor, store);
        return cmp;
    }

    public void createColorProperty(Composite cmp, final String prop, String name, final IPreferenceStore store) {
        new Label(cmp, 0).setText(name);
        final ColorSelector colorSelector = new ColorSelector(cmp);
        colorSelector.addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                UITheme.this.properties.put(prop, StringConverter.asString((RGB)colorSelector.getColorValue()));
                UITheme.this.save(store);
            }
        });
        try {
            colorSelector.setColorValue(StringConverter.asRGB((String)((String)this.properties.get(prop))));
        }
        catch (DataFormatException e) {
            e.printStackTrace();
        }
    }
}

