/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.preferences.util;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.preferences.PreferenceInitializer;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.builder.jdt.JDTUtils;
import net.sf.jasperreports.eclipse.preferences.IPreferenceExtendablePage;
import net.sf.jasperreports.eclipse.preferences.IPreferencePageExtension;
import net.sf.jasperreports.eclipse.preferences.PreferencesExtensionsManager;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.eclipse.util.ResourcePreferences;
import org.eclipse.core.internal.resources.ProjectPreferences;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.internal.dialogs.PropertyDialog;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.service.prefs.BackingStoreException;

public abstract class FieldEditorOverlayPage
extends FieldEditorPreferencePage
implements IWorkbenchPropertyPage,
IWorkbenchPreferencePage,
IPreferenceExtendablePage {
    public static final String RESOURCE = "resource";
    private static final String PROJECT = "project";
    public static final String USERESOURCESETTINGS = "useResourceSettings";
    private List<FieldEditor> editors = new ArrayList<FieldEditor>();
    private IAdaptable element;
    private Button useWorkspaceSettingsButton;
    private Button useProjectSettingsButton;
    private Button useResourceSettingsButton;
    private Button confWkspButton;
    private Button confPrjButton;
    private ScopedPreferenceStore overlayStore;
    private ImageDescriptor image;
    private String pageId;
    private Composite selectionComposite;
    private boolean canSwitchScope = true;
    private QualifiedName reskey = new QualifiedName(JaspersoftStudioPlugin.getUniqueIdentifier(), "useResourceSettings");

    public FieldEditorOverlayPage(int style) {
        super(style);
    }

    public FieldEditorOverlayPage(String title, int style) {
        super(title, style);
    }

    public FieldEditorOverlayPage(String title, ImageDescriptor image, int style) {
        super(title, image, style);
        this.image = image;
    }

    public void setElement(IAdaptable element) {
        this.element = element;
    }

    public IAdaptable getElement() {
        return this.element;
    }

    public boolean isPropertyPage() {
        return this.getElement() != null;
    }

    public boolean isResourcePage() {
        return JDTUtils.isOrCanAdaptTo((IAdaptable)this.getElement(), IFile.class);
    }

    public void addField(FieldEditor editor) {
        this.editors.add(editor);
        super.addField(editor);
    }

    public void createControl(Composite parent) {
        if (this.isPropertyPage()) {
            this.pageId = JaspersoftStudioPlugin.getUniqueIdentifier();
            this.overlayStore = JaspersoftStudioPlugin.getInstance().getPreferenceStore(this.getResource(), this.pageId);
            PreferenceInitializer.initDefaultProperties((IPreferenceStore)this.overlayStore);
        }
        super.createControl(parent);
        if (this.isPropertyPage()) {
            this.updateFieldEditors();
        }
    }

    protected IResource getResource() {
        IResource resource = null;
        if (this.getElement() instanceof IResource) {
            resource = (IResource)this.getElement();
        } else if (this.getElement() instanceof IFileEditorInput) {
            resource = ((IFileEditorInput)this.getElement()).getFile();
        } else if (this.getElement() != null) {
            resource = (IResource)this.getElement().getAdapter(IResource.class);
        }
        return resource;
    }

    protected Control createContents(Composite parent) {
        if (this.isPropertyPage()) {
            this.createSelectionGroup(parent);
        }
        return super.createContents(parent);
    }

    private void createSelectionGroup(Composite parent) {
        this.selectionComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.selectionComposite.setLayout((Layout)layout);
        this.useWorkspaceSettingsButton = this.createRadioButton(this.selectionComposite, Messages.FieldEditorOverlayPage_2);
        if (this.isPropertyPage()) {
            this.confWkspButton = new Button(this.selectionComposite, 8);
            this.confWkspButton.setLayoutData((Object)new GridData(768));
            this.confWkspButton.setText(Messages.FieldEditorOverlayPage_4);
            this.confWkspButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FieldEditorOverlayPage.this.configureWorkspaceSettings(null);
                }
            });
        }
        this.useProjectSettingsButton = this.createRadioButton(this.selectionComposite, Messages.FieldEditorOverlayPage_3);
        if (this.isResourcePage()) {
            this.confPrjButton = new Button(this.selectionComposite, 8);
            this.confPrjButton.setLayoutData((Object)new GridData(768));
            this.confPrjButton.setText("Configure Project Settings");
            this.confPrjButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IResource res = FieldEditorOverlayPage.this.getResource();
                    if (res != null) {
                        FieldEditorOverlayPage.this.configureWorkspaceSettings(res.getProject());
                    }
                }
            });
            this.useResourceSettingsButton = this.createRadioButton(this.selectionComposite, "Use File Settings");
        }
        this.setupWPREnabled();
    }

    public void setCanSwitchScope(boolean canSwitchScope) {
        this.canSwitchScope = canSwitchScope;
    }

    protected void setupWPREnabled() {
        try {
            this.useWorkspaceSettingsButton.setSelection(false);
            this.useProjectSettingsButton.setSelection(false);
            if (this.useResourceSettingsButton != null) {
                this.useResourceSettingsButton.setSelection(false);
            }
            this.confWkspButton.setEnabled(false);
            if (this.confPrjButton != null) {
                this.confPrjButton.setEnabled(false);
            }
            IResource r = this.getResource();
            if (this.canSwitchScope) {
                String use;
                String string = use = r != null ? Misc.nvl((String)r.getPersistentProperty(this.reskey)) : "";
                if (PROJECT.equals(use)) {
                    this.useProjectSettingsButton.setSelection(true);
                    if (this.confPrjButton != null) {
                        this.confPrjButton.setEnabled(true);
                    }
                } else if (RESOURCE.equals(use)) {
                    if (this.useResourceSettingsButton != null) {
                        this.useResourceSettingsButton.setSelection(true);
                    }
                } else {
                    this.useWorkspaceSettingsButton.setSelection(true);
                    this.confWkspButton.setEnabled(true);
                }
            } else {
                if (this.useWorkspaceSettingsButton != null) {
                    this.useWorkspaceSettingsButton.setEnabled(false);
                }
                if (this.useResourceSettingsButton != null) {
                    this.useResourceSettingsButton.setEnabled(false);
                }
                if (this.useProjectSettingsButton != null) {
                    this.useProjectSettingsButton.setEnabled(false);
                }
                if (r instanceof IProject) {
                    this.useProjectSettingsButton.setSelection(true);
                    if (this.confPrjButton != null) {
                        this.confPrjButton.setEnabled(true);
                    }
                } else if (r instanceof IFile) {
                    if (this.useResourceSettingsButton != null) {
                        this.useResourceSettingsButton.setSelection(true);
                    }
                } else {
                    this.useWorkspaceSettingsButton.setSelection(true);
                    this.confWkspButton.setEnabled(true);
                }
            }
        }
        catch (CoreException coreException) {
            this.useWorkspaceSettingsButton.setSelection(true);
        }
    }

    private Button createRadioButton(Composite parent, String label) {
        final Button button = new Button(parent, 16);
        button.setText(label);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FieldEditorOverlayPage.this.confWkspButton.setEnabled(button == FieldEditorOverlayPage.this.useWorkspaceSettingsButton);
                if (FieldEditorOverlayPage.this.confPrjButton != null) {
                    FieldEditorOverlayPage.this.confPrjButton.setEnabled(button == FieldEditorOverlayPage.this.useProjectSettingsButton);
                }
                FieldEditorOverlayPage.this.updateFieldEditors();
                FieldEditorOverlayPage.super.performDefaults();
            }
        });
        return button;
    }

    public IPreferenceStore getPreferenceStore() {
        if (this.getElement() != null) {
            IResource r = this.getResource();
            if (this.useProjectSettingsButton != null && this.useProjectSettingsButton.getSelection()) {
                if (r instanceof IFile) {
                    r = r.getProject();
                }
                return JaspersoftStudioPlugin.getInstance().getPreferenceStore(r, this.pageId);
            }
            if (this.useResourceSettingsButton != null && this.useResourceSettingsButton.getSelection()) {
                return JaspersoftStudioPlugin.getInstance().getPreferenceStore(r, this.pageId);
            }
        }
        return super.getPreferenceStore();
    }

    private void updateFieldEditors() {
        this.initialize();
        boolean enabled = false;
        if (this.isResourcePage()) {
            enabled = this.useResourceSettingsButton.getSelection();
        } else if (this.isPropertyPage()) {
            enabled = this.useProjectSettingsButton.getSelection();
        }
        this.enableComposite(this.getFieldEditorParent(), enabled);
    }

    private void enableComposite(Composite parent, boolean enabled) {
        Control[] controlArray = parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.setEnabled(enabled);
            if (enabled) {
                c.setForeground(Display.getDefault().getSystemColor(30));
            } else {
                c.setForeground(Display.getDefault().getSystemColor(33));
            }
            if (c instanceof Composite) {
                this.enableComposite((Composite)c, enabled);
            }
            ++n2;
        }
    }

    public boolean performOk() {
        IResource resource;
        boolean result = true;
        if (this.useResourceSettingsButton != null) {
            if (this.useResourceSettingsButton.getSelection()) {
                result = super.performOk();
            }
        } else if (this.useProjectSettingsButton != null) {
            if (this.useProjectSettingsButton.getSelection()) {
                result = super.performOk();
            }
        } else {
            result = super.performOk();
        }
        if (result && this.isPropertyPage() && (resource = this.getResource()) != null) {
            try {
                String value = "workspace";
                if (this.useProjectSettingsButton.getSelection()) {
                    value = PROJECT;
                }
                if (this.useResourceSettingsButton != null && this.useResourceSettingsButton.getSelection()) {
                    value = RESOURCE;
                }
                IEclipsePreferences[] iEclipsePreferencesArray = this.overlayStore.getPreferenceNodes(true);
                int n = iEclipsePreferencesArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IEclipsePreferences ep = iEclipsePreferencesArray[n2];
                    try {
                        if (this.useResourceSettingsButton != null && !this.useResourceSettingsButton.getSelection() && ep instanceof ResourcePreferences) {
                            ep.clear();
                        }
                        if (!this.useProjectSettingsButton.getSelection() && ep instanceof ProjectPreferences) {
                            ep.clear();
                        }
                        ep.flush();
                    }
                    catch (BackingStoreException e) {
                        JaspersoftStudioPlugin.getInstance().logError("An error occurred while try to store back preferences", e);
                    }
                    ++n2;
                }
                resource.setPersistentProperty(this.reskey, value);
            }
            catch (CoreException e) {
                JaspersoftStudioPlugin.getInstance().logError("An error occurred while try to store back preferences", e);
            }
        }
        return result;
    }

    protected void performDefaults() {
        List subPages;
        if (this.isPropertyPage()) {
            this.useWorkspaceSettingsButton.setSelection(true);
            this.useProjectSettingsButton.setSelection(false);
            if (this.useResourceSettingsButton != null) {
                this.useResourceSettingsButton.setSelection(false);
            }
            this.confWkspButton.setEnabled(true);
            if (this.confPrjButton != null) {
                this.confPrjButton.setEnabled(false);
            }
            this.updateFieldEditors();
        }
        if ((subPages = PreferencesExtensionsManager.getContributedPreferencePages((String)this.getPageId())) != null) {
            for (IPreferencePageExtension page : subPages) {
                page.performDefaults();
            }
        }
        super.performDefaults();
    }

    protected void configureWorkspaceSettings(IProject project) {
        try {
            FieldEditorOverlayPage page = (FieldEditorOverlayPage)((Object)((Object)((Object)this)).getClass().newInstance());
            page.setTitle(this.getTitle());
            page.setImageDescriptor(this.image);
            page.setElement((IAdaptable)project);
            if (project != null) {
                page.setCanSwitchScope(false);
            }
            this.showPreferencePage(this.pageId, (IPreferencePage)page, project);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    protected void showPreferencePage(String id, IPreferencePage page, IProject project) {
        PreferenceNode targetNode = new PreferenceNode(id, page);
        PreferenceManager manager = new PreferenceManager();
        manager.addToRoot((IPreferenceNode)targetNode);
        Shell shell = this.getControl().getShell();
        final PreferenceDialog dialog = project == null ? new PreferenceDialog(shell, manager) : new PropertyDialog(shell, manager, (ISelection)new StructuredSelection((Object)project));
        BusyIndicator.showWhile((Display)this.getControl().getDisplay(), (Runnable)new Runnable((IPreferenceNode)targetNode){
            private final /* synthetic */ IPreferenceNode val$targetNode;
            {
                this.val$targetNode = iPreferenceNode;
            }

            @Override
            public void run() {
                dialog.create();
                dialog.setMessage(this.val$targetNode.getLabelText());
                dialog.open();
            }
        });
    }

    protected void performApply() {
        List subPages = PreferencesExtensionsManager.getContributedPreferencePages((String)this.getPageId());
        if (subPages != null) {
            for (IPreferencePageExtension page : subPages) {
                page.performApply();
            }
        }
        super.performApply();
    }

    public boolean performCancel() {
        List subPages = PreferencesExtensionsManager.getContributedPreferencePages((String)this.getPageId());
        if (subPages != null) {
            for (IPreferencePageExtension page : subPages) {
                page.performCancel();
            }
        }
        return super.performCancel();
    }

    protected void createContributedPreferences() {
        List subPages = PreferencesExtensionsManager.getContributedPreferencePages((String)this.getPageId());
        if (subPages != null) {
            for (IPreferencePageExtension page : subPages) {
                page.createContributedFields(this.getFieldEditorParent(), (IPreferenceExtendablePage)this);
            }
        }
    }

    protected void createFieldEditors() {
        this.createContributedPreferences();
    }
}

