/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.preferences.util;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JasperReportsContext;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;

public class PropertiesHelper {
    public static final IScopeContext INSTANCE_SCOPE = new InstanceScope();
    private IPreferencesService service = Platform.getPreferencesService();
    private String qualifier = JaspersoftStudioPlugin.getUniqueIdentifier();
    private String[] lookupOrders = new String[]{"instance"};
    private IScopeContext[] contexts = new IScopeContext[]{INSTANCE_SCOPE};
    public static JRPropertiesUtil DPROP = JRPropertiesUtil.getInstance((JasperReportsContext)DefaultJasperReportsContext.getInstance());
    private static PropertiesHelper inst;

    private PropertiesHelper() {
        this.service.setDefaultLookupOrder(this.qualifier, null, this.lookupOrders);
    }

    public void setString(String key, String value, String scope) {
        this.service.getRootNode().node(scope).node(this.qualifier).put(key, value);
    }

    public void removeString(String key, String scope) {
        this.service.getRootNode().node(scope).node(this.qualifier).remove(key);
    }

    public void setBoolean(String key, boolean value, String scope) {
        this.service.getRootNode().node(scope).node(this.qualifier).putBoolean(key, value);
    }

    public String getString(String key, String def) {
        String str = this.getString(key);
        if (str == null) {
            return def;
        }
        return str;
    }

    public String getString(String key) {
        return this.service.getString(this.qualifier, key, null, this.contexts);
    }

    public Boolean getBoolean(String key) {
        String val = this.getString(key);
        if (val == null) {
            return null;
        }
        return new Boolean(val);
    }

    public Boolean getBoolean(String key, boolean def) {
        String val = this.getString(key);
        if (val == null) {
            return def;
        }
        return new Boolean(val);
    }

    public Integer getInteger(String key, Integer def) {
        Integer val = this.getInteger(key);
        if (val == null) {
            return def;
        }
        return val;
    }

    public Integer getInteger(String key) {
        String val = this.getString(key);
        if (val == null) {
            return null;
        }
        return new Integer(val);
    }

    public Float getFloat(String key) {
        String val = this.getString(key);
        if (val == null) {
            return null;
        }
        return new Float(val);
    }

    public Float getFloat(String key, Float def) {
        Float val = this.getFloat(key);
        if (val == null) {
            return def;
        }
        return val;
    }

    public Character getCharacter(String key) {
        String val = this.getString(key);
        if (val == null || val.isEmpty()) {
            return null;
        }
        return new Character(val.charAt(0));
    }

    public static PropertiesHelper getInstance() {
        if (inst == null) {
            inst = new PropertiesHelper();
        }
        return inst;
    }
}

