/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.prm.prefs;

import com.jaspersoft.studio.help.TableHelpListener;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.preferences.editor.table.TableFieldEditor;
import com.jaspersoft.studio.prm.ParameterSet;
import com.jaspersoft.studio.prm.ParameterSetProvider;
import com.jaspersoft.studio.prm.dialog.ParameterSetDialog;
import com.jaspersoft.studio.wizards.ContextHelpIDs;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class ParameterSetFieldEditor
extends TableFieldEditor {
    protected Button editButton;
    private List<String> removed = new ArrayList<String>();

    public ParameterSetFieldEditor() {
    }

    public ParameterSetFieldEditor(String name, Composite parent) {
        super(name, "", new String[]{Messages.ParameterSetFieldEditor_0}, new int[]{150}, parent);
    }

    @Override
    protected void adjustForNumColumns(int numColumns) {
        super.adjustForNumColumns(numColumns);
        ((GridData)this.getLabelControl().getLayoutData()).exclude = true;
        this.getLabelControl().setVisible(false);
    }

    @Override
    protected String createList(String[][] items) {
        return "";
    }

    @Override
    protected String[][] parseString(String string) {
        return new String[0][0];
    }

    @Override
    protected void addPressed() {
        String[] newInputObject;
        this.setPresentsDefaultValue(false);
        ParameterSetDialog dialog = new ParameterSetDialog(UIUtils.getShell(), this.table);
        if (dialog.open() == 0 && (newInputObject = new String[]{dialog.getPValue().getName()}) != null) {
            TableItem tableItem = new TableItem(this.table, 0);
            tableItem.setText(newInputObject);
            tableItem.setData("com.jaspersoft.studio.parameterset", (Object)dialog.getPValue());
            this.selectionChanged();
            this.table.showColumn(this.table.getColumn(0));
            this.table.showItem(tableItem);
            this.table.showSelection();
        }
    }

    @Override
    protected void doStore() {
        TableItem[] items = this.getTable().getItems();
        String str = "";
        IPreferenceStore pstore = this.getPreferenceStore();
        for (String key : this.removed) {
            pstore.setValue(key, pstore.getDefaultString(key));
        }
        int i = 0;
        while (i < items.length) {
            TableItem it = items[i];
            String pname = it.getText(0);
            str = String.valueOf(str) + pname + "\n";
            ParameterSet pset = (ParameterSet)it.getData("com.jaspersoft.studio.parameterset");
            ParameterSetProvider.storeParameterSet(pset, pstore);
            ++i;
        }
        try {
            pstore.setValue("com.jaspersoft.studio.parametersets", Misc.encodeBase64String((String)str, (String)"ISO-8859-1"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.removed.clear();
    }

    @Override
    protected void doLoad() {
        if (this.getTable() != null) {
            this.removed.clear();
            this.getTable().removeAll();
            String str = this.getPreferenceStore().getString("com.jaspersoft.studio.parametersets");
            if (str != null) {
                String[] sets;
                try {
                    str = Misc.decodeBase64String((String)str, (String)"ISO-8859-1");
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return;
                }
                String[] stringArray = sets = str.split("\n");
                int n = sets.length;
                int n2 = 0;
                while (n2 < n) {
                    String key = stringArray[n2];
                    TableItem tableItem = new TableItem(this.getTable(), 0);
                    tableItem.setText(new String[]{key});
                    ++n2;
                }
            }
            TableHelpListener.setTableHelp(this.getTable());
        }
    }

    @Override
    protected void doLoadDefault() {
        this.doLoad();
    }

    @Override
    protected boolean isFieldEditable(int col, int row) {
        return false;
    }

    protected void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, ContextHelpIDs.PREFERENCES_PROPERTIES);
        this.table.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                ParameterSetFieldEditor.this.editPressed();
            }
        });
    }

    @Override
    public void createSelectionListener() {
        this.selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Widget widget = event.widget;
                if (widget == ParameterSetFieldEditor.this.addButton) {
                    ParameterSetFieldEditor.this.addPressed();
                } else if (widget == ParameterSetFieldEditor.this.duplicateButton) {
                    ParameterSetFieldEditor.this.duplicatePressed();
                } else if (widget == ParameterSetFieldEditor.this.removeButton) {
                    int index = ParameterSetFieldEditor.this.table.getSelectionIndex();
                    if (index >= 0) {
                        ParameterSetFieldEditor.this.removed.add("com.jaspersoft.studio.parameterset." + ParameterSetFieldEditor.this.table.getItem(index).getText(0));
                    }
                    ParameterSetFieldEditor.this.removePressed();
                } else if (widget == ParameterSetFieldEditor.this.editButton) {
                    ParameterSetFieldEditor.this.editPressed();
                } else if (widget == ParameterSetFieldEditor.this.table) {
                    ParameterSetFieldEditor.this.selectionChanged();
                }
            }
        };
    }

    @Override
    protected void duplicatePressed() {
        this.setPresentsDefaultValue(false);
        int index = this.table.getSelectionIndex();
        if (index >= 0) {
            TableItem[] selection = this.table.getSelection();
            Assert.isTrue((selection.length >= 1 ? 1 : 0) != 0);
            int i = 0;
            if (i < selection.length) {
                TableItem tableItem = selection[0];
                ParameterSet pvalue = (ParameterSet)tableItem.getData("com.jaspersoft.studio.parameterset");
                if (pvalue == null) {
                    pvalue = ParameterSetProvider.getParameterSet(tableItem.getText(0), this.getPreferenceStore());
                }
                if (pvalue != null) {
                    pvalue.setName("CopyOf_" + pvalue.getName());
                    ParameterSetDialog dialog = new ParameterSetDialog(UIUtils.getShell(), -1, pvalue, this.table);
                    if (dialog.open() == 0) {
                        ParameterSet newPValue = dialog.getPValue();
                        tableItem = new TableItem(this.table, 0);
                        tableItem.setData("com.jaspersoft.studio.parameterset", (Object)newPValue);
                        tableItem.setText(0, newPValue.getName());
                    } else {
                        return;
                    }
                }
            }
        }
        this.table.setSelection(this.table.getItemCount());
        this.table.showItem(this.table.getItem(this.table.getItemCount() - 1));
        this.table.showSelection();
        this.table.showColumn(this.table.getColumn(0));
        this.selectionChanged();
    }

    private void editPressed() {
        int selIdx = this.table.getSelectionIndex();
        if (selIdx != -1) {
            ParameterSetDialog dialog;
            TableItem item = this.table.getItem(selIdx);
            ParameterSet pvalue = (ParameterSet)item.getData("com.jaspersoft.studio.parameterset");
            if (pvalue == null) {
                pvalue = ParameterSetProvider.getParameterSet(item.getText(0), this.getPreferenceStore());
            }
            if (pvalue != null && (dialog = new ParameterSetDialog(UIUtils.getShell(), selIdx, pvalue, this.table)).open() == 0) {
                ParameterSet newPValue = dialog.getPValue();
                item.setData("com.jaspersoft.studio.parameterset", (Object)newPValue);
                item.setText(0, newPValue.getName());
            }
        }
    }

    @Override
    protected void selectionChanged() {
        boolean isMultiSelection;
        super.selectionChanged();
        int index = this.table.getSelectionIndex();
        int size = this.table.getItemCount();
        boolean bl = isMultiSelection = this.table.getSelectionCount() > 1;
        if (this.editButton != null) {
            this.editButton.setEnabled(!isMultiSelection && size >= 1 && index >= 0 && index < size && this.isEditable(index));
        }
    }

    protected boolean isEditable(int row) {
        return true;
    }

    @Override
    protected void createButtons(Composite box) {
        this.addButton = this.createPushButton(box, Messages.common_add);
        this.duplicateButton = this.createPushButton(box, Messages.PropertyListFieldEditor_duplicateButton);
        this.removeButton = this.createPushButton(box, Messages.common_delete);
        this.editButton = this.createPushButton(box, Messages.common_edit);
    }

    @Override
    protected String[] getNewInputObject() {
        return null;
    }
}

