/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property;

import com.jaspersoft.studio.model.APropertyNode;
import net.sf.jasperreports.engine.design.JRDesignElement;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;

public class SetBoundCommand
extends Command {
    protected Rectangle boundNewValue = null;
    protected Rectangle undoValue = null;
    protected APropertyNode target = null;

    public SetBoundCommand() {
        super("Set Bound Command");
    }

    public boolean canExecute() {
        return this.boundNewValue != null && this.target != null && this.target.getValue() != null;
    }

    public void setContext(APropertyNode target, Rectangle newBound) {
        this.target = target;
        this.boundNewValue = newBound;
    }

    public void execute() {
        JRDesignElement element = (JRDesignElement)this.target.getValue();
        this.undoValue = new Rectangle(element.getX(), element.getY(), element.getWidth(), element.getHeight());
        this.target.setPropertyValue("x", this.boundNewValue.x);
        this.target.setPropertyValue("y", this.boundNewValue.y);
        this.target.setPropertyValue("width", this.boundNewValue.width);
        this.target.setPropertyValue("height", this.boundNewValue.height);
    }

    public boolean canUndo() {
        return this.undoValue != null;
    }

    public void undo() {
        if (this.canUndo()) {
            this.target.setPropertyValue("x", this.undoValue.x);
            this.target.setPropertyValue("y", this.undoValue.y);
            this.target.setPropertyValue("width", this.undoValue.width);
            this.target.setPropertyValue("height", this.undoValue.height);
        }
    }
}

