/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.color.chooser;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.property.color.chooser.BluBasedSelector;
import com.jaspersoft.studio.property.color.chooser.BrightnessBasedSelector;
import com.jaspersoft.studio.property.color.chooser.ColorPreviewWidget;
import com.jaspersoft.studio.property.color.chooser.ColorsSelectorWidget;
import com.jaspersoft.studio.property.color.chooser.GreenBasedSelector;
import com.jaspersoft.studio.property.color.chooser.HueBasedSelector;
import com.jaspersoft.studio.property.color.chooser.IColorProvider;
import com.jaspersoft.studio.property.color.chooser.IWidgetGovernor;
import com.jaspersoft.studio.property.color.chooser.RedBasedSelector;
import com.jaspersoft.studio.property.color.chooser.SaturationBasedSelector;
import com.jaspersoft.studio.utils.AlfaRGB;
import com.jaspersoft.studio.utils.ImageUtils;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.Robot;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wb.swt.ResourceManager;

public class AdvancedColorWidget
extends Composite
implements IColorProvider {
    private ColorsSelectorWidget colorsSelector;
    private ColorPreviewWidget previewComposite = null;
    private Scale alphaSlider = null;
    private Spinner alphaText = null;
    private int alpha = 255;
    private List<Button> radioList = new ArrayList<Button>();
    private Spinner hue = null;
    private Spinner saturation = null;
    private Spinner brightness = null;
    private Spinner red = null;
    private Spinner green = null;
    private Spinner blue = null;
    private Text hex = null;
    private Button pickColorButton;
    private Boolean modfiedGuard = true;
    private Font buttonFont = ResourceManager.getFont((String)"Arial", (int)9, (int)1);
    private static final int TIMER_INTERVAL = 50;
    private boolean hideSliderBar = false;
    private boolean isAcquiring = false;
    private RGB oldColor = null;
    private AlfaRGB newColor = null;
    private ColorPickerThreadClass colorPickerThread = new ColorPickerThreadClass();
    private ModifyListener valueModifedListener = new ModifyListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void modifyText(ModifyEvent e) {
            Boolean bl = AdvancedColorWidget.this.modfiedGuard;
            synchronized (bl) {
                if (AdvancedColorWidget.this.modfiedGuard.booleanValue()) {
                    AlfaRGB rgbColor;
                    AdvancedColorWidget.this.modfiedGuard = false;
                    AdvancedColorWidget.this.hue.getParent().getParent().setRedraw(false);
                    if (e.widget == AdvancedColorWidget.this.hue || e.widget == AdvancedColorWidget.this.saturation || e.widget == AdvancedColorWidget.this.brightness) {
                        float h = AdvancedColorWidget.this.hue.getSelection();
                        float s = (float)AdvancedColorWidget.this.saturation.getSelection() / 100.0f;
                        float b = (float)AdvancedColorWidget.this.brightness.getSelection() / 100.0f;
                        AdvancedColorWidget.this.colorsSelector.setSelectedColor(h, s, b, false);
                        AdvancedColorWidget.this.updateText(h, s, b, e.widget);
                    } else if (e.widget == AdvancedColorWidget.this.red || e.widget == AdvancedColorWidget.this.green || e.widget == AdvancedColorWidget.this.blue) {
                        RGB rgbColor2 = new RGB(AdvancedColorWidget.this.red.getSelection(), AdvancedColorWidget.this.green.getSelection(), AdvancedColorWidget.this.blue.getSelection());
                        AdvancedColorWidget.this.colorsSelector.setSelectedColor(rgbColor2, false);
                        AdvancedColorWidget.this.updateText(rgbColor2, rgbColor2.getHSB(), e.widget);
                    } else if (e.widget == AdvancedColorWidget.this.hex && (rgbColor = AdvancedColorWidget.this.hexParser(AdvancedColorWidget.this.hex.getText())) != null) {
                        AdvancedColorWidget.this.colorsSelector.setSelectedColor(rgbColor.getRgb(), false);
                        if (AdvancedColorWidget.this.alphaText != null) {
                            AdvancedColorWidget.this.alphaText.setSelection(rgbColor.getAlfa());
                        }
                        AdvancedColorWidget.this.updateText(rgbColor.getRgb(), rgbColor.getRgb().getHSB(), e.widget);
                    }
                    AdvancedColorWidget.this.hue.getParent().getParent().setRedraw(true);
                    AdvancedColorWidget.this.modfiedGuard = true;
                }
            }
        }
    };
    private Listener spaceKeyListener = new Listener(){

        public void handleEvent(Event e) {
            if (e.keyCode == 32) {
                if (!AdvancedColorWidget.this.isAcquiring) {
                    AdvancedColorWidget.this.isAcquiring = true;
                    AdvancedColorWidget.this.colorPickerThread.setStop(false);
                    Display.getCurrent().timerExec(50, (Runnable)AdvancedColorWidget.this.colorPickerThread);
                    AdvancedColorWidget.this.pickColorButton.setImage(null);
                    AdvancedColorWidget.this.pickColorButton.setText(Messages.ColorDialog_stopPickingActionText);
                    AdvancedColorWidget.this.pickColorButton.setEnabled(false);
                    AdvancedColorWidget.this.pickColorButton.setLayoutData((Object)new GridData(1808));
                    AdvancedColorWidget.this.pickColorButton.getParent().layout(true, true);
                } else {
                    AdvancedColorWidget.this.stopPickerThread();
                    AdvancedColorWidget.this.isAcquiring = false;
                }
            }
        }
    };

    public AdvancedColorWidget(Composite parent, int style, AlfaRGB oldColor, boolean showAlpha) {
        super(parent, style);
        if (oldColor != null) {
            this.oldColor = oldColor.getRgb();
            this.alpha = oldColor.getAlfa();
        }
        boolean bl = this.hideSliderBar = !showAlpha;
        if (this.hideSliderBar) {
            this.alpha = 255;
        }
        this.setLayout((Layout)new GridLayout(2, false));
        RGB initialColor = this.oldColor != null ? this.oldColor : new RGB(255, 255, 255);
        this.colorsSelector = new ColorsSelectorWidget(this, 0, new HueBasedSelector(), initialColor);
        GridData rectangleData = new GridData(1808);
        rectangleData.widthHint = 250;
        rectangleData.heightHint = 150;
        this.colorsSelector.setLayoutData(rectangleData);
        this.colorsSelector.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdvancedColorWidget.this.updateText();
            }
        });
        Composite righSide = new Composite((Composite)this, 0);
        righSide.setLayout((Layout)new GridLayout(1, false));
        righSide.setLayoutData((Object)new GridData(1808));
        this.previewComposite = new ColorPreviewWidget(righSide, 0);
        if (oldColor != null) {
            this.previewComposite.setOldColor(this.oldColor, this.alpha);
        }
        this.previewComposite.setLayoutData(new GridData(1808));
        this.createColorPicker(this.previewComposite.getAdditionalComponentarea());
        if (!this.hideSliderBar) {
            this.createSlider(righSide);
        }
        this.createTextArea(righSide);
        this.updateText();
        PlatformUI.getWorkbench().getDisplay().addFilter(1, this.spaceKeyListener);
    }

    @Override
    public AlfaRGB getSelectedColor() {
        return this.newColor;
    }

    private AlfaRGB hexParser(String text) {
        AlfaRGB newColor = null;
        try {
            if (text.startsWith("#") && text.length() == 7) {
                newColor = AlfaRGB.getFullyOpaque(new RGB(Integer.valueOf(text.substring(1, 3), 16).intValue(), Integer.valueOf(text.substring(3, 5), 16).intValue(), Integer.valueOf(text.substring(5, 7), 16).intValue()));
            } else if (!text.startsWith("#") && text.length() == 6) {
                newColor = AlfaRGB.getFullyOpaque(new RGB(Integer.valueOf(text.substring(0, 2), 16).intValue(), Integer.valueOf(text.substring(2, 4), 16).intValue(), Integer.valueOf(text.substring(4, 6), 16).intValue()));
            } else {
                boolean colsedBars;
                String[] components = text.split(",");
                int[] nArray = new int[4];
                nArray[3] = 255;
                int[] resultComp = nArray;
                boolean bl = colsedBars = text.contains("[") && text.contains("]") || text.contains("(") && text.contains(")") || text.contains("{") && text.contains("}") || !text.contains("{") && !text.contains("[") && !text.contains("(");
                if (components.length > 2 && colsedBars) {
                    int i = 0;
                    while (i < components.length && i < 4) {
                        String component = components[i].replaceAll("[^\\d]", "");
                        resultComp[i] = Integer.valueOf(component);
                        ++i;
                    }
                    newColor = new AlfaRGB(new RGB(resultComp[0], resultComp[1], resultComp[2]), resultComp[3]);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        return newColor;
    }

    private String getHexFromRGB(RGB color) {
        int r = color.red;
        int g = color.green;
        int b = color.blue;
        String s = String.valueOf(StringUtils.leftPad((String)Integer.toHexString(r), (int)2, (String)"0")) + StringUtils.leftPad((String)Integer.toHexString(g), (int)2, (String)"0") + StringUtils.leftPad((String)Integer.toHexString(b), (int)2, (String)"0");
        return "#" + s.toUpperCase();
    }

    private void updateText() {
        this.updateText(this.colorsSelector.getSelectedColorRGB(), this.colorsSelector.getSelectedColorHSB(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateText(RGB color, float[] hsb, Widget source) {
        Boolean bl = this.modfiedGuard;
        synchronized (bl) {
            this.modfiedGuard = false;
            this.hue.getParent().getParent().setRedraw(false);
            if (this.red != source) {
                this.red.setSelection(color.red);
            }
            if (this.green != source) {
                this.green.setSelection(color.green);
            }
            if (this.blue != source) {
                this.blue.setSelection(color.blue);
            }
            this.hex.setText(this.getHexFromRGB(color));
            int h = Math.round(hsb[0]);
            int s = Math.round(hsb[1] * 100.0f);
            int b = Math.round(hsb[2] * 100.0f);
            if (this.hue != source) {
                this.hue.setSelection(h);
            }
            if (this.saturation != source) {
                this.saturation.setSelection(s);
            }
            if (this.brightness != source) {
                this.brightness.setSelection(b);
            }
            this.hue.getParent().getParent().setRedraw(true);
            this.updatePreview();
            this.modfiedGuard = true;
        }
    }

    private void updatePreview() {
        this.newColor = new AlfaRGB(this.colorsSelector.getSelectedColorRGB(), this.alpha);
        this.previewComposite.setNewColor(this.colorsSelector.getSelectedColorRGB(), this.alpha);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateText(float fh, float fs, float fb, Widget source) {
        Boolean bl = this.modfiedGuard;
        synchronized (bl) {
            this.modfiedGuard = false;
            this.hue.getParent().getParent().setRedraw(false);
            int h = Math.round(fh);
            int s = Math.round(fs * 100.0f);
            int b = Math.round(fb * 100.0f);
            if (this.hue != source) {
                this.hue.setSelection(h);
            }
            if (this.saturation != source) {
                this.saturation.setSelection(s);
            }
            if (this.brightness != source) {
                this.brightness.setSelection(b);
            }
            RGB color = new RGB(fh, fs, fb);
            if (this.red != source) {
                this.red.setSelection(color.red);
            }
            if (this.green != source) {
                this.green.setSelection(color.green);
            }
            if (this.blue != source) {
                this.blue.setSelection(color.blue);
            }
            this.hex.setText(this.getHexFromRGB(color));
            this.hue.getParent().getParent().setRedraw(true);
            this.updatePreview();
            this.modfiedGuard = true;
        }
    }

    private void createColorPicker(Composite parent) {
        this.pickColorButton = new Button(parent, 64);
        this.pickColorButton.setToolTipText(Messages.ColorDialog_pickerButtonTooltip);
        this.pickColorButton.setFont(this.buttonFont);
        this.pickColorButton.setAlignment(0x1000000);
        GridData buttonData = new GridData();
        buttonData.widthHint = 50;
        buttonData.heightHint = 50;
        buttonData.verticalAlignment = 0x1000000;
        this.pickColorButton.setLayoutData((Object)buttonData);
        this.pickColorButton.setText("");
        this.pickColorButton.setImage(this.getPickerImage(24));
        this.pickColorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdvancedColorWidget.this.isAcquiring = true;
                AdvancedColorWidget.this.colorPickerThread.setStop(false);
                Display.getCurrent().timerExec(50, (Runnable)AdvancedColorWidget.this.colorPickerThread);
                AdvancedColorWidget.this.pickColorButton.setImage(null);
                AdvancedColorWidget.this.pickColorButton.setText(Messages.ColorDialog_stopPickingActionText);
                AdvancedColorWidget.this.pickColorButton.setEnabled(false);
                AdvancedColorWidget.this.pickColorButton.setLayoutData((Object)new GridData(1808));
                AdvancedColorWidget.this.pickColorButton.getParent().layout(true, true);
            }
        });
    }

    private Image getPickerImage(int size) {
        String key = "pickerIcon" + String.valueOf(size);
        Image result = ResourceManager.getImage((String)key);
        if (result == null) {
            int whitePixel;
            result = ImageUtils.resize(ResourceManager.getPluginImage((String)"com.jaspersoft.studio", (String)"/icons/resources/picker.png"), size, size);
            ImageData data = result.getImageData();
            result.dispose();
            data.transparentPixel = whitePixel = data.palette.getPixel(new RGB(255, 255, 255));
            result = new Image((Device)Display.getCurrent(), data);
            ResourceManager.addImage((String)key, (Image)result);
        }
        return result;
    }

    private void createSlider(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(3, false));
        container.setLayoutData((Object)new GridData(1808));
        new Label(container, 0).setText(Messages.ColorDialog_transparencyLabel);
        this.alphaSlider = new Scale(container, 256);
        this.alphaSlider.setMaximum(0);
        this.alphaSlider.setMaximum(255);
        this.alphaSlider.setSelection(this.alpha);
        this.alphaSlider.setLayoutData((Object)new GridData(768));
        this.alphaText = new Spinner(container, 2048);
        this.alphaText.setMinimum(0);
        this.alphaText.setMaximum(255);
        this.alphaText.setSelection(this.alpha);
        this.alphaSlider.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdvancedColorWidget.this.alphaText.setSelection(AdvancedColorWidget.this.alphaSlider.getSelection());
                AdvancedColorWidget.this.alpha = AdvancedColorWidget.this.alphaSlider.getSelection();
                AdvancedColorWidget.this.updatePreview();
            }
        });
        this.alphaText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AdvancedColorWidget.this.alphaSlider.setSelection(AdvancedColorWidget.this.alphaText.getSelection());
                AdvancedColorWidget.this.alpha = AdvancedColorWidget.this.alphaSlider.getSelection();
                AdvancedColorWidget.this.updatePreview();
            }
        });
    }

    private void createTextArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        container.setLayoutData((Object)new GridData(1808));
        Composite leftPart = new Composite(container, 0);
        leftPart.setLayout((Layout)new GridLayout(3, false));
        leftPart.setLayoutData((Object)new GridData(1808));
        Composite rightPart = new Composite(container, 0);
        rightPart.setLayout((Layout)new GridLayout(3, false));
        rightPart.setLayoutData((Object)new GridData(1808));
        this.hue = this.createRadio(leftPart, "H:", "\u030a", new HueBasedSelector(), true, 0, 360);
        this.saturation = this.createRadio(leftPart, "S:", "%", new SaturationBasedSelector(), false, 0, 100);
        this.brightness = this.createRadio(leftPart, "B:", "%", new BrightnessBasedSelector(), false, 0, 100);
        this.red = this.createRadio(rightPart, "R:", " ", new RedBasedSelector(), false, 0, 255);
        this.green = this.createRadio(rightPart, "G:", " ", new GreenBasedSelector(), false, 0, 255);
        this.blue = this.createRadio(rightPart, "B:", " ", new BluBasedSelector(), false, 0, 255);
        this.hex = this.createText(leftPart, "Hex:", "");
    }

    private Text createText(Composite parent, String title, String suffix) {
        new Label(parent, 0).setText(title);
        Text actualText = new Text(parent, 2048);
        actualText.setLayoutData((Object)new GridData(768));
        if (suffix != null) {
            new Label(parent, 0).setText(suffix);
        } else {
            new Label(parent, 0);
        }
        actualText.addModifyListener(this.valueModifedListener);
        return actualText;
    }

    private Spinner createRadio(Composite parent, String title, String suffix, IWidgetGovernor governor, boolean defaultEnabled, int min, int max) {
        final Button radio = new Button(parent, 16);
        this.radioList.add(radio);
        radio.setText(title);
        radio.setData((Object)governor);
        radio.setSelection(defaultEnabled);
        radio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (radio.getSelection()) {
                    AdvancedColorWidget.this.disableAllRadioExceptOne(radio);
                    AdvancedColorWidget.this.colorsSelector.setGovernor((IWidgetGovernor)radio.getData());
                }
            }
        });
        Spinner actualText = new Spinner(parent, 2048);
        actualText.setMinimum(min);
        actualText.setMaximum(max);
        actualText.setLayoutData((Object)new GridData(768));
        if (suffix != null) {
            new Label(parent, 0).setText(suffix);
        } else {
            new Label(parent, 0);
        }
        actualText.addModifyListener(this.valueModifedListener);
        return actualText;
    }

    private void disableAllRadioExceptOne(Button excludedRadio) {
        for (Button radio : this.radioList) {
            if (!radio.getSelection() || radio == excludedRadio) continue;
            radio.setSelection(false);
        }
    }

    private void checkColorPicker() {
        if (!this.isDisposed() && (this.getShell().isFocusControl() || this.checkControlFocused(this.getShell().getChildren()))) {
            try {
                Robot robot = new Robot();
                Point pos = Display.getCurrent().getCursorLocation();
                Color color = robot.getPixelColor(pos.x, pos.y);
                RGB rgbColor = new RGB(color.getRed(), color.getGreen(), color.getBlue());
                this.colorsSelector.setSelectedColor(rgbColor, false);
                this.updateText(rgbColor, rgbColor.getHSB(), null);
            }
            catch (AWTException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean checkControlFocused(Control[] controls) {
        Control[] controlArray = controls;
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Composite comp;
            boolean childrenFocused;
            Control control = controlArray[n2];
            if (control.isFocusControl()) {
                return true;
            }
            if (control instanceof Composite && (childrenFocused = this.checkControlFocused((comp = (Composite)control).getChildren()))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void stopPickerThread() {
        this.colorPickerThread.setStop(true);
        if (!this.pickColorButton.isDisposed()) {
            this.pickColorButton.setText("");
            this.pickColorButton.setImage(this.getPickerImage(24));
            this.pickColorButton.setEnabled(true);
            GridData buttonData = new GridData();
            buttonData.widthHint = 50;
            buttonData.heightHint = 50;
            this.pickColorButton.setLayoutData((Object)buttonData);
            this.pickColorButton.getParent().layout(true, true);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        PlatformUI.getWorkbench().getDisplay().removeFilter(1, this.spaceKeyListener);
        this.stopPickerThread();
    }

    private class ColorPickerThreadClass
    implements Runnable {
        private Boolean stopThread = false;

        private ColorPickerThreadClass() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean getStop() {
            ColorPickerThreadClass colorPickerThreadClass = this;
            synchronized (colorPickerThreadClass) {
                return this.stopThread;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setStop(boolean value) {
            ColorPickerThreadClass colorPickerThreadClass = this;
            synchronized (colorPickerThreadClass) {
                this.stopThread = value;
            }
        }

        @Override
        public void run() {
            if (!this.getStop()) {
                AdvancedColorWidget.this.checkColorPicker();
                Display.getCurrent().timerExec(50, (Runnable)this);
            }
        }
    }
}

