/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.color.chooser;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.property.color.chooser.ColorPreviewWidget;
import com.jaspersoft.studio.property.color.chooser.IColorProvider;
import com.jaspersoft.studio.utils.AlfaRGB;
import com.jaspersoft.studio.utils.ModelUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wb.swt.ResourceCache;

public class LastUsedColorsWidget
extends Composite
implements IColorProvider {
    private static List<AlfaRGB> usedColors = new ArrayList<AlfaRGB>();
    private ResourceCache imagesCache = new ResourceCache();
    private Composite colorComposite;
    private AlfaRGB selectedColor = null;
    private ColorPreviewWidget previewArea;
    private Label red;
    private Label green;
    private Label blue;
    private Label hue;
    private Label brightness;
    private Label saturation;
    private Label alpha;
    private MouseAdapter colorSelectedAdapter = new MouseAdapter(){

        public void mouseDown(MouseEvent e) {
            LastUsedColorsWidget.this.selectedColor = (AlfaRGB)e.widget.getData();
            LastUsedColorsWidget.this.previewArea.setNewColor(LastUsedColorsWidget.this.selectedColor.getRgb(), LastUsedColorsWidget.this.selectedColor.getAlfa());
            LastUsedColorsWidget.this.updateLabels();
        }
    };

    public LastUsedColorsWidget(Composite parent, int style, AlfaRGB oldColor) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(2, false));
        this.selectedColor = AlfaRGB.getFullyOpaque(new RGB(0, 0, 0));
        this.colorComposite = new Composite((Composite)this, 0);
        this.colorComposite.setLayoutData((Object)new GridData(1808));
        this.colorComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                LastUsedColorsWidget.this.paintPad();
            }
        });
        Composite rightPanel = new Composite((Composite)this, 0);
        rightPanel.setLayout((Layout)new GridLayout(1, false));
        this.previewArea = new ColorPreviewWidget(rightPanel, 0);
        if (oldColor != null) {
            this.previewArea.setOldColor(oldColor.getRgb(), oldColor.getAlfa());
        }
        this.previewArea.setNewColor(this.selectedColor.getRgb(), this.selectedColor.getAlfa());
        Composite textualInformation = new Composite(rightPanel, 0);
        textualInformation.setLayout((Layout)new GridLayout(4, false));
        textualInformation.setLayoutData((Object)new GridData(768));
        this.red = this.createLabel("R:", textualInformation);
        this.hue = this.createLabel("H:", textualInformation);
        this.green = this.createLabel("G:", textualInformation);
        this.saturation = this.createLabel("S:", textualInformation);
        this.blue = this.createLabel("B:", textualInformation);
        this.brightness = this.createLabel("B:", textualInformation);
        this.alpha = this.createLabel(String.valueOf(Messages.ColorDialog_transparencyLabel) + ":", textualInformation);
        this.updateLabels();
    }

    @Override
    public AlfaRGB getSelectedColor() {
        return this.selectedColor;
    }

    public static boolean hasColors() {
        return usedColors.size() > 0;
    }

    public static boolean addColor(AlfaRGB color) {
        if (color != null && !usedColors.contains(color)) {
            usedColors.add(0, color);
            if (usedColors.size() > 256) {
                usedColors.remove(usedColors.size() - 1);
            }
            return true;
        }
        return false;
    }

    private void updateLabels() {
        RGB selectedRGB = this.selectedColor.getRgb();
        this.red.setText(String.valueOf(selectedRGB.red));
        this.green.setText(String.valueOf(selectedRGB.green));
        this.blue.setText(String.valueOf(selectedRGB.blue));
        float[] hsb = selectedRGB.getHSB();
        this.hue.setText(String.valueOf(Math.round(hsb[0])));
        this.saturation.setText(String.valueOf(String.valueOf(Math.round(hsb[1] * 100.0f))) + "%");
        this.brightness.setText(String.valueOf(String.valueOf(Math.round(hsb[1] * 100.0f))) + "%");
        this.alpha.setText(String.valueOf(this.selectedColor.getAlfa()));
    }

    private Label createLabel(String preText, Composite parent) {
        new Label(parent, 0).setText(preText);
        Label result = new Label(parent, 0);
        result.setLayoutData((Object)new GridData(768));
        return result;
    }

    private void paintPad() {
        Control[] controlArray = this.colorComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        Rectangle rect = this.colorComposite.getClientArea();
        int sampleSize = 22;
        int spaceBetween = 1;
        int samplesRow = 18;
        int samplesColumn = 216 / samplesRow;
        boolean enoughSize = false;
        while (!enoughSize && sampleSize != 0) {
            boolean enoughWidth;
            boolean enoughHeight = sampleSize * samplesColumn + spaceBetween * (samplesColumn - 1) < rect.height;
            enoughSize = enoughHeight & (enoughWidth = sampleSize * samplesRow + spaceBetween * (samplesRow - 1) < rect.width);
            if (enoughSize) continue;
            --sampleSize;
        }
        GridLayout colorLayout = new GridLayout(samplesRow, true);
        colorLayout.horizontalSpacing = spaceBetween;
        colorLayout.verticalSpacing = spaceBetween;
        this.colorComposite.setLayout((Layout)colorLayout);
        Iterator<AlfaRGB> colorIt = usedColors.iterator();
        int i = 0;
        while (i < samplesColumn && colorIt.hasNext()) {
            int j = 0;
            while (j < samplesRow && colorIt.hasNext()) {
                Canvas canv = new Canvas(this.colorComposite, 0){

                    public void setBackground(Color color) {
                        if (ModelUtils.safeEquals(color.getRGB(), ((AlfaRGB)this.getData()).getRgb())) {
                            super.setBackground(color);
                        }
                    }

                    protected void checkSubclass() {
                    }
                };
                GridData canvData = new GridData();
                canvData.widthHint = sampleSize;
                canvData.heightHint = sampleSize;
                canv.setLayoutData((Object)canvData);
                AlfaRGB actualColor = colorIt.next();
                canv.setData((Object)actualColor);
                canv.setBackground(this.imagesCache.getColor(actualColor.getRgb()));
                canv.addMouseListener((MouseListener)this.colorSelectedAdapter);
                ++j;
            }
            ++i;
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.imagesCache.dispose();
    }
}

