/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.color.chooser;

import com.jaspersoft.studio.property.color.chooser.ColorPreviewWidget;
import com.jaspersoft.studio.property.color.chooser.IColorProvider;
import com.jaspersoft.studio.utils.AlfaRGB;
import com.jaspersoft.studio.utils.ModelUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wb.swt.ResourceCache;

public class WebColorsWidget
extends Composite
implements IColorProvider {
    private static final List<RGB> webColors = WebColorsWidget.getWebColors();
    private ResourceCache imagesCache = new ResourceCache();
    private Composite colorComposite;
    private AlfaRGB selectedColor = null;
    private ColorPreviewWidget previewArea;
    private Label red;
    private Label green;
    private Label blue;
    private Label hue;
    private Label brightness;
    private Label saturation;
    private MouseAdapter colorSelectedAdapter = new MouseAdapter(){

        public void mouseDown(MouseEvent e) {
            WebColorsWidget.this.selectedColor = AlfaRGB.getFullyOpaque((RGB)e.widget.getData());
            WebColorsWidget.this.previewArea.setNewColor(WebColorsWidget.this.selectedColor.getRgb(), WebColorsWidget.this.selectedColor.getAlfa());
            WebColorsWidget.this.updateLabels();
        }
    };

    public WebColorsWidget(Composite parent, int style, AlfaRGB oldColor) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(2, false));
        this.selectedColor = AlfaRGB.getFullyOpaque(webColors.get(0));
        this.colorComposite = new Composite((Composite)this, 0);
        GridData rectangleData = new GridData(1808);
        rectangleData.minimumWidth = 350;
        rectangleData.minimumHeight = 250;
        this.colorComposite.setLayoutData((Object)rectangleData);
        this.colorComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                WebColorsWidget.this.paintPad();
            }
        });
        Composite rightPanel = new Composite((Composite)this, 0);
        rightPanel.setLayout((Layout)new GridLayout(1, false));
        this.previewArea = new ColorPreviewWidget(rightPanel, 0);
        if (oldColor != null) {
            this.previewArea.setOldColor(oldColor.getRgb(), oldColor.getAlfa());
        }
        this.previewArea.setNewColor(this.selectedColor.getRgb(), this.selectedColor.getAlfa());
        Composite textualInformation = new Composite(rightPanel, 0);
        textualInformation.setLayout((Layout)new GridLayout(4, false));
        textualInformation.setLayoutData((Object)new GridData(768));
        this.red = this.createLabel("R:", textualInformation);
        this.hue = this.createLabel("H:", textualInformation);
        this.green = this.createLabel("G:", textualInformation);
        this.saturation = this.createLabel("S:", textualInformation);
        this.blue = this.createLabel("B:", textualInformation);
        this.brightness = this.createLabel("B:", textualInformation);
        this.updateLabels();
    }

    @Override
    public AlfaRGB getSelectedColor() {
        return this.selectedColor;
    }

    private void updateLabels() {
        RGB selectedRGB = this.selectedColor.getRgb();
        this.red.setText(String.valueOf(selectedRGB.red));
        this.green.setText(String.valueOf(selectedRGB.green));
        this.blue.setText(String.valueOf(selectedRGB.blue));
        float[] hsb = selectedRGB.getHSB();
        this.hue.setText(String.valueOf(Math.round(hsb[0])));
        this.saturation.setText(String.valueOf(String.valueOf(Math.round(hsb[1] * 100.0f))) + "%");
        this.brightness.setText(String.valueOf(String.valueOf(Math.round(hsb[2] * 100.0f))) + "%");
    }

    private Label createLabel(String preText, Composite parent) {
        new Label(parent, 0).setText(preText);
        Label result = new Label(parent, 0);
        result.setLayoutData((Object)new GridData(768));
        return result;
    }

    private void paintPad() {
        Control[] controlArray = this.colorComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        Rectangle rect = this.colorComposite.getClientArea();
        int sampleSize = 22;
        int spaceBetween = 1;
        int samplesRow = 18;
        int samplesColumn = 216 / samplesRow;
        boolean enoughSize = false;
        while (!enoughSize && sampleSize != 0) {
            boolean enoughWidth;
            boolean enoughHeight = sampleSize * samplesColumn + spaceBetween * (samplesColumn - 1) < rect.height;
            enoughSize = enoughHeight & (enoughWidth = sampleSize * samplesRow + spaceBetween * (samplesRow - 1) < rect.width);
            if (enoughSize) continue;
            --sampleSize;
        }
        GridLayout colorLayout = new GridLayout(samplesRow, true);
        colorLayout.horizontalSpacing = spaceBetween;
        colorLayout.verticalSpacing = spaceBetween;
        this.colorComposite.setLayout((Layout)colorLayout);
        Iterator<RGB> colorIt = webColors.iterator();
        int i = 0;
        while (i < samplesColumn) {
            int j = 0;
            while (j < samplesRow) {
                Canvas canv = new Canvas(this.colorComposite, 0){

                    public void setBackground(Color color) {
                        if (ModelUtils.safeEquals(color.getRGB(), this.getData())) {
                            super.setBackground(color);
                        }
                    }

                    protected void checkSubclass() {
                    }
                };
                GridData canvData = new GridData();
                canvData.widthHint = sampleSize;
                canvData.heightHint = sampleSize;
                canv.setLayoutData((Object)canvData);
                RGB actualColor = colorIt.next();
                canv.setData((Object)actualColor);
                canv.setBackground(this.imagesCache.getColor(actualColor));
                canv.addMouseListener((MouseListener)this.colorSelectedAdapter);
                ++j;
            }
            ++i;
        }
    }

    private static ArrayList<RGB> getWebColors() {
        ArrayList<RGB> result = new ArrayList<RGB>();
        result.add(new RGB(255, 255, 255));
        result.add(new RGB(255, 255, 204));
        result.add(new RGB(255, 255, 153));
        result.add(new RGB(255, 255, 102));
        result.add(new RGB(255, 255, 51));
        result.add(new RGB(255, 255, 0));
        result.add(new RGB(255, 204, 255));
        result.add(new RGB(255, 204, 204));
        result.add(new RGB(255, 204, 153));
        result.add(new RGB(255, 204, 102));
        result.add(new RGB(255, 204, 51));
        result.add(new RGB(255, 204, 0));
        result.add(new RGB(255, 153, 255));
        result.add(new RGB(255, 153, 204));
        result.add(new RGB(255, 153, 153));
        result.add(new RGB(255, 153, 102));
        result.add(new RGB(255, 153, 51));
        result.add(new RGB(255, 153, 0));
        result.add(new RGB(255, 102, 255));
        result.add(new RGB(255, 102, 204));
        result.add(new RGB(255, 102, 153));
        result.add(new RGB(255, 102, 102));
        result.add(new RGB(255, 102, 51));
        result.add(new RGB(255, 102, 0));
        result.add(new RGB(255, 51, 255));
        result.add(new RGB(255, 51, 204));
        result.add(new RGB(255, 51, 153));
        result.add(new RGB(255, 51, 102));
        result.add(new RGB(255, 51, 51));
        result.add(new RGB(255, 51, 0));
        result.add(new RGB(255, 0, 255));
        result.add(new RGB(255, 0, 204));
        result.add(new RGB(255, 0, 153));
        result.add(new RGB(255, 0, 102));
        result.add(new RGB(255, 0, 51));
        result.add(new RGB(255, 0, 0));
        result.add(new RGB(204, 255, 255));
        result.add(new RGB(204, 255, 204));
        result.add(new RGB(204, 255, 153));
        result.add(new RGB(204, 255, 102));
        result.add(new RGB(204, 255, 51));
        result.add(new RGB(204, 255, 0));
        result.add(new RGB(204, 204, 255));
        result.add(new RGB(204, 204, 204));
        result.add(new RGB(204, 204, 153));
        result.add(new RGB(204, 204, 102));
        result.add(new RGB(204, 204, 51));
        result.add(new RGB(204, 204, 0));
        result.add(new RGB(204, 153, 255));
        result.add(new RGB(204, 153, 204));
        result.add(new RGB(204, 153, 153));
        result.add(new RGB(204, 153, 102));
        result.add(new RGB(204, 153, 51));
        result.add(new RGB(204, 153, 0));
        result.add(new RGB(204, 102, 255));
        result.add(new RGB(204, 102, 204));
        result.add(new RGB(204, 102, 153));
        result.add(new RGB(204, 102, 102));
        result.add(new RGB(204, 102, 51));
        result.add(new RGB(204, 102, 0));
        result.add(new RGB(204, 51, 255));
        result.add(new RGB(204, 51, 204));
        result.add(new RGB(204, 51, 153));
        result.add(new RGB(204, 51, 102));
        result.add(new RGB(204, 51, 51));
        result.add(new RGB(204, 51, 0));
        result.add(new RGB(204, 0, 255));
        result.add(new RGB(204, 0, 204));
        result.add(new RGB(204, 0, 153));
        result.add(new RGB(204, 0, 102));
        result.add(new RGB(204, 0, 51));
        result.add(new RGB(204, 0, 0));
        result.add(new RGB(153, 255, 255));
        result.add(new RGB(153, 255, 204));
        result.add(new RGB(153, 255, 153));
        result.add(new RGB(153, 255, 102));
        result.add(new RGB(153, 255, 51));
        result.add(new RGB(153, 255, 0));
        result.add(new RGB(153, 204, 255));
        result.add(new RGB(153, 204, 204));
        result.add(new RGB(153, 204, 153));
        result.add(new RGB(153, 204, 102));
        result.add(new RGB(153, 204, 51));
        result.add(new RGB(153, 204, 0));
        result.add(new RGB(153, 153, 255));
        result.add(new RGB(153, 153, 204));
        result.add(new RGB(153, 153, 153));
        result.add(new RGB(153, 153, 102));
        result.add(new RGB(153, 153, 51));
        result.add(new RGB(153, 153, 0));
        result.add(new RGB(153, 102, 255));
        result.add(new RGB(153, 102, 204));
        result.add(new RGB(153, 102, 153));
        result.add(new RGB(153, 102, 102));
        result.add(new RGB(153, 102, 51));
        result.add(new RGB(153, 102, 0));
        result.add(new RGB(153, 51, 255));
        result.add(new RGB(153, 51, 204));
        result.add(new RGB(153, 51, 153));
        result.add(new RGB(153, 51, 102));
        result.add(new RGB(153, 51, 51));
        result.add(new RGB(153, 51, 0));
        result.add(new RGB(153, 0, 255));
        result.add(new RGB(153, 0, 204));
        result.add(new RGB(153, 0, 153));
        result.add(new RGB(153, 0, 102));
        result.add(new RGB(153, 0, 51));
        result.add(new RGB(153, 0, 0));
        result.add(new RGB(102, 255, 255));
        result.add(new RGB(102, 255, 204));
        result.add(new RGB(102, 255, 153));
        result.add(new RGB(102, 255, 102));
        result.add(new RGB(102, 255, 51));
        result.add(new RGB(102, 255, 0));
        result.add(new RGB(102, 204, 255));
        result.add(new RGB(102, 204, 204));
        result.add(new RGB(102, 204, 153));
        result.add(new RGB(102, 204, 102));
        result.add(new RGB(102, 204, 51));
        result.add(new RGB(102, 204, 0));
        result.add(new RGB(102, 153, 255));
        result.add(new RGB(102, 153, 204));
        result.add(new RGB(102, 153, 153));
        result.add(new RGB(102, 153, 102));
        result.add(new RGB(102, 153, 51));
        result.add(new RGB(102, 153, 0));
        result.add(new RGB(102, 102, 255));
        result.add(new RGB(102, 102, 204));
        result.add(new RGB(102, 102, 153));
        result.add(new RGB(102, 102, 102));
        result.add(new RGB(102, 102, 51));
        result.add(new RGB(102, 102, 0));
        result.add(new RGB(102, 51, 255));
        result.add(new RGB(102, 51, 204));
        result.add(new RGB(102, 51, 153));
        result.add(new RGB(102, 51, 102));
        result.add(new RGB(102, 51, 51));
        result.add(new RGB(102, 51, 0));
        result.add(new RGB(102, 0, 255));
        result.add(new RGB(102, 0, 204));
        result.add(new RGB(102, 0, 153));
        result.add(new RGB(102, 0, 102));
        result.add(new RGB(102, 0, 51));
        result.add(new RGB(102, 0, 0));
        result.add(new RGB(51, 255, 255));
        result.add(new RGB(51, 255, 204));
        result.add(new RGB(51, 255, 153));
        result.add(new RGB(51, 255, 102));
        result.add(new RGB(51, 255, 51));
        result.add(new RGB(51, 255, 0));
        result.add(new RGB(51, 204, 255));
        result.add(new RGB(51, 204, 204));
        result.add(new RGB(51, 204, 153));
        result.add(new RGB(51, 204, 102));
        result.add(new RGB(51, 204, 51));
        result.add(new RGB(51, 204, 0));
        result.add(new RGB(51, 153, 255));
        result.add(new RGB(51, 153, 204));
        result.add(new RGB(51, 153, 153));
        result.add(new RGB(51, 153, 102));
        result.add(new RGB(51, 153, 51));
        result.add(new RGB(51, 153, 0));
        result.add(new RGB(51, 102, 255));
        result.add(new RGB(51, 102, 204));
        result.add(new RGB(51, 102, 153));
        result.add(new RGB(51, 102, 102));
        result.add(new RGB(51, 102, 51));
        result.add(new RGB(51, 102, 0));
        result.add(new RGB(51, 51, 255));
        result.add(new RGB(51, 51, 204));
        result.add(new RGB(51, 51, 153));
        result.add(new RGB(51, 51, 102));
        result.add(new RGB(51, 51, 51));
        result.add(new RGB(51, 51, 0));
        result.add(new RGB(51, 0, 255));
        result.add(new RGB(51, 0, 204));
        result.add(new RGB(51, 0, 153));
        result.add(new RGB(51, 0, 102));
        result.add(new RGB(51, 0, 51));
        result.add(new RGB(51, 0, 0));
        result.add(new RGB(0, 255, 255));
        result.add(new RGB(0, 255, 204));
        result.add(new RGB(0, 255, 153));
        result.add(new RGB(0, 255, 102));
        result.add(new RGB(0, 255, 51));
        result.add(new RGB(0, 255, 0));
        result.add(new RGB(0, 204, 255));
        result.add(new RGB(0, 204, 204));
        result.add(new RGB(0, 204, 153));
        result.add(new RGB(0, 204, 102));
        result.add(new RGB(0, 204, 51));
        result.add(new RGB(0, 204, 0));
        result.add(new RGB(0, 153, 255));
        result.add(new RGB(0, 153, 204));
        result.add(new RGB(0, 153, 153));
        result.add(new RGB(0, 153, 102));
        result.add(new RGB(0, 153, 51));
        result.add(new RGB(0, 153, 0));
        result.add(new RGB(0, 102, 255));
        result.add(new RGB(0, 102, 204));
        result.add(new RGB(0, 102, 153));
        result.add(new RGB(0, 102, 102));
        result.add(new RGB(0, 102, 51));
        result.add(new RGB(0, 102, 0));
        result.add(new RGB(0, 51, 255));
        result.add(new RGB(0, 51, 204));
        result.add(new RGB(0, 51, 153));
        result.add(new RGB(0, 51, 102));
        result.add(new RGB(0, 51, 51));
        result.add(new RGB(0, 51, 0));
        result.add(new RGB(0, 0, 255));
        result.add(new RGB(0, 0, 204));
        result.add(new RGB(0, 0, 153));
        result.add(new RGB(0, 0, 102));
        result.add(new RGB(0, 0, 51));
        result.add(new RGB(0, 0, 0));
        return result;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.imagesCache.dispose();
    }
}

