/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.combomenu;

import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.PlatformUI;

public class HelpProvider {
    private Menu openedMenu;

    public HelpProvider(Menu opendMenu) {
        this.openedMenu = opendMenu;
    }

    public HelpListener setHelp(String href) {
        if (this.openedMenu != null) {
            HelpOpener handler = new HelpOpener(href);
            this.openedMenu.removeHelpListener((HelpListener)handler);
            this.openedMenu.addHelpListener((HelpListener)handler);
            return handler;
        }
        return null;
    }

    private class HelpOpener
    implements HelpListener {
        private String href;

        public HelpOpener(String href) {
            this.href = href;
        }

        public void helpRequested(HelpEvent e) {
            if (this.href != null) {
                URL url = PlatformUI.getWorkbench().getHelpSystem().resolve(this.href, false);
                try {
                    PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(url.toURI().toASCIIString());
                }
                catch (URISyntaxException e1) {
                    e1.printStackTrace();
                }
            }
        }

        public String getRef() {
            return this.href;
        }

        public boolean equals(Object obj) {
            return obj instanceof HelpOpener && ((HelpOpener)obj).getRef().equals(this.href);
        }
    }
}

