/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.combomenu;

import com.jaspersoft.studio.help.HelpSystem;
import com.jaspersoft.studio.property.combomenu.ComboItem;
import com.jaspersoft.studio.property.combomenu.ComboItemAction;
import com.jaspersoft.studio.property.combomenu.HelpProvider;
import com.jaspersoft.studio.property.combomenu.IMenuProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.WritableComboButton;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class WritableComboMenuViewer
implements IMenuProvider {
    public static final int NORMAL = 0;
    public static final int NO_TEXT = 1;
    public static final int NO_IMAGE = 2;
    private List<ComboItemAction> listeners;
    private WritableComboButton dropDownHandle;
    private List<ComboItem> elementList = new ArrayList<ComboItem>();
    private Menu popupMenu = null;
    private ComboItem selectedItem = null;
    private boolean disableSelectedItemUpdate = false;
    private boolean disableSelectedItemEmphasis = false;

    public WritableComboMenuViewer(Composite parent, int style) {
        this.dropDownHandle = new WritableComboButton(parent, style);
        this.listeners = new ArrayList<ComboItemAction>();
        this.dropDownHandle.addOpenListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WritableComboMenuViewer.this.openPopup();
            }
        });
        this.dropDownHandle.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = WritableComboMenuViewer.this.dropDownHandle.getText();
                WritableComboMenuViewer.this.selectedItem = new ComboItem(text, true, -1, text, text);
                for (ComboItemAction listener : WritableComboMenuViewer.this.listeners) {
                    listener.exec();
                }
            }
        });
    }

    public void disableSelectedItemUpdate(boolean value) {
        this.disableSelectedItemUpdate = value;
    }

    public void disableSelectedEmphasis(boolean value) {
        this.disableSelectedItemEmphasis = value;
    }

    public void addSelectionListener(ComboItemAction listener) {
        this.listeners.add(listener);
    }

    public void setToolTipText(String text) {
        this.dropDownHandle.setToolTipText(text);
    }

    protected boolean hasNoElement() {
        return this.elementList.isEmpty();
    }

    protected int getItemCount() {
        return this.elementList.size();
    }

    public int getWidth() {
        return this.dropDownHandle.getSize().x;
    }

    public int getSelectionIndex() {
        if (this.hasNoElement()) {
            return 0;
        }
        return this.indexForElement(this.selectedItem);
    }

    public Object getSelectionValue() {
        if (this.hasNoElement()) {
            return null;
        }
        return this.getSelectedItem().getValue();
    }

    public ComboItem getItemAtPosition(int position) {
        return this.elementList.get(position);
    }

    public ComboItem getSelectedItem() {
        return this.selectedItem;
    }

    protected int indexForElement(ComboItem element) {
        return this.elementList.indexOf(element);
    }

    protected void inputChanged(Object input, Object oldInput) {
        this.closePopup();
    }

    public WritableComboButton getControl() {
        return this.dropDownHandle;
    }

    protected void openPopup() {
        this.openPopupMenu(this.getPopup());
    }

    protected Menu getPopup() {
        if (this.popupMenu == null) {
            this.popupMenu = this.createPopupMenu();
        }
        return this.popupMenu;
    }

    protected void openPopupMenu(Menu menu) {
        if (menu != null && !menu.isDisposed()) {
            if (menu.isVisible()) {
                menu.setVisible(false);
            } else {
                this.locatePopupMenu(menu);
                this.setSelectionToMenu(menu);
                menu.setVisible(true);
            }
        }
    }

    protected Menu createPopupMenu() {
        Menu newMenu = new Menu((Control)this.getControl());
        newMenu.addMenuListener(new MenuListener(){

            public void menuShown(MenuEvent e) {
            }

            public void menuHidden(MenuEvent e) {
                WritableComboMenuViewer.this.dropDownHandle.setEnabled(false);
                WritableComboMenuViewer.this.dropDownHandle.setEnabled(true);
            }
        });
        this.refreshPopupMenu(newMenu);
        return newMenu;
    }

    public void setItems(ComboItem[] newItems) {
        this.elementList = new ArrayList<ComboItem>(Arrays.asList(newItems));
        if (this.popupMenu != null) {
            this.popupMenu.dispose();
        }
        this.popupMenu = this.createPopupMenu();
    }

    public void setItems(List<ComboItem> newItems) {
        this.elementList = newItems;
        if (this.popupMenu != null) {
            this.popupMenu.dispose();
        }
        this.popupMenu = this.createPopupMenu();
    }

    public void setHelp(String href) {
        HelpSystem.setHelp((Control)this.dropDownHandle, href);
        HelpProvider provider = new HelpProvider(this.getPopup());
        provider.setHelp(href);
    }

    protected void refreshPopupMenu(Menu newMenu) {
        Collections.sort(this.elementList, new Comparator<ComboItem>(){

            @Override
            public int compare(ComboItem o1, ComboItem o2) {
                return o1.getOrder() - o2.getOrder();
            }
        });
        for (ComboItem element : this.elementList) {
            if (element.isSeparator()) {
                new MenuItem(newMenu, 2);
                continue;
            }
            MenuItem item = new MenuItem(newMenu, 8);
            String text = element.getText();
            item.setText(text);
            item.setImage(element.getImage());
            ComboAction action = new ComboAction(text, new ArrayList<ComboItemAction>(this.listeners), element, element.getImage());
            item.addSelectionListener((SelectionListener)action);
        }
        this.setSelectionToMenu(newMenu);
    }

    protected void locatePopupMenu(Menu menu) {
        Rectangle r;
        if (this.getControl() instanceof Composite) {
            r = this.getControl().getClientArea();
        } else {
            r = this.getControl().getBounds();
            r.y = 0;
            r.x = 0;
        }
        Point loc = this.getControl().toDisplay(r.x, r.y);
        loc.y += r.height;
        menu.setLocation(loc);
    }

    protected void closePopup() {
        if (this.popupMenu != null && this.popupMenu != null && !this.popupMenu.isDisposed()) {
            this.popupMenu.setVisible(false);
        }
    }

    protected void setSelectionToMenu(Menu menu) {
        if (!this.disableSelectedItemEmphasis) {
            int index = this.getSelectionIndex();
            if (menu != null && !menu.isDisposed()) {
                if (index < 0 || index >= menu.getItemCount()) {
                    menu.setDefaultItem(null);
                } else {
                    menu.setDefaultItem(menu.getItem(index));
                }
            }
        }
    }

    public void select(int index) {
        if (index >= 0 && index < this.elementList.size()) {
            this.selectedItem = this.elementList.get(index);
            this.dropDownHandle.setText(this.selectedItem.getText());
            this.dropDownHandle.setImage(this.selectedItem.getImage());
        }
    }

    public int getElementIndex(String label) {
        if (label != null) {
            int index = 0;
            for (ComboItem item : this.elementList) {
                if (label.equals(item.getText())) {
                    return index;
                }
                ++index;
            }
        }
        return -1;
    }

    public void select(ComboItem item) {
        this.dropDownHandle.setText(item.getText());
        this.dropDownHandle.setImage(item.getImage());
    }

    public void setText(String text) {
        this.dropDownHandle.setText(text);
    }

    protected void handleDispose(DisposeEvent event) {
        this.closePopup();
        if (this.popupMenu != null) {
            this.popupMenu.dispose();
            this.popupMenu = null;
        }
    }

    public void setEnabled(boolean enabled) {
        this.dropDownHandle.setEnabled(enabled);
    }

    public boolean isEnabled() {
        return this.dropDownHandle.isEnabled();
    }

    public boolean isDropDownVisible() {
        return this.popupMenu != null && !this.popupMenu.isDisposed() && this.popupMenu.isVisible();
    }

    @Override
    public Menu getMenu() {
        return this.getPopup();
    }

    public void setTextColor(Color color) {
        this.dropDownHandle.setTextColor(color);
    }

    public void setData(Object data) {
        this.dropDownHandle.setData(data);
    }

    public void setData(String key, Object data) {
        this.dropDownHandle.setData(key, data);
    }

    public boolean isDisposed() {
        return this.dropDownHandle.isDisposed();
    }

    public String getText() {
        return this.dropDownHandle.getText();
    }

    public void setForeground(Color color) {
        this.dropDownHandle.setForeground(color);
    }

    public void setBackground(Color color) {
        this.dropDownHandle.setBackground(color);
    }

    private class ComboAction
    extends SelectionAdapter {
        private ComboItem item;
        private String name;
        private List<ComboItemAction> listeners;
        private Image descriptor;

        public ComboAction(String name, List<ComboItemAction> listeners, ComboItem item, Image descriptor) {
            this.name = name;
            this.listeners = listeners;
            this.item = item;
            this.descriptor = descriptor;
        }

        public Image getImageDescriptor() {
            return this.descriptor;
        }

        public String getText() {
            return this.name;
        }

        public ComboItem getItem() {
            return this.item;
        }

        public void widgetSelected(SelectionEvent event) {
            if (!WritableComboMenuViewer.this.disableSelectedItemUpdate) {
                WritableComboMenuViewer.this.dropDownHandle.setText(this.getText());
                WritableComboMenuViewer.this.dropDownHandle.setImage(this.getImageDescriptor());
            }
            WritableComboMenuViewer.this.selectedItem = this.getItem();
            for (ComboItemAction listener : this.listeners) {
                listener.exec();
            }
        }
    }
}

