/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.dataset.da;

import java.util.List;
import net.sf.jasperreports.data.http.HttpLocationParameter;
import net.sf.jasperreports.eclipse.ui.ATitledDialog;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class HttpParameterDialog
extends ATitledDialog {
    private JRDesignDataset dataset;
    private List<HttpLocationParameter> properties;
    private String name;
    private JRDesignParameter prm;
    private String pname;

    public String getName() {
        return this.name;
    }

    public JRDesignParameter getPrm() {
        return this.prm;
    }

    protected HttpParameterDialog(Shell parentShell, JRDesignDataset dataset, List<HttpLocationParameter> properties, String pname) {
        super(parentShell);
        this.dataset = dataset;
        this.properties = properties;
        this.pname = pname;
        this.setTitle("Parameter");
        this.setSaveSettings(false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite cmp = (Composite)super.createDialogArea(parent);
        cmp.setLayout((Layout)new GridLayout(2, false));
        new Label(cmp, 0).setText("Name");
        final Text tname = new Text(cmp, 2048);
        GridData gd = new GridData(768);
        gd.widthHint = 300;
        tname.setLayoutData((Object)gd);
        new Label(cmp, 0).setText("Parameter");
        final Combo cprm = new Combo(cmp, 8);
        JRParameter[] jRParameterArray = this.dataset.getParameters();
        int n = jRParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            JRParameter p = jRParameterArray[n2];
            if (!p.isSystemDefined() && !p.getPropertiesMap().containsProperty(this.pname) && p.getValueClass().isAssignableFrom(String.class)) {
                cprm.add(p.getName());
            }
            ++n2;
        }
        if (cprm.getItemCount() > 0) {
            cprm.select(0);
        } else {
            UIUtils.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    HttpParameterDialog.this.setError("Compatible parameters is empty. Cancel this dialog and create some parameters.");
                    HttpParameterDialog.this.getButton(0).setEnabled(false);
                }
            });
        }
        this.prm = (JRDesignParameter)this.dataset.getParametersMap().get(cprm.getText());
        cprm.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HttpParameterDialog.this.prm = (JRDesignParameter)HttpParameterDialog.this.dataset.getParametersMap().get(cprm.getText());
            }
        });
        String n3 = "prm";
        int i = 1;
        while (i < Integer.MAX_VALUE) {
            if (this.validateName(String.valueOf(n3) + i) == null) {
                tname.setText(String.valueOf(n3) + i);
                this.name = String.valueOf(n3) + i;
                break;
            }
            ++i;
        }
        tname.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String error = HttpParameterDialog.this.validateName(tname.getText());
                HttpParameterDialog.this.setError(error);
                HttpParameterDialog.this.getButton(0).setEnabled(error == null);
                if (error == null) {
                    HttpParameterDialog.this.name = tname.getText();
                }
            }
        });
        return cmp;
    }

    private String validateName(String name) {
        if (Misc.isNullOrEmpty((String)name)) {
            return "Name can't be empty";
        }
        for (HttpLocationParameter p : this.properties) {
            if (!p.getName().equals(name)) continue;
            return "This name is already used";
        }
        return null;
    }
}

