/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.dataset.da.widgets;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.model.parameter.MParameter;
import com.jaspersoft.studio.property.dataset.DatasetUtil;
import com.jaspersoft.studio.property.dataset.da.widgets.IWidget;
import com.jaspersoft.studio.property.dataset.fields.table.TColumn;
import com.jaspersoft.studio.utils.UIUtil;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import net.sf.jasperreports.engine.type.ParameterEvaluationTimeEnum;
import net.sf.jasperreports.engine.util.JRClassLoader;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class ParameterPropertyWidget
implements IWidget {
    private TColumn c;
    private String daValue;
    private JRDesignDataset dataset;
    private Text tvalue;
    private Label icon;
    private Image daicon;
    private ToolItem button;
    private Label lbl;
    private boolean refresh = false;

    public ParameterPropertyWidget(TColumn c, Composite parent, Image daicon, String daValue, JRDesignDataset dataset) {
        this.c = c;
        this.daValue = daValue;
        this.dataset = dataset;
        this.daicon = daicon;
        this.lbl = new Label(parent, 0);
        this.lbl.setText(c.getLabel());
        Composite cmp = new Composite(parent, 2048);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        cmp.setLayout((Layout)layout);
        this.icon = new Label(cmp, 0);
        this.icon.setImage(JaspersoftStudioPlugin.getInstance().getImage(MParameter.getIconDescriptor().getIcon16()));
        this.icon.setLayoutData((Object)new GridData(2));
        this.tvalue = new Text(cmp, 8);
        this.tvalue.setLayoutData((Object)new GridData(1808));
        ToolBar buttons = new ToolBar(cmp, 0x800000);
        this.button = new ToolItem(buttons, 8);
        this.button.setText("...");
        Listener l = event -> {
            Menu menu = this.createMenu(parent);
            Rectangle bounds = this.tvalue.getBounds();
            Point point = this.tvalue.toDisplay(bounds.x, bounds.y + bounds.height + 5);
            menu.setLocation(point);
            menu.setVisible(true);
        };
        this.button.addListener(13, l);
        this.tvalue.addListener(3, l);
        this.icon.addListener(3, l);
        buttons.setLayoutData((Object)new GridData(2));
        GridData gd = new GridData();
        if (c.getWeight() == -2) {
            gd = new GridData(768);
        }
        if (c.getWeight() == -3) {
            gd = new GridData(1808);
        } else if (c.getWeight() > 0) {
            gd.widthHint = c.getWeight();
        }
        cmp.setLayoutData((Object)gd);
        this.refresh();
    }

    public void refresh() {
        if (this.refresh || this.tvalue.isDisposed()) {
            return;
        }
        this.setupToolTip(null);
        JRParameter[] jRParameterArray = this.dataset.getParameters();
        int n = jRParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            JRParameter p = jRParameterArray[n2];
            if (!p.isSystemDefined() && p.getPropertiesMap().containsProperty(this.c.getPropertyName())) {
                this.tvalue.setText(p.getName());
                this.icon.setImage(JaspersoftStudioPlugin.getInstance().getImage(MParameter.getIconDescriptor().getIcon16()));
                return;
            }
            ++n2;
        }
        this.tvalue.setText(Misc.nvl((Object)this.daValue, (String)"< NULL >"));
        this.icon.setImage(this.daicon);
    }

    private void setupToolTip(String def) {
        String tt = this.tvalue.getText();
        if (Misc.isNullOrEmpty((String)def)) {
            tt = String.valueOf(tt) + "\nDefault: " + def;
        }
        if (!Misc.isNullOrEmpty((String)this.c.getDescription())) {
            tt = String.valueOf(tt) + "\n\n" + this.c.getDescription();
        }
        this.button.setToolTipText(tt);
        this.tvalue.setToolTipText(tt);
        this.icon.setToolTipText(tt);
        this.lbl.setToolTipText(tt);
    }

    private Menu createMenu(Composite parent) {
        Menu menu = new Menu((Decorations)parent.getShell(), 8);
        final MenuItem mid = new MenuItem(menu, 8);
        mid.setText(Misc.nvl((Object)this.daValue, (String)"< NULL >"));
        mid.setImage(this.daicon);
        mid.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParameterPropertyWidget.this.tvalue.setText(mid.getText());
                ParameterPropertyWidget.this.icon.setImage(mid.getImage());
                ParameterPropertyWidget.this.setupToolTip(null);
                try {
                    ParameterPropertyWidget.this.refresh = true;
                    DatasetUtil.removeProperty(ParameterPropertyWidget.this.dataset, ParameterPropertyWidget.this.c.getPropertyName());
                }
                finally {
                    ParameterPropertyWidget.this.refresh = false;
                }
            }
        });
        new MenuItem(menu, 2);
        String cn = JRClassLoader.getClassRealName((String)this.c.getPropertyType());
        try {
            Class cl = JRClassLoader.loadClassForName((String)cn);
            JRParameter[] jRParameterArray = this.dataset.getParameters();
            int n = jRParameterArray.length;
            int n2 = 0;
            while (n2 < n) {
                final JRParameter p = jRParameterArray[n2];
                if (!p.isSystemDefined() && (p.getValueClass().isAssignableFrom(cl) || p.getValueClass().isAssignableFrom(String.class))) {
                    final MenuItem mi = new MenuItem(menu, 8);
                    mi.setText(p.getName());
                    mi.setImage(JaspersoftStudioPlugin.getInstance().getImage(MParameter.getIconDescriptor().getIcon16()));
                    final String def = p.getDefaultValueExpression() != null ? p.getDefaultValueExpression().getText() : null;
                    String tt = "Default: " + (def == null ? "" : "null");
                    if (!Misc.isNullOrEmpty((String)p.getDescription())) {
                        tt = String.valueOf(tt) + "\n\n" + p.getDescription();
                    }
                    UIUtil.safeApplyMenuItemTooltip(mi, tt);
                    final JRPropertiesMap pmap = p.getPropertiesMap();
                    pmap.getEventSupport();
                    mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            ParameterPropertyWidget.this.tvalue.setText(mi.getText());
                            ParameterPropertyWidget.this.icon.setImage(mi.getImage());
                            ParameterPropertyWidget.this.setupToolTip(def);
                            try {
                                ParameterPropertyWidget.this.refresh = true;
                                DatasetUtil.removeProperty(ParameterPropertyWidget.this.dataset, ParameterPropertyWidget.this.c.getPropertyName());
                                pmap.setProperty(ParameterPropertyWidget.this.c.getPropertyName(), null);
                                ((JRDesignParameter)p).setEvaluationTime(ParameterEvaluationTimeEnum.EARLY);
                            }
                            finally {
                                ParameterPropertyWidget.this.refresh = false;
                            }
                        }
                    });
                }
                ++n2;
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        if (menu.getItemCount() == 2) {
            mid.dispose();
        }
        return menu;
    }
}

