/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.dataset.dialog;

import com.jaspersoft.studio.data.IFieldSetter;
import com.jaspersoft.studio.data.IMappingTool;
import com.jaspersoft.studio.property.dataset.dialog.DataQueryAdapters;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Composite;

public class DataMappingFactory {
    private Map<Class<? extends IMappingTool>, IMappingTool> classmap = new HashMap<Class<? extends IMappingTool>, IMappingTool>();

    public DataMappingFactory(CTabFolder tabFolder, IFieldSetter fsetter, DataQueryAdapters dqa) {
        IConfigurationElement[] config;
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor("com.jaspersoft.studio", "mappingTool");
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                IMappingTool qd = (IMappingTool)e.createExecutableExtension("MappingToolClass");
                qd.setParentContainer(dqa);
                CTabItem bptab = new CTabItem(tabFolder, 0);
                bptab.setText(qd.getName());
                this.addDesigner(qd);
                bptab.setControl(qd.createControl((Composite)tabFolder));
                qd.setFields(fsetter);
            }
            catch (CoreException ex) {
                System.out.println(ex.getMessage());
            }
            ++n2;
        }
    }

    public void dispose() {
        for (IMappingTool mt : this.classmap.values()) {
            mt.dispose();
        }
    }

    public Collection<IMappingTool> getMappingTools() {
        return this.classmap.values();
    }

    private IMappingTool addDesigner(IMappingTool qd) {
        IMappingTool iqd = this.classmap.get(qd.getClass());
        if (iqd == null) {
            iqd = qd;
            this.classmap.put(qd.getClass(), iqd);
        }
        return iqd;
    }
}

