/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.dataset.dialog;

import com.jaspersoft.studio.data.DataAdapterDescriptor;
import com.jaspersoft.studio.data.DataAdapterManager;
import com.jaspersoft.studio.data.IFieldSetter;
import com.jaspersoft.studio.data.IQueryDesigner;
import com.jaspersoft.studio.data.MDataAdapters;
import com.jaspersoft.studio.data.designer.AQueryDesignerContainer;
import com.jaspersoft.studio.data.fields.IFieldsProvider;
import com.jaspersoft.studio.data.widget.DataAdapterAction;
import com.jaspersoft.studio.data.widget.IDataAdapterRunnable;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.property.dataset.da.DataAdapterUI;
import com.jaspersoft.studio.property.dataset.dialog.DataMappingFactory;
import com.jaspersoft.studio.property.dataset.dialog.QDesignerFactory;
import com.jaspersoft.studio.property.dataset.dialog.RunWithProgressBar;
import com.jaspersoft.studio.property.metadata.PropertyMetadataRegistry;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.annotations.properties.PropertyScope;
import net.sf.jasperreports.data.DataAdapterService;
import net.sf.jasperreports.data.DataAdapterServiceUtil;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRQuery;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.ParameterContributorContext;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignQuery;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.properties.PropertyMetadata;
import net.sf.jasperreports.properties.StandardPropertyMetadata;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.dialogs.PreferencesUtil;

public abstract class DataQueryAdapters
extends AQueryDesignerContainer {
    public static final String PROGRESSMONITOR = "monitor";
    public static final String DEFAULT_DATAADAPTER = "com.jaspersoft.studio.data.defaultdataadapter";
    public static final String FIELD_PATH = "com.jaspersoft.studio.field.tree.path";
    public static final String FIELD_LABEL = "com.jaspersoft.studio.field.label";
    public static final String FIELD_NAME = "com.jaspersoft.studio.field.name";
    public static final String EXPORTER_FILENAME = "com.jaspersoft.studio.exporter.filename";
    private JRDesignDataset newdataset;
    private JasperDesign jDesign;
    private Color background;
    private IFile file;
    private Composite composite;
    private DataAdapterAction dscombo;
    private Combo langCombo;
    private String[] languages;
    private Composite langComposite;
    private StackLayout langLayout;
    private QDesignerFactory qdfactory;
    private CTabFolder tabFolder;
    private IQueryDesigner currentDesigner = null;
    private DataMappingFactory dmfactory;
    private IRunnableContext runner;
    private boolean isRefresh = false;
    private StackLayout tbLayout;
    private Composite tbCompo;
    private ToolBar tb;

    public static void initMetadata() {
        ArrayList<PropertyMetadata> pm = new ArrayList<PropertyMetadata>();
        StandardPropertyMetadata spm = new StandardPropertyMetadata();
        spm.setName(DEFAULT_DATAADAPTER);
        spm.setLabel(Messages.DataQueryAdapters_0);
        spm.setDescription(Messages.DataQueryAdapters_1);
        spm.setValueType("jssDA");
        ArrayList<PropertyScope> scopes = new ArrayList<PropertyScope>();
        scopes.add(PropertyScope.DATASET);
        spm.setScopes(scopes);
        spm.setCategory("net.sf.jasperreports.metadata.property.category:data.source");
        pm.add((PropertyMetadata)spm);
        spm = new StandardPropertyMetadata();
        spm.setName("net.sf.jasperreports.datasnapshot.SAVESNAPSHOT");
        spm.setLabel(Messages.DataQueryAdapters_4);
        spm.setDescription(Messages.DataQueryAdapters_5);
        spm.setValueType("java.io.File");
        scopes = new ArrayList();
        scopes.add(PropertyScope.REPORT);
        spm.setScopes(scopes);
        spm.setCategory("net.sf.jasperreports.metadata.property.category:data.snapshot");
        pm.add((PropertyMetadata)spm);
        spm = new StandardPropertyMetadata();
        spm.setName(FIELD_PATH);
        spm.setLabel("Field Path");
        spm.setDescription("Field path used to show fields as a tree.");
        spm.setValueType(String.class.getName());
        scopes = new ArrayList();
        scopes.add(PropertyScope.FIELD);
        spm.setScopes(scopes);
        spm.setCategory("net.sf.jasperreports.metadata.property.category:field");
        pm.add((PropertyMetadata)spm);
        spm = new StandardPropertyMetadata();
        spm.setName(FIELD_LABEL);
        spm.setLabel("Field Label");
        spm.setDescription("Field label, can be used as column label.");
        spm.setValueType(String.class.getName());
        scopes = new ArrayList();
        scopes.add(PropertyScope.FIELD);
        spm.setScopes(scopes);
        spm.setCategory("net.sf.jasperreports.metadata.property.category:field");
        pm.add((PropertyMetadata)spm);
        spm = new StandardPropertyMetadata();
        spm.setName(FIELD_NAME);
        spm.setLabel("Field Name");
        spm.setDescription("Field name.");
        spm.setValueType(String.class.getName());
        scopes = new ArrayList();
        scopes.add(PropertyScope.FIELD);
        spm.setScopes(scopes);
        spm.setCategory("net.sf.jasperreports.metadata.property.category:field");
        pm.add((PropertyMetadata)spm);
        spm = new StandardPropertyMetadata();
        spm.setName(FIELD_NAME);
        spm.setLabel("Field Name");
        spm.setDescription("Field name.");
        spm.setValueType(String.class.getName());
        scopes = new ArrayList();
        scopes.add(PropertyScope.FIELD);
        spm.setScopes(scopes);
        spm.setCategory("net.sf.jasperreports.metadata.property.category:field");
        pm.add((PropertyMetadata)spm);
        spm = new StandardPropertyMetadata();
        spm.setName(EXPORTER_FILENAME);
        spm.setLabel("Exported Filename");
        spm.setDescription("The prefix of the exported file name. Minimum 3 chars long. Will be created by OS as a temporary file.");
        spm.setValueType(String.class.getName());
        scopes = new ArrayList();
        scopes.add(PropertyScope.REPORT);
        scopes.add(PropertyScope.CONTEXT);
        spm.setScopes(scopes);
        spm.setCategory("net.sf.jasperreports.metadata.property.category:report");
        pm.add((PropertyMetadata)spm);
        PropertyMetadataRegistry.addMetadata(pm);
    }

    public DataQueryAdapters(Composite parent, JasperReportsConfiguration jConfig, JRDesignDataset newdataset, Color background, IRunnableContext runner) {
        this.setRunnableContext(runner);
        if (jConfig != null) {
            this.file = (IFile)jConfig.get("ifile");
            this.jDesign = jConfig.getJasperDesign();
        }
        this.newdataset = newdataset;
        this.jConfig = jConfig;
        if (background != null) {
            this.background = background;
        }
        this.background = parent.getDisplay().getSystemColor(25);
    }

    public DataQueryAdapters(Composite parent, JasperReportsConfiguration jConfig, JRDesignDataset newdataset, Color background) {
        this(parent, jConfig, newdataset, background, null);
    }

    public void dispose() {
        this.qdfactory.dispose();
        this.dmfactory.dispose();
    }

    public Composite getControl() {
        return this.composite;
    }

    public Composite getQueryControl() {
        return this.tabFolder;
    }

    public void setFile(JasperReportsConfiguration jConfig) {
        this.file = (IFile)jConfig.get("ifile");
        this.jDesign = jConfig.getJasperDesign();
        this.dscombo.setDataAdapterStorages(DataAdapterManager.getDataAdapter(this.file, jConfig));
        this.setDataset(this.jDesign, this.newdataset);
    }

    public CTabFolder createTop(Composite parent, IFieldSetter fsetter) {
        this.tabFolder = new CTabFolder(parent, 2176);
        GridData gd = new GridData(1808);
        gd.heightHint = 150;
        this.tabFolder.setLayoutData((Object)gd);
        this.createQuery(this.tabFolder);
        this.createMappingTools(this.tabFolder, fsetter);
        this.createDataAdapterTab(this.tabFolder);
        this.tabFolder.setSelection(0);
        return this.tabFolder;
    }

    private void createDataAdapterTab(CTabFolder tabFolder) {
        DataAdapterUI daUI = new DataAdapterUI();
        daUI.refreshDaUI(tabFolder, this.background, this.jDesign, this.newdataset, this.jConfig);
        this.newdataset.getPropertiesMap().getEventSupport().addPropertyChangeListener(evt -> {
            String pname = evt.getPropertyName();
            if (pname.equals(DEFAULT_DATAADAPTER) || pname.equals("net.sf.jasperreports.data.adapter")) {
                daUI.refreshDaUI(tabFolder, this.background, this.jDesign, this.newdataset, this.jConfig);
            }
        });
    }

    private void createMappingTools(CTabFolder tabFolder, IFieldSetter fsetter) {
        this.dmfactory = new DataMappingFactory(tabFolder, fsetter, this);
    }

    private void createQuery(CTabFolder tabFolder) {
        CTabItem bptab = new CTabItem(tabFolder, 0);
        bptab.setText(Messages.DataQueryAdapters_querytab);
        Composite sectionClient = new Composite((Composite)tabFolder, 0);
        sectionClient.setLayout((Layout)new GridLayout(3, false));
        sectionClient.setBackground(this.background);
        sectionClient.setBackgroundMode(2);
        Label label = new Label(sectionClient, 0);
        label.setText(Messages.DataQueryAdapters_languagetitle);
        this.langCombo = new Combo(sectionClient, 2052);
        this.languages = ModelUtils.getQueryLanguages(this.jConfig);
        this.langCombo.setItems(this.languages);
        GridData gd = new GridData();
        gd.widthHint = 200;
        this.langCombo.setLayoutData((Object)gd);
        this.langCombo.addModifyListener(e -> {
            if (this.isRefresh) {
                return;
            }
            String lang = this.langCombo.getText();
            int index = Misc.indexOf((String[])this.languages, (String)lang);
            if (index < 0) {
                Point oldSelection = this.langCombo.getSelection();
                this.languages[0] = lang;
                this.langCombo.setItem(0, lang);
                this.langCombo.select(0);
                this.langCombo.setSelection(oldSelection);
            } else if (index > 0 && !this.languages[0].isEmpty()) {
                this.languages[0] = "";
                this.langCombo.setItem(0, "");
            }
            this.changeLanguage();
        });
        this.tbCompo = new Composite(sectionClient, 0);
        this.tbCompo.setBackgroundMode(2);
        this.tbLayout = new StackLayout();
        this.tbCompo.setLayout((Layout)this.tbLayout);
        this.tbCompo.setLayoutData((Object)new GridData(768));
        this.langComposite = new Composite(sectionClient, 0);
        gd = new GridData(1808);
        gd.horizontalSpan = 3;
        this.langComposite.setLayoutData((Object)gd);
        this.langLayout = new StackLayout();
        this.langLayout.marginWidth = 0;
        this.langLayout.marginWidth = 0;
        this.langComposite.setLayout((Layout)this.langLayout);
        this.langComposite.setBackground(this.background);
        this.qdfactory = new QDesignerFactory(this.langComposite, this.tbCompo, this);
        bptab.setControl((Control)sectionClient);
    }

    private void changeLanguage() {
        if (!this.isRefresh) {
            this.qStatus.showInfo("");
            String lang = this.langCombo.getText();
            if (Misc.isNullOrEmpty((String)lang) && this.newdataset.getQuery() != null) {
                lang = "SQL";
                this.langCombo.setText("SQL");
            }
            this.langCombo.setToolTipText(lang);
            ((JRDesignQuery)this.newdataset.getQuery()).setLanguage(lang);
            IQueryDesigner designer = this.qdfactory.getDesigner(lang);
            this.langLayout.topControl = designer.getControl();
            this.tbLayout.topControl = designer.getToolbarControl();
            this.tbCompo.layout();
            this.langComposite.layout();
            this.currentDesigner = designer;
            this.currentDesigner.setJasperConfiguration(this.jConfig);
            UIUtils.getDisplay().asyncExec(() -> {
                this.currentDesigner.setQuery(this.jDesign, (JRDataset)this.newdataset, this.jConfig);
                this.currentDesigner.setDataAdapter(this.dscombo.getSelected());
            });
            this.refreshDsCombo();
        }
    }

    protected void refreshDsCombo() {
        String filter = this.jConfig.getProperty("com.jaspersoft.studio.data.adapter.filter");
        if (filter != null && filter.equals("da")) {
            this.dscombo.setLanguage(this.langCombo.getText());
        } else {
            this.dscombo.setLanguage(null);
        }
        this.dscombo.getMenu((Control)this.tb);
    }

    public String getContextHelpId() {
        return this.currentDesigner.getContextHelpId();
    }

    public Composite createToolbar(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(6, false));
        comp.setLayoutData((Object)new GridData(4, 4, true, false));
        comp.setBackgroundMode(2);
        this.tb = new ToolBar(comp, 0x820000);
        this.tb.setLayoutData((Object)new GridData(128));
        ToolBarManager manager = new ToolBarManager(this.tb);
        manager.add((IAction)new IconAction());
        IDataAdapterRunnable adapterRunReport = new IDataAdapterRunnable(){

            @Override
            public boolean runReport(DataAdapterDescriptor da, boolean daAction) {
                if (da != null) {
                    DataQueryAdapters.this.newdataset.setProperty(DataQueryAdapters.DEFAULT_DATAADAPTER, da.getName());
                } else {
                    DataQueryAdapters.this.newdataset.getPropertiesMap().removeProperty(DataQueryAdapters.DEFAULT_DATAADAPTER);
                }
                DataQueryAdapters.this.currentDesigner.setDataAdapter(da);
                DataQueryAdapters.this.qStatus.showInfo("");
                DataQueryAdapters.this.refreshLangCombo(da);
                DataQueryAdapters.this.dscombo.getMenu((Control)DataQueryAdapters.this.tb);
                return true;
            }

            @Override
            public boolean isNotRunning() {
                return true;
            }

            @Override
            public JasperReportsConfiguration getConfiguration() {
                return DataQueryAdapters.this.jConfig;
            }

            @Override
            public boolean runReport(DataAdapterDescriptor myDataAdapter, boolean prmDirty, boolean daAction) {
                return this.runReport(myDataAdapter, false);
            }
        };
        this.dscombo = new DataAdapterAction(adapterRunReport, DataAdapterManager.getDataAdapter(this.file, this.jConfig), this.newdataset);
        manager.add((IAction)this.dscombo);
        manager.update(true);
        this.tb.pack();
        this.createStatusBar(comp);
        this.createProgressBar(comp);
        return comp;
    }

    public void setRunnableContext(IRunnableContext runner) {
        this.runner = runner;
    }

    protected void createProgressBar(Composite comp) {
        if (this.runner == null) {
            this.runner = new RunWithProgressBar(comp);
        }
    }

    @Override
    public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        this.runner.run(fork, cancelable, runnable);
    }

    public void getFields(IProgressMonitor monitor) {
        this.doGetFields(monitor);
    }

    public void setDataset(JasperDesign jDesign, JRDesignDataset ds) {
        this.newdataset = ds;
        JRQuery query = this.newdataset.getQuery();
        if (query == null) {
            query = new JRDesignQuery();
            ((JRDesignQuery)query).setLanguage("sql");
            ((JRDesignQuery)query).setText("");
            this.newdataset.setQuery((JRDesignQuery)query);
        }
        this.isRefresh = true;
        try {
            int langindex = Misc.indexOf((String[])this.languages, (String)query.getLanguage());
            if (langindex >= 0) {
                this.langCombo.select(langindex);
            } else {
                this.langCombo.setItem(0, Misc.nvl((String)query.getLanguage()));
                this.langCombo.select(0);
            }
        }
        finally {
            this.isRefresh = false;
        }
        this.changeLanguage();
        if (jDesign != null) {
            String defaultAdapter = ds.getPropertiesMap().getProperty(DEFAULT_DATAADAPTER);
            if (defaultAdapter == null && ds.isMainDataset()) {
                defaultAdapter = jDesign.getProperty(DEFAULT_DATAADAPTER);
            }
            this.dscombo.setSelected(defaultAdapter);
        }
    }

    public String getLanguage() {
        int langind = this.langCombo.getSelectionIndex();
        if (langind < 0 || langind > this.languages.length) {
            langind = 0;
        }
        return this.languages[langind];
    }

    public String getQuery() {
        return this.qdfactory.getDesigner(this.newdataset.getQuery().getLanguage()).getQuery();
    }

    @Override
    public DataAdapterDescriptor getDataAdapter() {
        return this.dscombo.getSelected();
    }

    @Override
    protected void doGetFields(IProgressMonitor monitor) {
        DataAdapterDescriptor da = this.dscombo.getSelected();
        if (da != null && da instanceof IFieldsProvider && ((IFieldsProvider)((Object)da)).supportsGetFieldsOperation(this.jConfig, (JRDataset)this.newdataset)) {
            this.qStatus.showInfo("");
            monitor.beginTask(Messages.DataQueryAdapters_jobname, -1);
            ClassLoader oldClassloader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.jConfig.getClassLoader());
            DataAdapterService das = DataAdapterServiceUtil.getInstance((ParameterContributorContext)new ParameterContributorContext((JasperReportsContext)this.jConfig, (JRDataset)this.newdataset, this.jConfig.getJRParameters())).getService(da.getDataAdapter());
            try {
                try {
                    this.jConfig.getMap().put(PROGRESSMONITOR, monitor);
                    final List<JRDesignField> fields = ((IFieldsProvider)((Object)da)).getFields(das, this.jConfig, (JRDataset)this.newdataset);
                    if (fields != null && !monitor.isCanceled()) {
                        monitor.setTaskName(Messages.DataQueryAdapters_9);
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                DataQueryAdapters.this.setFields(fields);
                            }
                        });
                        monitor.setTaskName(Messages.DataQueryAdapters_10);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (e.getCause() != null) {
                        this.qStatus.showError(e.getCause().getMessage(), e);
                    } else {
                        this.qStatus.showError(e);
                    }
                    this.jConfig.getMap().remove(PROGRESSMONITOR);
                    Thread.currentThread().setContextClassLoader(oldClassloader);
                    das.dispose();
                    monitor.done();
                }
            }
            finally {
                this.jConfig.getMap().remove(PROGRESSMONITOR);
                Thread.currentThread().setContextClassLoader(oldClassloader);
                das.dispose();
                monitor.done();
            }
        }
    }

    protected void refreshLangCombo(DataAdapterDescriptor da) {
        this.isRefresh = true;
        try {
            String filter = this.jConfig.getProperty("com.jaspersoft.studio.data.adapter.filter");
            String[] langs = null;
            langs = filter != null && filter.equals("lang") && da != null ? da.getLanguages() : this.languages;
            if (!this.setupLanguagesCombo(langs)) {
                return;
            }
            this.isRefresh = false;
            this.changeLanguage();
        }
        finally {
            this.isRefresh = false;
        }
    }

    protected boolean setupLanguagesCombo(String[] langs) {
        boolean changeLang = true;
        if (this.langCombo.isDisposed()) {
            return false;
        }
        String lang = this.langCombo.getText();
        this.langCombo.removeAll();
        if (Misc.isNullOrEmpty((Object[])langs) || ArrayUtils.contains((Object[])langs, (Object)"*")) {
            this.langCombo.setItems(this.languages);
            return false;
        }
        String[] stringArray = langs;
        int n = langs.length;
        int n2 = 0;
        while (n2 < n) {
            String l = stringArray[n2];
            this.langCombo.add(l);
            if (l.equals(lang)) {
                changeLang = false;
            }
            ++n2;
        }
        if (!changeLang) {
            this.langCombo.setText(lang);
        } else {
            this.langCombo.setText(langs[0]);
        }
        return changeLang;
    }

    class IconAction
    extends Action
    implements IMenuCreator {
        private Menu menu;
        private MenuItem itemFilterAll;
        private MenuItem itemFilterDA;
        private MenuItem itemFilterLang;

        public IconAction() {
            this.setId("iconAction");
            this.setEnabled(true);
            this.setImageDescriptor(MDataAdapters.getIconDescriptor().getIcon16());
            this.setDisabledImageDescriptor(MDataAdapters.getIconDescriptor().getIcon16());
        }

        public boolean isEnabled() {
            return true;
        }

        public void runWithEvent(Event event) {
            Point point = ((ToolItem)event.widget).getParent().toDisplay(new Point(event.x, event.y));
            this.menu = this.getMenu((Control)((ToolItem)event.widget).getParent());
            this.menu.setLocation(point.x, point.y);
            this.menu.setVisible(true);
        }

        public void dispose() {
            if (this.menu != null) {
                this.menu.dispose();
            }
        }

        public Menu getMenu(Control parent) {
            String daFilter;
            if (this.menu == null) {
                this.menu = new Menu(parent);
                new MenuItem(this.menu, 2);
                this.itemFilterAll = new MenuItem(this.menu, 32);
                this.itemFilterAll.setText(Messages.DataQueryAdapters_13);
                this.itemFilterAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        try {
                            if (IconAction.this.itemFilterAll.getSelection()) {
                                DataQueryAdapters.this.jConfig.getPrefStore().setDefault("com.jaspersoft.studio.data.adapter.filter", "");
                                DataQueryAdapters.this.jConfig.getPrefStore().setValue("com.jaspersoft.studio.data.adapter.filter", "all");
                                DataQueryAdapters.this.jConfig.getPrefStore().save();
                                DataQueryAdapters.this.refreshLangCombo(((IconAction)IconAction.this).DataQueryAdapters.this.dscombo.getSelected());
                                DataQueryAdapters.this.refreshDsCombo();
                            }
                        }
                        catch (IOException e1) {
                            UIUtils.showError((Throwable)e1);
                        }
                    }
                });
                this.itemFilterDA = new MenuItem(this.menu, 32);
                this.itemFilterDA.setText(Messages.DesignerPreferencePage_6);
                this.itemFilterDA.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        try {
                            if (IconAction.this.itemFilterDA.getSelection()) {
                                DataQueryAdapters.this.jConfig.getPrefStore().setValue("com.jaspersoft.studio.data.adapter.filter", "lang");
                                DataQueryAdapters.this.jConfig.getPrefStore().save();
                                DataQueryAdapters.this.refreshLangCombo(((IconAction)IconAction.this).DataQueryAdapters.this.dscombo.getSelected());
                                DataQueryAdapters.this.refreshDsCombo();
                            }
                        }
                        catch (IOException e1) {
                            UIUtils.showError((Throwable)e1);
                        }
                    }
                });
                this.itemFilterLang = new MenuItem(this.menu, 32);
                this.itemFilterLang.setText(Messages.DesignerPreferencePage_8);
                this.itemFilterLang.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        try {
                            if (IconAction.this.itemFilterLang.getSelection()) {
                                DataQueryAdapters.this.jConfig.getPrefStore().setValue("com.jaspersoft.studio.data.adapter.filter", "da");
                                DataQueryAdapters.this.jConfig.getPrefStore().save();
                                DataQueryAdapters.this.refreshLangCombo(((IconAction)IconAction.this).DataQueryAdapters.this.dscombo.getSelected());
                                DataQueryAdapters.this.refreshDsCombo();
                            }
                        }
                        catch (IOException e1) {
                            UIUtils.showError((Throwable)e1);
                        }
                    }
                });
                new MenuItem(this.menu, 2);
                MenuItem itemFilter = new MenuItem(this.menu, 8);
                itemFilter.setText(Messages.DataQueryAdapters_17);
                itemFilter.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        PreferenceDialog pref;
                        IFile f = (IFile)DataQueryAdapters.this.jConfig.get("ifile");
                        if (f != null && (pref = PreferencesUtil.createPreferenceDialogOn((Shell)UIUtils.getShell(), (String)"com.jaspersoft.studio.preferences.DesignerPreferencePage", null, null)) != null && pref.open() == 0) {
                            DataQueryAdapters.this.refreshLangCombo(((IconAction)IconAction.this).DataQueryAdapters.this.dscombo.getSelected());
                            DataQueryAdapters.this.refreshDsCombo();
                        }
                    }
                });
            }
            this.itemFilterAll.setSelection((daFilter = Misc.nvl((Object)DataQueryAdapters.this.jConfig.getPrefStore().getString("com.jaspersoft.studio.data.adapter.filter"), (String)"all")) != null && daFilter.equals("all"));
            this.itemFilterDA.setSelection(daFilter != null && daFilter.equals("lang"));
            this.itemFilterLang.setSelection(daFilter != null && daFilter.equals("da"));
            return this.menu;
        }

        public Menu getMenu(Menu parent) {
            return null;
        }
    }
}

