/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.dataset.dialog;

import com.jaspersoft.studio.data.IQueryDesigner;
import com.jaspersoft.studio.data.designer.AQueryDesignerContainer;
import com.jaspersoft.studio.data.designer.QueryDesigner;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.widgets.Composite;

public class QDesignerFactory {
    private Composite parent;
    private Composite toolbar;
    private Map<String, IQueryDesigner> languageMap = new HashMap<String, IQueryDesigner>();
    private Map<Class<? extends IQueryDesigner>, IQueryDesigner> classmap = new HashMap<Class<? extends IQueryDesigner>, IQueryDesigner>();
    private AQueryDesignerContainer dqa;
    IConfigurationElement[] config;

    public QDesignerFactory(Composite parent, Composite toolbar, AQueryDesignerContainer dqa) {
        this.parent = parent;
        this.toolbar = toolbar;
        this.dqa = dqa;
        this.config = Platform.getExtensionRegistry().getConfigurationElementsFor("com.jaspersoft.studio", "queryDesigner");
    }

    public void dispose() {
        for (IQueryDesigner qd : this.languageMap.values()) {
            qd.dispose();
        }
    }

    public IQueryDesigner getDesigner(String lang) {
        IQueryDesigner qd = this.languageMap.get(lang.toLowerCase());
        if (qd == null) {
            IConfigurationElement[] iConfigurationElementArray = this.config;
            int n = this.config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                try {
                    if (lang.equalsIgnoreCase(e.getAttribute("language"))) {
                        qd = (IQueryDesigner)e.createExecutableExtension("QueryDesignerClass");
                        qd.setParentContainer(this.dqa);
                        qd = this.addDesigner(lang, qd);
                        return qd;
                    }
                }
                catch (CoreException ex) {
                    UIUtils.showError((Throwable)ex);
                }
                ++n2;
            }
            qd = this.addDesigner(lang, this.getDefaultDesigner());
        }
        return qd;
    }

    protected QueryDesigner getDefaultDesigner() {
        QueryDesigner defaultDesigner = new QueryDesigner();
        defaultDesigner.setParentContainer(this.dqa);
        return defaultDesigner;
    }

    private IQueryDesigner addDesigner(String lang, IQueryDesigner qd) {
        IQueryDesigner iqd = this.classmap.get(qd.getClass());
        if (iqd == null) {
            iqd = qd;
            try {
                iqd.createToolbar(this.toolbar);
                iqd.createControl(this.parent);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.addDesigner(lang, this.getDefaultDesigner());
            }
            this.classmap.put(qd.getClass(), iqd);
        }
        this.languageMap.put(lang.toLowerCase(), iqd);
        return iqd;
    }
}

