/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.dataset.dialog;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import java.lang.reflect.InvocationTargetException;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ProgressBar;

public class RunWithProgressBar
implements IRunnableContext {
    private ProgressBar pb;

    public RunWithProgressBar(Composite comp) {
        this.pb = new ProgressBar(comp, 258);
        GridData gd = new GridData();
        gd.widthHint = 100;
        gd.heightHint = 20;
        this.pb.setLayoutData((Object)gd);
        this.pb.setVisible(false);
    }

    public ProgressBar getProgressBar() {
        return this.pb;
    }

    public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        IProgressMonitor monitor = this.getProgressMonitor(cancelable);
        if (this.pb != null && !this.pb.isDisposed()) {
            ModalContext.run((IRunnableWithProgress)runnable, (boolean)true, (IProgressMonitor)monitor, (Display)UIUtils.getDisplay());
        }
    }

    public IProgressMonitor getProgressMonitor(boolean cancelable) {
        return new ProgressBarMonitor(this.pb, cancelable);
    }

    class ProgressBarMonitor
    implements IProgressMonitor {
        private ProgressBar progressBar;
        private boolean cancelled;
        private boolean cancelable;
        private Button bCancel;

        public ProgressBarMonitor(ProgressBar progressBar, boolean cancelable) {
            this.progressBar = progressBar;
            this.cancelable = cancelable;
        }

        public void beginTask(String name, int totalWork) {
            this.cancelled = false;
            if (!this.progressBar.isDisposed()) {
                this.progressBar.setSelection(0);
                this.progressBar.setMinimum(0);
                this.progressBar.setMaximum(totalWork);
                this.progressBar.setVisible(true);
            }
            if (this.cancelable && (this.bCancel == null || this.bCancel.isDisposed())) {
                Composite cmp = this.progressBar.getParent();
                Control[] controlArray = cmp.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control c = controlArray[n2];
                    if (c instanceof Button) {
                        c.dispose();
                    }
                    ++n2;
                }
                this.bCancel = new Button(cmp, 0x800008);
                this.bCancel.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/resources/delete_style.gif"));
                this.bCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ProgressBarMonitor.this.setCanceled(true);
                    }
                });
                cmp.layout();
            }
        }

        public void setTaskName(String name) {
        }

        public void subTask(String name) {
        }

        public void internalWorked(double work) {
        }

        public void worked(int work) {
            if (!this.progressBar.isDisposed()) {
                this.progressBar.setSelection(this.progressBar.getSelection() + work);
            }
        }

        public boolean isCanceled() {
            return this.cancelled;
        }

        public void setCanceled(boolean value) {
            this.cancelled = value;
        }

        public void done() {
            if (this.bCancel != null && !this.bCancel.isDisposed()) {
                this.bCancel.dispose();
                this.bCancel = null;
            }
            if (!this.progressBar.isDisposed()) {
                this.progressBar.setVisible(false);
            }
        }
    }
}

