/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.dataset.fields.table.column;

import com.jaspersoft.studio.property.dataset.fields.table.TColumn;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import org.apache.commons.beanutils.PropertyUtils;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

public class PropertyColumnSupport
extends EditingSupport {
    protected CellEditor editor;
    protected ColumnViewer viewer;
    protected TColumn c;

    public PropertyColumnSupport(ColumnViewer viewer, TColumn c) {
        super(viewer);
        this.c = c;
        this.viewer = viewer;
        this.editor = this.createCellEditor();
    }

    protected CellEditor createCellEditor() {
        return new TextCellEditor((Composite)this.viewer.getControl()){

            protected void doSetValue(Object value) {
                if (value == null) {
                    value = "";
                }
                if (!(value instanceof String)) {
                    value = value.toString();
                }
                super.doSetValue(value);
            }
        };
    }

    protected void setValue(Object element, Object value) {
        if (element != null) {
            try {
                if (value instanceof String && ((String)value).isEmpty() && !this.c.getPropertyType().equals(String.class.getName())) {
                    value = null;
                }
                PropertyUtils.setProperty((Object)element, (String)this.c.getPropertyName(), (Object)value);
                this.viewer.update(element, null);
            }
            catch (Exception e) {
                UIUtils.showError((Throwable)e);
            }
        }
    }

    protected Object getValue(Object element) {
        try {
            if (element != null && !element.getClass().isArray()) {
                return PropertyUtils.getProperty((Object)element, (String)this.c.getPropertyName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getText(Object element) {
        return Misc.nvl((Object)this.getValue(element), (String)"");
    }

    public String getToolTipText(Object element) {
        String tt = this.getText(element);
        if (!Misc.isNullOrEmpty((String)this.c.getDescription())) {
            tt = String.valueOf(tt) + "\n" + this.c.getDescription();
        }
        return tt;
    }

    public Image getImage(Object element) {
        return null;
    }

    protected CellEditor getCellEditor(Object element) {
        return this.editor;
    }

    protected boolean canEdit(Object element) {
        return !this.c.isReadOnly();
    }
}

