/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.dataset.wizard;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.dataset.MDataset;
import com.jaspersoft.studio.model.dataset.MDatasetRun;
import com.jaspersoft.studio.property.dataset.wizard.DatasetWizard;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.wizards.AWizardNode;
import com.jaspersoft.studio.wizards.ContextHelpIDs;
import com.jaspersoft.studio.wizards.JSSWizard;
import com.jaspersoft.studio.wizards.JSSWizardSelectionPage;
import java.text.MessageFormat;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class WizardDatasetPage
extends JSSWizardSelectionPage {
    public static final int NEW_DATASET = 0;
    public static final int EXISTING_DATASET = 1;
    public static final int NO_DATASET = 2;
    protected int selectedOption = -1;
    protected String selectedDatasetName = null;
    protected boolean mainDataset = false;
    private boolean acceptMainDataset = true;
    private Combo comboBoxDatasets;
    private Button radioButtonAddDataset;
    private Button radioButtonUseDataset;
    private String componentName = "component";

    public String getSelectedDatasetName() {
        return this.selectedDatasetName;
    }

    public boolean isMainDataset() {
        return this.mainDataset;
    }

    public int getSelectedOption() {
        return this.selectedOption;
    }

    public JRDesignDataset getSelectedDataset() {
        switch (this.getSelectedOption()) {
            case 0: {
                if (this.getSelectedNode() != null && this.getSelectedNode().getWizard() != null) {
                    DatasetWizard dw = (DatasetWizard)this.getSelectedNode().getWizard();
                    return dw.getDataset();
                }
                return null;
            }
            case 1: {
                if (this.isMainDataset()) {
                    return this.getJasperDesign().getMainDesignDataset();
                }
                return (JRDesignDataset)this.getJasperDesign().getDatasetMap().get(this.getSelectedDatasetName());
            }
        }
        return null;
    }

    public void setDataSetRun(MDatasetRun datasetrun) {
    }

    public MDatasetRun getDataSetRun() {
        return null;
    }

    public WizardDatasetPage(String componentName) {
        this(true, componentName);
    }

    public WizardDatasetPage(boolean acceptMainDataset, String componentName) {
        super("datasetpage");
        this.setTitle(Messages.common_dataset);
        this.setImageDescriptor(MDataset.getIconDescriptor().getIcon32());
        this.setDescription(Messages.WizardDatasetPage_description);
        this.acceptMainDataset = acceptMainDataset;
        this.componentName = componentName;
    }

    @Override
    protected String getContextName() {
        return ContextHelpIDs.WIZARD_SELECT_TABLE_DATASET;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        composite.setLayout((Layout)new FormLayout());
        this.radioButtonAddDataset = new Button(composite, 16);
        FormData fd_addDataset = new FormData();
        fd_addDataset.left = new FormAttachment(0, 5);
        fd_addDataset.top = new FormAttachment(0, 10);
        this.radioButtonAddDataset.setLayoutData((Object)fd_addDataset);
        this.radioButtonAddDataset.setText(MessageFormat.format(Messages.WizardDatasetPage_createDataset, this.componentName));
        this.radioButtonAddDataset.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardDatasetPage.this.handleOptionSelected();
            }
        });
        this.radioButtonUseDataset = new Button(composite, 16);
        FormData fd_selDataset = new FormData();
        fd_selDataset.top = new FormAttachment(0, 55);
        fd_selDataset.left = new FormAttachment(0, 5);
        this.radioButtonUseDataset.setLayoutData((Object)fd_selDataset);
        this.radioButtonUseDataset.setText(MessageFormat.format(Messages.WizardDatasetPage_existingDataset, this.componentName));
        this.radioButtonUseDataset.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardDatasetPage.this.setSelectedNode(null);
                WizardDatasetPage.this.comboBoxDatasets.setEnabled(WizardDatasetPage.this.radioButtonUseDataset.getSelection());
                WizardDatasetPage.this.setPageComplete(WizardDatasetPage.this.comboBoxDatasets.getSelectionIndex() >= 0);
            }
        });
        String[] dsNames = ModelUtils.getDataSets(this.getJasperDesign(), this.acceptMainDataset);
        this.comboBoxDatasets = new Combo(composite, 8);
        FormData fd_datasets = new FormData();
        fd_datasets.right = new FormAttachment(100, -48);
        fd_datasets.top = new FormAttachment(0, 79);
        fd_datasets.left = new FormAttachment(0, 30);
        this.comboBoxDatasets.setLayoutData((Object)fd_datasets);
        this.comboBoxDatasets.setItems(dsNames);
        this.comboBoxDatasets.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                WizardDatasetPage.this.handleComboBoxDatasetSelected(event);
            }
        });
        if (this.comboBoxDatasets.getItemCount() > 0) {
            this.comboBoxDatasets.select(0);
            this.handleComboBoxDatasetSelected(new Event());
        } else {
            this.radioButtonUseDataset.setEnabled(false);
        }
        if (dsNames.length > 0) {
            this.radioButtonUseDataset.setSelection(true);
            this.comboBoxDatasets.setEnabled(true);
        } else {
            this.radioButtonAddDataset.setSelection(true);
        }
        this.handleOptionSelected();
    }

    protected void handleOptionSelected() {
        this.storeSettings();
        this.comboBoxDatasets.setEnabled(this.radioButtonUseDataset.getSelection());
        if (this.radioButtonAddDataset.getSelection()) {
            this.setSelectedNode(new AWizardNode(){

                @Override
                public IWizard createWizard() {
                    IWizard pwizard = WizardDatasetPage.this.getWizard();
                    DatasetWizard w = new DatasetWizard(pwizard, pwizard.getNextPage((IWizardPage)WizardDatasetPage.this));
                    if (pwizard instanceof JSSWizard) {
                        w.setConfig(((JSSWizard)pwizard).getConfig(), false);
                    }
                    return w;
                }
            });
            this.setPageComplete(true);
        }
    }

    protected void handleComboBoxDatasetSelected(Event event) {
        this.storeSettings();
    }

    public void storeSettings() {
        this.mainDataset = false;
        this.selectedDatasetName = null;
        this.selectedOption = 0;
        if (this.radioButtonUseDataset.getSelection()) {
            this.selectedOption = 1;
        }
        if (this.selectedOption == 1 && this.comboBoxDatasets.getSelectionIndex() >= 0) {
            if (this.comboBoxDatasets.getSelectionIndex() == 0 && this.acceptMainDataset) {
                this.mainDataset = true;
            }
            this.selectedDatasetName = this.comboBoxDatasets.getItem(this.comboBoxDatasets.getSelectionIndex());
        }
    }

    private JasperDesign getJasperDesign() {
        if (this.getSettings() == null || this.getSettings().get("jasperreports_configuration") == null) {
            return null;
        }
        return ((JasperReportsConfiguration)((Object)this.getSettings().get("jasperreports_configuration"))).getJasperDesign();
    }
}

