/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.descriptor;

import com.jaspersoft.studio.property.descriptor.EditableDialogCellEditor;
import java.text.MessageFormat;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public abstract class ATextDialogRWCellEditor
extends EditableDialogCellEditor {
    private boolean isSelection = false;
    private boolean isDeleteable = false;
    private boolean isSelectable = false;
    private Composite composite;
    protected Text text;
    private ModifyListener modifyListener;
    boolean isDirty = false;

    public ATextDialogRWCellEditor(Composite parent) {
        this(parent, 0);
    }

    public ATextDialogRWCellEditor(Composite parent, int style) {
        super(parent, style);
    }

    protected Control createContents(Composite cell) {
        Color bg = cell.getBackground();
        this.composite = new Composite(cell, this.getStyle());
        this.composite.setBackground(bg);
        this.composite.setLayout((Layout)new FillLayout(256));
        this.text = new Text(this.composite, 16388);
        this.text.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ATextDialogRWCellEditor.this.handleDefaultSelection(e);
            }
        });
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                ATextDialogRWCellEditor.this.keyReleaseOccured(e);
                if (ATextDialogRWCellEditor.this.getControl() == null || ATextDialogRWCellEditor.this.getControl().isDisposed()) {
                    return;
                }
                ATextDialogRWCellEditor.this.checkSelection();
                ATextDialogRWCellEditor.this.checkDeleteable();
                ATextDialogRWCellEditor.this.checkSelectable();
            }
        });
        this.text.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2 || e.detail == 4) {
                    e.doit = false;
                }
            }
        });
        this.text.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                ATextDialogRWCellEditor.this.checkSelection();
                ATextDialogRWCellEditor.this.checkDeleteable();
                ATextDialogRWCellEditor.this.checkSelectable();
            }
        });
        this.text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
            }
        });
        this.text.setFont(this.composite.getFont());
        this.text.setBackground(this.composite.getBackground());
        this.text.setText("");
        this.text.addModifyListener(this.getModifyListener());
        return this.composite;
    }

    protected abstract Object openDialogBox(Control var1);

    protected void updateContents(Object value) {
        String txt = (String)value;
        if (txt == null) {
            txt = "";
        }
        this.text.removeModifyListener(this.getModifyListener());
        this.text.setText(txt);
        this.text.addModifyListener(this.getModifyListener());
        super.updateContents(value);
    }

    private void checkDeleteable() {
        boolean oldIsDeleteable = this.isDeleteable;
        this.isDeleteable = this.isDeleteEnabled();
        if (oldIsDeleteable != this.isDeleteable) {
            this.fireEnablementChanged("delete");
        }
    }

    private void checkSelectable() {
        boolean oldIsSelectable = this.isSelectable;
        this.isSelectable = this.isSelectAllEnabled();
        if (oldIsSelectable != this.isSelectable) {
            this.fireEnablementChanged("selectall");
        }
    }

    private void checkSelection() {
        boolean oldIsSelection = this.isSelection;
        boolean bl = this.isSelection = this.text.getSelectionCount() > 0;
        if (oldIsSelection != this.isSelection) {
            this.fireEnablementChanged("copy");
            this.fireEnablementChanged("cut");
        }
    }

    protected void doSetFocus() {
        if (this.text != null) {
            this.text.selectAll();
            this.text.setFocus();
            this.checkSelection();
            this.checkDeleteable();
            this.checkSelectable();
        }
    }

    protected ModifyListener getModifyListener() {
        if (this.modifyListener == null) {
            this.modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ATextDialogRWCellEditor.this.editOccured(e);
                }
            };
        }
        return this.modifyListener;
    }

    public void performCopy() {
        this.text.copy();
    }

    public void performCut() {
        this.text.cut();
        this.checkSelection();
        this.checkDeleteable();
        this.checkSelectable();
    }

    public void performDelete() {
        if (this.text.getSelectionCount() > 0) {
            this.text.insert("");
        } else {
            int pos = this.text.getCaretPosition();
            if (pos < this.text.getCharCount()) {
                this.text.setSelection(pos, pos + 1);
                this.text.insert("");
            }
        }
        this.checkSelection();
        this.checkDeleteable();
        this.checkSelectable();
    }

    public void performPaste() {
        this.text.paste();
        this.checkSelection();
        this.checkDeleteable();
        this.checkSelectable();
    }

    public void performSelectAll() {
        this.text.selectAll();
        this.checkSelection();
        this.checkDeleteable();
    }

    protected void keyReleaseOccured(KeyEvent keyEvent) {
        if (keyEvent.character == '\r') {
            if (this.text != null && !this.text.isDisposed() && (this.text.getStyle() & 2) != 0 && (keyEvent.stateMask & 0x40000) != 0) {
                super.keyReleaseOccured(keyEvent);
            }
            return;
        }
        super.keyReleaseOccured(keyEvent);
    }

    protected void handleDefaultSelection(SelectionEvent event) {
        this.fireApplyEditorValue();
        this.deactivate();
    }

    public boolean isCopyEnabled() {
        if (this.text == null || this.text.isDisposed()) {
            return false;
        }
        return this.text.getSelectionCount() > 0;
    }

    public boolean isCutEnabled() {
        if (this.text == null || this.text.isDisposed()) {
            return false;
        }
        return this.text.getSelectionCount() > 0;
    }

    public boolean isDeleteEnabled() {
        if (this.text == null || this.text.isDisposed()) {
            return false;
        }
        return this.text.getSelectionCount() > 0 || this.text.getCaretPosition() < this.text.getCharCount();
    }

    public boolean isPasteEnabled() {
        return this.text != null && !this.text.isDisposed();
    }

    public boolean isSaveAllEnabled() {
        return this.text != null && !this.text.isDisposed();
    }

    public boolean isSelectAllEnabled() {
        if (this.text == null || this.text.isDisposed()) {
            return false;
        }
        return this.text.getCharCount() > 0;
    }

    protected void editOccured(ModifyEvent e) {
        String tval = this.text.getText();
        if (tval == null) {
            tval = "";
        }
        String typedValue = tval;
        boolean oldValidState = this.isValueValid();
        boolean newValidState = this.isCorrect(typedValue);
        if (!newValidState) {
            this.setErrorMessage(MessageFormat.format(this.getErrorMessage(), tval));
        }
        this.setDirty(newValidState);
        this.valueChanged(oldValidState, newValidState);
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
    }
}

