/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.descriptor.checkbox;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.swt.ResourceCache;
import org.eclipse.wb.swt.SWTResourceManager;

public class CheckBoxLabelProvider2
extends LabelProvider {
    private static final String CHECKED_KEY = "CHECKED";
    private static final String UNCHECK_KEY = "UNCHECKED";
    private ResourceCache cache = new ResourceCache();

    public CheckBoxLabelProvider2() {
        if (JFaceResources.getImageRegistry().getDescriptor(CHECKED_KEY) == null) {
            JFaceResources.getImageRegistry().put(UNCHECK_KEY, this.makeShot(false));
            JFaceResources.getImageRegistry().put(CHECKED_KEY, this.makeShot(true));
        }
    }

    private Image makeShot(boolean type) {
        Display display = Display.getCurrent();
        Color greenScreen = SWTResourceManager.getColor((int)222, (int)223, (int)224);
        Shell shell = new Shell(display.getActiveShell(), 8);
        shell.setBackground(greenScreen);
        Button button = new Button((Composite)shell, 32);
        button.setBackground(greenScreen);
        button.setSelection(type);
        button.setLocation(1, 1);
        Point bsize = button.computeSize(-1, -1);
        bsize.x = Math.max(bsize.x - 1, bsize.y - 1);
        bsize.y = Math.max(bsize.x - 1, bsize.y - 1);
        button.setSize(bsize);
        shell.setSize(bsize);
        Image image = new Image((Device)display, bsize.x, bsize.y);
        shell.open();
        GC gc = new GC((Drawable)shell);
        try {
            gc.copyArea(image, 0, 0);
        }
        finally {
            gc.dispose();
            shell.close();
        }
        ImageData imageData = image.getImageData();
        imageData.transparentPixel = imageData.palette.getPixel(greenScreen.getRGB());
        image.dispose();
        Image resultImage = this.cache.getImage(imageData);
        return resultImage;
    }

    public Image getImage(Object element) {
        if (element instanceof Boolean && ((Boolean)element).booleanValue()) {
            return JFaceResources.getImageRegistry().get(CHECKED_KEY);
        }
        return JFaceResources.getImageRegistry().get(UNCHECK_KEY);
    }

    public void dispose() {
        super.dispose();
        this.cache.dispose();
    }
}

