/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.descriptor.combo;

import com.jaspersoft.studio.help.HelpSystem;
import com.jaspersoft.studio.help.IHelp;
import com.jaspersoft.studio.help.IHelpRefBuilder;
import com.jaspersoft.studio.property.descriptor.combo.RComboBoxLabelProvider;
import com.jaspersoft.studio.property.descriptor.combo.RWComboBoxCellEditor;
import com.jaspersoft.studio.property.section.AbstractSection;
import com.jaspersoft.studio.property.section.widgets.ASPropertyWidget;
import com.jaspersoft.studio.property.section.widgets.IPropertyDescriptorWidget;
import com.jaspersoft.studio.property.section.widgets.SPRCombo;
import java.util.Arrays;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class RComboBoxPropertyDescriptor
extends ComboBoxPropertyDescriptor
implements IPropertyDescriptorWidget,
IHelp {
    private String[] labels;
    private ComboBoxCellEditor cellEditor;
    private boolean isReadOnly = true;
    private SPRCombo sprCombo;
    private IHelpRefBuilder refBuilder;

    public RComboBoxPropertyDescriptor(Object id, String displayName, String[] labelsArray) {
        super(id, displayName, labelsArray);
        this.labels = labelsArray;
        this.isReadOnly = true;
    }

    public RComboBoxPropertyDescriptor(Object id, String displayName, String[] labelsArray, boolean isReadOnly) {
        super(id, displayName, labelsArray);
        this.labels = labelsArray;
        this.isReadOnly = isReadOnly;
    }

    public CellEditor createPropertyEditor(Composite parent) {
        this.cellEditor = new RWComboBoxCellEditor(parent, this.labels, this.isReadOnly ? 8 : 0);
        if (this.getValidator() != null) {
            this.cellEditor.setValidator(this.getValidator());
        }
        HelpSystem.bindToHelp((IPropertyDescriptor)this, this.cellEditor.getControl());
        return this.cellEditor;
    }

    public ILabelProvider getLabelProvider() {
        if (this.isLabelProviderSet()) {
            return super.getLabelProvider();
        }
        return new RComboBoxLabelProvider(this.labels);
    }

    public void setItems(String[] items) {
        if (Arrays.equals(items, this.labels)) {
            return;
        }
        this.labels = items;
        if (this.cellEditor != null && this.cellEditor.getControl() != null && !this.cellEditor.getControl().isDisposed()) {
            this.cellEditor.setItems(items);
        }
        if (this.sprCombo != null && !this.sprCombo.getControl().isDisposed()) {
            this.sprCombo.refresh();
        }
    }

    public String[] getItems() {
        return this.labels;
    }

    public ASPropertyWidget<RComboBoxPropertyDescriptor> createWidget(Composite parent, AbstractSection section) {
        this.sprCombo = new SPRCombo(parent, section, this);
        return this.sprCombo;
    }

    @Override
    public void setHelpRefBuilder(IHelpRefBuilder refBuilder) {
        this.refBuilder = refBuilder;
    }

    @Override
    public String getHelpReference() {
        if (this.refBuilder != null) {
            return this.refBuilder.getHelpReference();
        }
        return null;
    }
}

