/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.descriptor.expression;

import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignExpression;

public class ExprUtil {
    public static <T extends JRExpression> T setValues(T e, Object value) {
        return ExprUtil.setValues(e, value, null);
    }

    public static <T extends JRExpression> T setValues(T e, Object value, String valueClassName) {
        if (value == null) {
            return null;
        }
        String text = "";
        JRDesignExpression expr = (JRDesignExpression)e;
        expr = ExprUtil.createExpression(expr);
        if (value instanceof JRDesignExpression) {
            return (T)ExprUtil.checkEmpty((JRExpression)value);
        }
        if (value instanceof Number) {
            text = value.toString();
        }
        if (value instanceof String) {
            text = (String)value;
        }
        expr.setText(text);
        if (valueClassName != null) {
            expr.setValueClassName(valueClassName);
        }
        return (T)ExprUtil.checkEmpty(expr);
    }

    private static JRDesignExpression createExpression(JRDesignExpression expr) {
        if (expr == null) {
            expr = new JRDesignExpression();
        }
        return expr;
    }

    public static String getExpressionText(JRExpression jrExpression) {
        if (jrExpression != null) {
            return Misc.nvl((Object)jrExpression.getText(), (String)"");
        }
        return "";
    }

    public static <T extends JRExpression> T checkEmpty(T e) {
        if (e.getText().trim().isEmpty()) {
            return null;
        }
        return e;
    }

    public static JRExpression getExpression(JRExpression jrExpression) {
        return jrExpression;
    }

    public static JRDesignExpression createExpression(String text) {
        return ExprUtil.createExpression(text, null);
    }

    public static JRDesignExpression createExpression(String text, String valueClassName) {
        JRDesignExpression exp = new JRDesignExpression();
        if (text != null) {
            exp.setText(text);
        }
        if (valueClassName != null) {
            exp.setValueClassName(valueClassName);
        }
        return exp;
    }

    public static JRDesignExpression createExpression(String text, Class valueClass) {
        String valueClassName = null;
        if (valueClass != null) {
            valueClassName = valueClass.getName();
            if (valueClass.isArray()) {
                valueClassName = null;
            } else if (valueClass.isArray()) {
                valueClassName = null;
            } else if (valueClass.isPrimitive()) {
                valueClassName = null;
            }
        }
        return ExprUtil.createExpression(text, valueClassName);
    }

    public static JRExpression clone(JRExpression expr) {
        if (expr == null) {
            return null;
        }
        return (JRExpression)expr.clone();
    }
}

