/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.descriptor.jrQuery.dialog;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.MQuery;
import com.jaspersoft.studio.utils.ModelUtils;
import net.sf.jasperreports.engine.JRQuery;
import net.sf.jasperreports.engine.design.JRDesignQuery;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class JRQueryPage
extends WizardPage {
    private MQuery value;
    private Combo langCombo;
    private StyledText queryText;

    public MQuery getValue() {
        return this.value;
    }

    public void dispose() {
        String lang = "";
        int selectionIndex = this.langCombo.getSelectionIndex();
        lang = selectionIndex < 0 ? this.langCombo.getText().trim() : this.langCombo.getItem(selectionIndex);
        String text = this.queryText.getText();
        if (lang.equals("") && (text == null || text.equals(""))) {
            this.value = new MQuery(null, null);
        } else {
            JRDesignQuery jrQuery = new JRDesignQuery();
            jrQuery.setLanguage(lang);
            jrQuery.setText(text);
            this.value = new MQuery((JRQuery)jrQuery, null);
        }
        super.dispose();
    }

    public void setValue(MQuery list) {
        this.value = list;
    }

    protected JRQueryPage(String pageName) {
        super(pageName);
        this.setTitle(Messages.common_query_editor);
        this.setDescription(Messages.JRQueryPage_description);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        this.setControl((Control)composite);
        Label lbl1 = new Label(composite, 0);
        lbl1.setText(String.valueOf(Messages.common_language) + ":");
        this.langCombo = new Combo(composite, 0x800804);
        this.langCombo.setItems(ModelUtils.getQueryLanguages(this.value.getJasperConfiguration()));
        this.langCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        Label lbl2 = new Label(composite, 0);
        lbl2.setText(String.valueOf(Messages.common_query) + ":");
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        lbl2.setLayoutData((Object)gd);
        this.queryText = new StyledText(composite, 2048);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalSpan = 2;
        this.queryText.setLayoutData((Object)gd);
        this.setWidgets();
        this.queryText.setFocus();
    }

    private void setWidgets() {
        String text;
        String lang = (String)this.value.getPropertyValue("language");
        if (lang == null) {
            lang = "sql";
        }
        lang = ModelUtils.getLanguage(lang);
        String[] items = this.langCombo.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].equals(lang)) {
                this.langCombo.select(i);
                break;
            }
            ++i;
        }
        if (this.langCombo.getSelectionIndex() < 0) {
            this.langCombo.setText(lang);
        }
        if ((text = (String)this.value.getPropertyValue("text")) == null) {
            text = "";
        }
        this.queryText.setText(text);
    }
}

