/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.descriptor.parameter.dialog;

import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.property.descriptor.parameter.dialog.GenericJSSParameter;
import com.jaspersoft.studio.swt.widgets.WTextExpression;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class InputParameterDialog
extends TitleAreaDialog {
    protected Control parameterName;
    private WTextExpression parameterExpression;
    protected GenericJSSParameter resultParameter;
    private ExpressionContext expContext;
    private List<GenericJSSParameter> previousParameters;
    private String originalName = null;
    protected ModifyListener widgetModified = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            InputParameterDialog.this.updateContainer();
        }
    };

    public InputParameterDialog(Shell parentShell, GenericJSSParameter editedParameter, List<GenericJSSParameter> previousParameters) {
        super(parentShell);
        this.resultParameter = editedParameter;
        this.previousParameters = previousParameters;
        this.originalName = this.resultParameter.getName();
    }

    public InputParameterDialog(Shell parentShell, List<GenericJSSParameter> previousParameters) {
        this(parentShell, new GenericJSSParameter(), previousParameters);
        this.originalName = null;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (newShell != null) {
            newShell.setText(Messages.InputParameterDialog_dialogText);
            UIUtils.resizeAndCenterShell((Shell)newShell, (int)450, (int)300);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        container.setLayoutData((Object)new GridData(1808));
        Label parameterNameLabel = new Label(container, 0);
        parameterNameLabel.setText(Messages.InputParameterDialog_nameLabel);
        this.parameterName = this.getParameterNameControl(container);
        this.parameterName.setLayoutData((Object)new GridData(768));
        Label parameterExpressionLabel = new Label(container, 0);
        parameterExpressionLabel.setText(Messages.InputParameterDialog_expressionLabel);
        GridData parameterExpressionData = new GridData();
        parameterExpressionData.verticalAlignment = 128;
        parameterExpressionLabel.setLayoutData((Object)parameterExpressionData);
        this.parameterExpression = new WTextExpression(container, 0);
        GridData expressionData = new GridData(1808);
        expressionData.minimumHeight = 100;
        expressionData.minimumWidth = 250;
        if (this.expContext != null) {
            this.parameterExpression.setExpressionContext(this.expContext);
        }
        this.parameterExpression.setLayoutData(expressionData);
        String name = this.resultParameter.getName();
        this.setNameOnControl(name);
        JRExpression expressionValue = this.resultParameter.getExpression();
        String expression = expressionValue != null ? expressionValue.getText() : null;
        this.parameterExpression.getTextControl().setText(expression != null ? expression : "");
        this.updateContainer();
        this.configureNameControl();
        this.parameterExpression.getTextControl().addModifyListener(this.widgetModified);
        return container;
    }

    private void updateContainer() {
        this.resultParameter.setName(this.getNameFromControl());
        JRDesignExpression newExpression = new JRDesignExpression(this.parameterExpression.getText());
        this.resultParameter.setExpression((JRExpression)newExpression);
        this.validate();
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle(Messages.InputParameterDialog_dialogTitle);
        this.validate();
        return contents;
    }

    private void validate() {
        boolean isValid;
        boolean bl = isValid = !this.resultParameter.getName().trim().isEmpty();
        if (isValid) {
            for (GenericJSSParameter parameter : this.previousParameters) {
                if (!parameter.getName().equals(this.resultParameter.getName().trim())) continue;
                if (this.originalName != null && parameter.getName().equals(this.originalName)) {
                    isValid = true;
                } else {
                    isValid = false;
                    this.setMessage(Messages.InputParameterDialog_errorDuplicate, 3);
                }
                break;
            }
        } else {
            this.setMessage(Messages.InputParameterDialog_errorName, 3);
        }
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setEnabled(isValid);
        }
        if (isValid) {
            this.setMessage(Messages.InputParameterDialog_dialogDescription, 1);
        }
    }

    public void setExpressionContext(ExpressionContext expContext) {
        this.expContext = expContext;
    }

    public GenericJSSParameter getValue() {
        return this.resultParameter;
    }

    protected String getNameFromControl() {
        return ((Text)this.parameterName).getText();
    }

    protected void setNameOnControl(String name) {
        ((Text)this.parameterName).setText(name != null ? name : "");
    }

    protected Control getParameterNameControl(Composite parent) {
        return new Text(parent, 2048);
    }

    protected void configureNameControl() {
        ((Text)this.parameterName).addModifyListener(this.widgetModified);
    }
}

