/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.descriptor.propexpr;

import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.property.descriptor.propexpr.PropertyExpressionDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRPropertyExpression;
import net.sf.jasperreports.engine.type.ExpressionTypeEnum;

public class PropertyExpressionsDTO {
    protected List<PropertyExpressionDTO> properties = new ArrayList<PropertyExpressionDTO>();
    private Object jrElement;
    private ExpressionContext eContext;

    public PropertyExpressionsDTO(JRPropertyExpression[] propExpressions, JRPropertiesMap propMap, Object jrElement, ExpressionContext eContext) {
        this(jrElement, eContext);
        PropertyExpressionDTO newProp;
        JRPropertyExpression prop;
        int n;
        int n2;
        Object[] objectArray;
        if (propExpressions != null) {
            objectArray = propExpressions;
            n2 = propExpressions.length;
            n = 0;
            while (n < n2) {
                prop = objectArray[n];
                newProp = new PropertyExpressionDTO(true, prop.getName(), prop.getValueExpression().getText(), ExpressionTypeEnum.SIMPLE_TEXT == prop.getValueExpression().getType());
                newProp.seteContext(eContext);
                newProp.setJrElement(jrElement);
                this.properties.add(newProp);
                ++n;
            }
        }
        if (propMap != null) {
            objectArray = propMap.getPropertyNames();
            n2 = objectArray.length;
            n = 0;
            while (n < n2) {
                prop = objectArray[n];
                newProp = new PropertyExpressionDTO(false, (String)prop, propMap.getProperty((String)prop), false);
                newProp.seteContext(eContext);
                newProp.setJrElement(jrElement);
                this.properties.add(newProp);
                ++n;
            }
        }
    }

    public PropertyExpressionsDTO(Object jrElement, ExpressionContext eContext) {
        this.jrElement = jrElement;
        this.eContext = eContext;
    }

    public PropertyExpressionsDTO(List<PropertyExpressionDTO> properties, Object jrElement, ExpressionContext eContext) {
        this(jrElement, eContext);
        this.properties = properties;
    }

    public Object getJrElement() {
        return this.jrElement;
    }

    public void setJrElement(Object jrElement) {
        this.jrElement = jrElement;
    }

    public ExpressionContext geteContext() {
        return this.eContext;
    }

    public void seteContext(ExpressionContext eContext) {
        this.eContext = eContext;
    }

    public List<PropertyExpressionDTO> getProperties() {
        return this.properties;
    }

    public boolean removeProperty(String propertyName, boolean isExpression) {
        for (PropertyExpressionDTO prop : this.properties) {
            if (isExpression != prop.isExpression() || !propertyName.equals(prop.getName())) continue;
            this.properties.remove(prop);
            return true;
        }
        return false;
    }

    public boolean hasProperty(String propertyName, boolean isExpression) {
        for (PropertyExpressionDTO prop : this.properties) {
            if (isExpression != prop.isExpression() || !propertyName.equals(prop.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean hasProperty(String propertyName) {
        for (PropertyExpressionDTO prop : this.properties) {
            if (!propertyName.equals(prop.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean addProperty(String name, String value, boolean isExpression, boolean isSimpleText) {
        if (!this.hasProperty(name, isExpression)) {
            PropertyExpressionDTO newProp = new PropertyExpressionDTO(isExpression, name, value, isSimpleText);
            newProp.seteContext(this.eContext);
            newProp.setJrElement(this.jrElement);
            this.properties.add(newProp);
            return true;
        }
        return false;
    }

    public boolean addProperty(String name, String value, boolean isExpression, boolean isSimpleText, int position) {
        if (!this.hasProperty(name, isExpression)) {
            PropertyExpressionDTO newProp = new PropertyExpressionDTO(isExpression, name, value, isSimpleText);
            newProp.seteContext(this.eContext);
            newProp.setJrElement(this.jrElement);
            this.properties.add(position, newProp);
            return true;
        }
        return false;
    }

    public void setProperty(String name, String value, boolean isExpression, boolean isSimpleText) {
        PropertyExpressionDTO prop = this.getProperty(name, isExpression);
        if (prop != null) {
            prop.setValue(value);
            prop.setSimpleText(isSimpleText);
        } else {
            this.addProperty(name, value, isExpression, isSimpleText);
        }
    }

    public PropertyExpressionDTO getProperty(String propertyName, boolean isExpression) {
        for (PropertyExpressionDTO prop : this.properties) {
            if (isExpression != prop.isExpression() || !propertyName.equals(prop.getName())) continue;
            return prop;
        }
        return null;
    }

    public PropertyExpressionsDTO clone() {
        PropertyExpressionsDTO copy = new PropertyExpressionsDTO(this.getJrElement(), this.geteContext());
        for (PropertyExpressionDTO prop : this.getProperties()) {
            copy.addProperty(prop.getName(), prop.getValue(), prop.isExpression(), prop.isSimpleText());
        }
        return copy;
    }

    public List<PropertyExpressionDTO> findPropertiesWithSuffix(String suffix) {
        return this.properties.stream().filter(p -> p.getName().endsWith(suffix)).collect(Collectors.toList());
    }

    public void removePropertiesWithSuffix(String suffix) {
        this.properties.removeIf(p -> p.getName().endsWith(suffix));
    }
}

