/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.descriptor.propexpr.dialog;

import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.property.dataset.DatasetUtil;
import com.jaspersoft.studio.property.infoList.ElementDescription;
import com.jaspersoft.studio.property.metadata.PropertyMetadataRegistry;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.annotations.properties.PropertyScope;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignScriptlet;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.properties.PropertiesMetadataUtil;
import net.sf.jasperreports.properties.PropertyMetadata;

public class HintsPropertiesList {
    public static final String COM_JASPERSOFT_STUDIO_DATASET_LANGUAGE = "com.jaspersoft.studio.dataset.language";

    public static String getToolTip(PropertyMetadata pm) {
        String sv;
        if (pm == null) {
            return "";
        }
        String tt = String.valueOf(pm.getName()) + "\n";
        if (pm.isDeprecated()) {
            tt = String.valueOf(tt) + "\nDeprecated\n";
        }
        if (!Misc.isNullOrEmpty((String)(sv = pm.getSinceVersion()))) {
            tt = String.valueOf(tt) + "\nSince Version: " + sv + "\n";
        }
        tt = String.valueOf(tt) + "Type: " + pm.getValueType();
        if (!Misc.isNullOrEmpty((String)pm.getDescription())) {
            if (!Misc.isNullOrEmpty((String)tt)) {
                tt = String.valueOf(tt) + "\n\n";
            }
            tt = String.valueOf(tt) + pm.getDescription();
        }
        return tt;
    }

    public static List<ElementDescription> getElementProperties(Object holder, ExpressionContext eContext) {
        ArrayList<ElementDescription> result = new ArrayList<ElementDescription>();
        for (PropertyMetadata pm : HintsPropertiesList.getPropertiesMetadata(holder, eContext)) {
            result.add(new ElementDescription(pm.getName(), pm.getDescription(), true));
        }
        return result;
    }

    public static List<PropertyMetadata> getPropertiesMetadata(Object holder, ExpressionContext eContext) {
        return HintsPropertiesList.getPropertiesMetadata(holder, eContext.getJasperReportsConfiguration());
    }

    public static List<PropertyMetadata> getPropertiesMetadata(Object holder, JasperReportsConfiguration jrContext) {
        ArrayList<PropertyMetadata> result;
        block20: {
            result = new ArrayList<PropertyMetadata>();
            PropertiesMetadataUtil pmu = PropertiesMetadataUtil.getInstance((JasperReportsContext)jrContext);
            ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
            try {
                try {
                    Thread.currentThread().setContextClassLoader(JRLoader.class.getClassLoader());
                    if (holder instanceof JasperDesign) {
                        HintsPropertiesList.getReportProperties((JasperDesign)holder, jrContext, result, pmu);
                    } else if (holder instanceof JRDesignDataset) {
                        HintsPropertiesList.getDatasetProperties((JRDesignDataset)holder, jrContext, result, pmu);
                    } else if (holder instanceof JRElement) {
                        HintsPropertiesList.getElementProperties((JRElement)holder, result, pmu);
                    } else if (holder instanceof JRElementGroup) {
                        HintsPropertiesList.getElementGroupProperties((JRElementGroup)holder, result, pmu);
                    } else if (holder instanceof JRField) {
                        HintsPropertiesList.getFieldProperties(jrContext, result, pmu);
                    } else if (holder instanceof JRParameter) {
                        HintsPropertiesList.getParameterProperties(jrContext, result);
                    } else if (holder instanceof JRDesignScriptlet) {
                        HintsPropertiesList.getScriptletProperties((JRDesignScriptlet)holder, result, pmu);
                    } else {
                        HintsPropertiesList.getContextProperties(result, pmu);
                    }
                }
                catch (JRException e) {
                    e.printStackTrace();
                    Thread.currentThread().setContextClassLoader(oldCl);
                    break block20;
                }
            }
            catch (Throwable throwable) {
                Thread.currentThread().setContextClassLoader(oldCl);
                throw throwable;
            }
            Thread.currentThread().setContextClassLoader(oldCl);
        }
        ArrayList<PropertyMetadata> r = new ArrayList<PropertyMetadata>();
        HashSet<String> set = new HashSet<String>();
        for (PropertyMetadata p : result) {
            if (set.contains(p.getName())) continue;
            set.add(p.getName());
            r.add(p);
        }
        return r;
    }

    private static void getScriptletProperties(JRDesignScriptlet holder, List<PropertyMetadata> result, PropertiesMetadataUtil pmu) throws JRException {
        result.addAll(PropertyMetadataRegistry.getPropertiesMetadata(PropertyScope.SCRIPTLET));
        result.addAll(pmu.getScriptletProperties(holder.getValueClassName()));
    }

    private static void getContextProperties(List<PropertyMetadata> result, PropertiesMetadataUtil pmu) {
        List eps = pmu.getProperties();
        if (eps != null) {
            for (PropertyMetadata pm : eps) {
                if (!pm.getScopes().contains(PropertyScope.CONTEXT)) continue;
                result.add(pm);
            }
        }
        result.addAll(PropertyMetadataRegistry.getPropertiesMetadata(PropertyScope.CONTEXT));
    }

    private static void getParameterProperties(JasperReportsConfiguration jrContext, List<PropertyMetadata> result) {
        Map<String, PropertyMetadata> map = DatasetUtil.getPmap(jrContext);
        if (map == null) {
            DatasetUtil.refreshPropertiesMap(jrContext);
            map = DatasetUtil.getPmap(jrContext);
        }
        for (String key : map.keySet()) {
            PropertyMetadata pm = map.get(key);
            if (!pm.getScopes().contains(PropertyScope.PARAMETER)) continue;
            result.add(pm);
        }
    }

    private static void getFieldProperties(JasperReportsConfiguration jrContext, List<PropertyMetadata> result, PropertiesMetadataUtil pmu) throws JRException {
        List eps = pmu.getQueryExecuterFieldProperties((String)jrContext.get(COM_JASPERSOFT_STUDIO_DATASET_LANGUAGE));
        if (eps != null) {
            for (PropertyMetadata pm : eps) {
                if (!pm.getScopes().contains(PropertyScope.FIELD)) continue;
                result.add(pm);
            }
        }
        result.addAll(PropertyMetadataRegistry.getPropertiesMetadata(PropertyScope.FIELD));
    }

    private static void getElementGroupProperties(JRElementGroup holder, List<PropertyMetadata> result, PropertiesMetadataUtil pmu) {
        List eps = pmu.getContainerProperties(holder);
        if (eps != null) {
            result.addAll(eps);
        }
        result.addAll(PropertyMetadataRegistry.getPropertiesMetadata(PropertyScope.BAND));
        result.addAll(PropertyMetadataRegistry.getPropertiesMetadata(PropertyScope.FRAME));
        result.addAll(PropertyMetadataRegistry.getPropertiesMetadata(PropertyScope.CROSSTAB_CELL));
        result.addAll(PropertyMetadataRegistry.getPropertiesMetadata(PropertyScope.TABLE_CELL));
        result.addAll(PropertyMetadataRegistry.getPropertiesMetadata(PropertyScope.TABLE_COLUMN));
    }

    private static void getElementProperties(JRElement holder, List<PropertyMetadata> result, PropertiesMetadataUtil pmu) {
        List eps = pmu.getElementProperties(holder);
        if (eps != null) {
            result.addAll(eps);
        }
        result.addAll(PropertyMetadataRegistry.getPropertiesMetadata(PropertyScope.ELEMENT));
    }

    private static void getDatasetProperties(JRDesignDataset ds, JasperReportsConfiguration jrContext, List<PropertyMetadata> result, PropertiesMetadataUtil pmu) throws JRException {
        List eps = pmu.getDatasetProperties((JRDataset)ds, DatasetUtil.getDataAdapter(jrContext, ds));
        if (eps != null) {
            result.addAll(eps);
        }
        result.addAll(PropertyMetadataRegistry.getPropertiesMetadata(PropertyScope.DATASET));
    }

    private static void getReportProperties(JasperDesign holder, JasperReportsConfiguration jrContext, List<PropertyMetadata> result, PropertiesMetadataUtil pmu) throws JRException {
        List eps = pmu.getReportProperties((JRReport)holder);
        if (eps != null) {
            result.addAll(eps);
        }
        if ((eps = pmu.getDatasetProperties((JRDataset)holder.getMainDesignDataset(), DatasetUtil.getDataAdapter(jrContext, holder.getMainDesignDataset()))) != null) {
            result.addAll(eps);
        }
        result.addAll(PropertyMetadataRegistry.getPropertiesMetadata(PropertyScope.REPORT));
        result.addAll(PropertyMetadataRegistry.getPropertiesMetadata(PropertyScope.DATASET));
    }
}

