/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.descriptor.propexpr.dialog;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.dataset.DatasetPropertyExpressionDTO;
import com.jaspersoft.studio.property.descriptor.properties.dialog.PropertyDTO;
import com.jaspersoft.studio.property.descriptor.propexpr.PropertyExpressionDTO;
import com.jaspersoft.studio.property.descriptor.propexpr.dialog.HintsPropertiesList;
import com.jaspersoft.studio.property.descriptor.propexpr.dialog.JRPropertyDialog;
import com.jaspersoft.studio.swt.events.ExpressionModifiedEvent;
import com.jaspersoft.studio.swt.events.ExpressionModifiedListener;
import com.jaspersoft.studio.swt.widgets.WTextExpression;
import java.util.Collections;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.type.ExpressionTypeEnum;
import net.sf.jasperreports.engine.type.PropertyEvaluationTimeEnum;
import net.sf.jasperreports.properties.PropertyMetadata;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class JRPropertyExpressionDialog
extends JRPropertyDialog {
    protected Button buseexpr;
    protected Button simpleTextCheck;
    protected WTextExpression evalue;
    protected Composite vexp;
    private boolean updating = false;
    private Combo cevalTime;
    private boolean showExpression = true;

    public JRPropertyExpressionDialog(Shell parentShell) {
        super(parentShell);
    }

    @Override
    protected void initializeHints() {
        this.hints = HintsPropertiesList.getElementProperties(this.value.getJrElement(), this.value.geteContext());
        Collections.sort(this.hints);
    }

    @Override
    protected ModifyListener getModifyListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String newtext = JRPropertyExpressionDialog.this.cprop.getText();
                if (JRPropertyExpressionDialog.this.propertiesSuggestions != null) {
                    JRPropertyExpressionDialog.this.propertiesSuggestions.showOnlyElement(newtext);
                }
                JRPropertyExpressionDialog.this.value.setName(newtext);
                if (!JRPropertyExpressionDialog.this.value.isExpression()) {
                    for (PropertyMetadata ed : HintsPropertiesList.getPropertiesMetadata(JRPropertyExpressionDialog.this.value.getJrElement(), JRPropertyExpressionDialog.this.value.geteContext())) {
                        if (!ed.getName().equals(newtext) || ed.getDefaultValue() == null) continue;
                        JRPropertyExpressionDialog.this.tvalue.setText(ed.getDefaultValue());
                        break;
                    }
                }
            }
        };
    }

    public void setShowExpression(boolean showExpression) {
        this.showExpression = showExpression;
    }

    @Override
    protected void createAdditionalControls(Composite parent) {
        if (this.showExpression) {
            this.buseexpr = new Button(parent, 32);
            this.buseexpr.setText(Messages.JRPropertyExpressionDialog_UseExpressionCheckTxt);
            this.buseexpr.setLayoutData((Object)new GridData(4, 4, true, false));
            this.simpleTextCheck = new Button(parent, 32);
            this.simpleTextCheck.setText("Simple Text");
            this.simpleTextCheck.setToolTipText("Expression is a simple text expression where parameter, field, variable references have their values converted to string and expanded in-place in the resulting text.");
            this.simpleTextCheck.setVisible(false);
            this.simpleTextCheck.setEnabled(false);
        }
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.tvalue.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JRPropertyExpressionDialog.this.synchText();
                JRPropertyExpressionDialog.this.value.setValue(JRPropertyExpressionDialog.this.tvalue.getText());
            }
        });
        this.vexp = this.createValueExpressionControl(this.stackComposite);
        if (this.buseexpr != null) {
            this.buseexpr.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    JRPropertyExpressionDialog.this.stackLayout.topControl = JRPropertyExpressionDialog.this.buseexpr.getSelection() ? JRPropertyExpressionDialog.this.vexp : JRPropertyExpressionDialog.this.vcmp;
                    ((PropertyExpressionDTO)JRPropertyExpressionDialog.this.value).setExpression(JRPropertyExpressionDialog.this.buseexpr.getSelection());
                    if (JRPropertyExpressionDialog.this.buseexpr.getSelection()) {
                        JRPropertyExpressionDialog.this.value.setValue(JRPropertyExpressionDialog.this.evalue.getExpression().getText());
                        JRPropertyExpressionDialog.this.simpleTextCheck.setEnabled(true);
                        JRPropertyExpressionDialog.this.simpleTextCheck.setVisible(true);
                    } else {
                        JRPropertyExpressionDialog.this.value.setValue(JRPropertyExpressionDialog.this.tvalue.getText());
                        JRPropertyExpressionDialog.this.simpleTextCheck.setEnabled(false);
                        JRPropertyExpressionDialog.this.simpleTextCheck.setVisible(false);
                    }
                    JRPropertyExpressionDialog.this.stackComposite.layout();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetDefaultSelected(e);
                }
            });
        }
        if (this.simpleTextCheck != null) {
            this.simpleTextCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (JRPropertyExpressionDialog.this.value instanceof PropertyExpressionDTO) {
                        ((PropertyExpressionDTO)JRPropertyExpressionDialog.this.value).setSimpleText(JRPropertyExpressionDialog.this.simpleTextCheck.getSelection());
                    }
                }
            });
        }
        this.fillValue(this.value);
        return composite;
    }

    private Composite createValueExpressionControl(Composite cmp) {
        Composite composite = new Composite(cmp, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        if (this.value instanceof DatasetPropertyExpressionDTO) {
            Label label = new Label(composite, 0);
            label.setText(Messages.JRPropertyExpressionDialog_1);
            this.cevalTime = new Combo(composite, 8);
            this.cevalTime.setItems(new String[]{PropertyEvaluationTimeEnum.EARLY.getName(), PropertyEvaluationTimeEnum.REPORT.getName(), PropertyEvaluationTimeEnum.LATE.getName()});
            this.cevalTime.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ((DatasetPropertyExpressionDTO)JRPropertyExpressionDialog.this.value).setEvalTime(PropertyEvaluationTimeEnum.byName((String)JRPropertyExpressionDialog.this.cevalTime.getText()));
                }
            });
        }
        this.evalue = new WTextExpression(composite, 0, 1);
        this.evalue.addModifyListener(new ExpressionModifiedListener(){

            @Override
            public void expressionModified(ExpressionModifiedEvent event) {
                JRPropertyExpressionDialog.this.synchText();
            }
        });
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.heightHint = 80;
        this.evalue.setLayoutData(gd);
        this.evalue.addModifyListener(new ExpressionModifiedListener(){

            @Override
            public void expressionModified(ExpressionModifiedEvent event) {
                JRPropertyExpressionDialog.this.value.setValue(JRPropertyExpressionDialog.this.evalue.getExpression().getText());
            }
        });
        return composite;
    }

    private void fillValue(PropertyDTO value) {
        this.evalue.setExpressionContext(value.geteContext());
        if (this.cprop != null) {
            this.cprop.setText(Misc.nvl((String)value.getName()));
        }
        if (this.buseexpr != null) {
            this.buseexpr.setSelection(value.isExpression());
        }
        if (value.isExpression()) {
            this.stackLayout.topControl = this.vexp;
            this.simpleTextCheck.setEnabled(true);
            this.simpleTextCheck.setVisible(true);
            this.simpleTextCheck.setSelection(ExpressionTypeEnum.SIMPLE_TEXT == value.getValueAsExpression().getType());
            this.stackComposite.layout();
        }
        String text = Misc.nvl((String)value.getValue());
        this.tvalue.setText(text);
        this.evalue.setExpression(new JRDesignExpression(text));
        if (value instanceof DatasetPropertyExpressionDTO) {
            PropertyEvaluationTimeEnum etime = ((DatasetPropertyExpressionDTO)value).getEvalTime();
            this.cevalTime.setText(etime != null ? etime.getName() : "");
        }
    }

    protected synchronized void synchText() {
        if (!this.updating) {
            this.updating = true;
            if (this.buseexpr != null) {
                if (this.buseexpr.getSelection()) {
                    this.tvalue.setText(this.evalue.getText());
                } else {
                    this.evalue.setExpression(new JRDesignExpression(this.tvalue.getText()));
                }
            }
            this.updating = false;
        }
    }

    @Override
    protected String getValueText(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof JRExpression) {
            return ((JRExpression)value).getText();
        }
        return "";
    }
}

