/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.descriptor.propexpr.dialog;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.action.copy.PastableProperties;
import com.jaspersoft.studio.help.TableHelpListener;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.CopyElementExpressionProperty;
import com.jaspersoft.studio.model.CopyElementProperty;
import com.jaspersoft.studio.model.ICopyable;
import com.jaspersoft.studio.model.dataset.DatasetPropertyExpressionDTO;
import com.jaspersoft.studio.model.dataset.DatasetPropertyExpressionsDTO;
import com.jaspersoft.studio.property.dataset.fields.table.TColumn;
import com.jaspersoft.studio.property.dataset.fields.table.TColumnFactory;
import com.jaspersoft.studio.property.dataset.fields.table.widget.AWidget;
import com.jaspersoft.studio.property.descriptor.properties.dialog.PropertyDTO;
import com.jaspersoft.studio.property.descriptor.properties.dialog.TPropertyLabelProvider;
import com.jaspersoft.studio.property.descriptor.propexpr.PropertyExpressionDTO;
import com.jaspersoft.studio.property.descriptor.propexpr.PropertyExpressionsDTO;
import com.jaspersoft.studio.property.descriptor.propexpr.dialog.HintsPropertiesList;
import com.jaspersoft.studio.property.descriptor.propexpr.dialog.JRPropertyExpressionDialog;
import com.jaspersoft.studio.swt.widgets.table.DeleteButton;
import com.jaspersoft.studio.swt.widgets.table.EditButton;
import com.jaspersoft.studio.swt.widgets.table.IEditElement;
import com.jaspersoft.studio.swt.widgets.table.INewElement;
import com.jaspersoft.studio.swt.widgets.table.ListContentProvider;
import com.jaspersoft.studio.swt.widgets.table.ListOrderButtons;
import com.jaspersoft.studio.swt.widgets.table.NewButton;
import com.jaspersoft.studio.wizards.ContextHelpIDs;
import com.jaspersoft.studio.wizards.JSSHelpWizardPage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.properties.PropertyMetadata;
import net.sf.jasperreports.properties.StandardPropertyMetadata;
import org.apache.commons.collections4.comparators.NullComparator;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.gef.ui.actions.Clipboard;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.wb.swt.SWTResourceManager;

public class JRPropertyExpressionPage
extends JSSHelpWizardPage {
    private PropertyExpressionsDTO value;
    private Table table;
    private TableViewer tableViewer;
    private EditButton<PropertyDTO> editButton;
    private Text searchPropertyText;
    private ToolBar leftTopToolbar;
    private ToolBar rightTopToolbar;
    private ScrolledComposite scrolledCmp;
    private Composite formComposite;
    private List<PropertyMetadata> eds;
    private List<PropertyMetadata> sortedEDS;
    private Map<String, PropertyMetadata> props = new HashMap<String, PropertyMetadata>();
    private Composite sectionComposite;
    private boolean refreshing = false;
    private boolean canceled = false;
    private String search;
    private Composite mainPropertiesComposite;
    private StackLayout mainPropertiesCmpLayout;
    private Composite tableComposite;
    private boolean added = true;
    private boolean showExistingProperties = false;
    private boolean showExpression = true;
    private boolean isTableViewMode = false;
    private boolean forceStandardEditing = false;

    public void setShowExpression(boolean showExpression) {
        this.showExpression = showExpression;
    }

    public PropertyExpressionsDTO getValue() {
        return this.value;
    }

    public void setValue(PropertyExpressionsDTO value) {
        this.value = value;
        if (this.table != null) {
            this.fillTable();
        }
    }

    protected JRPropertyExpressionPage(String pageName, boolean forceStandardEditing) {
        super(pageName);
        this.forceStandardEditing = forceStandardEditing;
        this.setTitle(Messages.common_properties);
        this.setDescription(Messages.JRPropertyPage_description);
    }

    @Override
    protected String getContextName() {
        return ContextHelpIDs.WIZARD_PROPERTIES;
    }

    public void createControl(Composite parent) {
        this.getShell().addListener(31, e -> {
            if (e.detail == 4) {
                e.doit = false;
            }
        });
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        this.setControl((Control)composite);
        this.createTopToolbar(composite);
        this.mainPropertiesComposite = new Composite(composite, 0);
        this.mainPropertiesCmpLayout = new StackLayout();
        this.mainPropertiesComposite.setLayout((Layout)this.mainPropertiesCmpLayout);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 3;
        gd.heightHint = 500;
        this.mainPropertiesComposite.setLayoutData((Object)gd);
        if (this.isTableViewMode) {
            this.buildTable(this.mainPropertiesComposite);
            this.mainPropertiesCmpLayout.topControl = this.tableComposite;
            UIUtils.getDisplay().asyncExec(this::fillTable);
        } else {
            this.buildForm(this.mainPropertiesComposite);
        }
    }

    protected void buildForm(Composite propCmp) {
        this.scrolledCmp = new ScrolledComposite(propCmp, 768);
        this.scrolledCmp.setExpandHorizontal(true);
        this.scrolledCmp.setExpandVertical(true);
        this.scrolledCmp.setAlwaysShowScrollBars(true);
        this.formComposite = new Composite((Composite)this.scrolledCmp, 0);
        this.formComposite.setLayout((Layout)new GridLayout(2, false));
        this.formComposite.setBackground(SWTResourceManager.getColor((int)1));
        this.formComposite.setBackgroundMode(2);
        this.scrolledCmp.setContent((Control)this.formComposite);
        UIUtils.getDisplay().asyncExec(() -> {
            this.searchPropertyText.setFocus();
            this.createFormWidgets();
        });
        this.scrolledCmp.addListener(11, event -> this.scrolledCmp.setMinSize(this.formComposite.computeSize(this.scrolledCmp.getClientArea().width, -1)));
        this.mainPropertiesCmpLayout.topControl = this.scrolledCmp;
    }

    private void createTopToolbar(Composite parent) {
        this.leftTopToolbar = new ToolBar(parent, 0x800000);
        IPreferenceStore pstore = JaspersoftStudioPlugin.getInstance().getPreferenceStore();
        this.isTableViewMode = pstore.getBoolean("com.jaspersoft.studio.properties.view.mode");
        if (this.forceStandardEditing) {
            this.isTableViewMode = true;
        }
        ToolItem btnAddPropertyToolItem = new ToolItem(this.leftTopToolbar, 8);
        btnAddPropertyToolItem.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/plus.png"));
        btnAddPropertyToolItem.addListener(13, event -> {
            PropertyExpressionDTO v = this.value instanceof DatasetPropertyExpressionsDTO ? new DatasetPropertyExpressionDTO(false, "property.name", "value", false, null) : new PropertyExpressionDTO(false, "property.name", "value", false);
            v.seteContext(this.value.geteContext());
            v.setJrElement(this.value.getJrElement());
            JRPropertyExpressionDialog dialog = new JRPropertyExpressionDialog(UIUtils.getShell());
            dialog.setShowExpression(this.showExpression);
            dialog.setValue(v);
            if (dialog.open() == 0) {
                this.value.addProperty(v.getName(), v.getValue(), v.isExpression(), v.isSimpleText());
                this.refreshFormWidgets();
            }
        });
        btnAddPropertyToolItem.setToolTipText(Messages.JRPropertyExpressionPage_6);
        btnAddPropertyToolItem.setEnabled(!this.isTableViewMode);
        ToolItem btnShowExistingPropertiesToolItem = new ToolItem(this.leftTopToolbar, 32);
        btnShowExistingPropertiesToolItem.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/jrxml_icon.png"));
        btnShowExistingPropertiesToolItem.addListener(13, event -> {
            this.showExistingProperties = btnShowExistingPropertiesToolItem.getSelection();
            this.refreshFormWidgets();
            try {
                pstore.setValue("com.jaspersoft.studio.properties.show.set", this.showExistingProperties);
                ((ScopedPreferenceStore)pstore).save();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        btnShowExistingPropertiesToolItem.setToolTipText(Messages.JRPropertyExpressionPage_8);
        this.showExistingProperties = pstore.getBoolean("com.jaspersoft.studio.properties.show.set");
        btnShowExistingPropertiesToolItem.setSelection(this.showExistingProperties);
        btnShowExistingPropertiesToolItem.setEnabled(!this.isTableViewMode);
        this.searchPropertyText = new Text(parent, 2688);
        this.searchPropertyText.setLayoutData((Object)new GridData(768));
        this.searchPropertyText.setMessage(Messages.JRPropertyExpressionPage_0);
        this.searchPropertyText.addModifyListener(e -> {
            if (!Misc.isNullOrEmpty((String)this.search) && this.searchPropertyText.getText().trim().equalsIgnoreCase(this.search.trim())) {
                return;
            }
            this.refreshFormWidgets();
        });
        this.searchPropertyText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                if (!Misc.isNullOrEmpty((String)JRPropertyExpressionPage.this.search) && JRPropertyExpressionPage.this.searchPropertyText.getText().trim().equalsIgnoreCase(JRPropertyExpressionPage.this.search.trim())) {
                    return;
                }
                JRPropertyExpressionPage.this.refreshFormWidgets();
            }
        });
        this.searchPropertyText.setEnabled(!this.isTableViewMode);
        this.rightTopToolbar = new ToolBar(parent, 0x800000);
        ToolItem btnSwitchTableFormToolItem = new ToolItem(this.rightTopToolbar, 8);
        if (!this.isTableViewMode) {
            btnSwitchTableFormToolItem.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/resources/eclipse/properties_view.gif"));
        } else {
            btnSwitchTableFormToolItem.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/ui-scroll-pane-form.png"));
        }
        btnSwitchTableFormToolItem.addListener(13, event -> {
            if (!this.forceStandardEditing) {
                if (!this.isTableViewMode) {
                    btnSwitchTableFormToolItem.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/ui-scroll-pane-form.png"));
                    if (this.tableComposite == null) {
                        this.buildTable(this.mainPropertiesComposite);
                    }
                    this.mainPropertiesCmpLayout.topControl = this.tableComposite;
                    this.mainPropertiesComposite.layout(true);
                    this.fillTable();
                } else {
                    btnSwitchTableFormToolItem.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/resources/eclipse/properties_view.gif"));
                    if (this.scrolledCmp == null) {
                        this.buildForm(this.mainPropertiesComposite);
                    }
                    this.mainPropertiesCmpLayout.topControl = this.scrolledCmp;
                    this.mainPropertiesComposite.layout(true);
                    this.refreshFormWidgets();
                }
                btnAddPropertyToolItem.setEnabled(this.isTableViewMode);
                btnShowExistingPropertiesToolItem.setEnabled(this.isTableViewMode);
                this.searchPropertyText.setEnabled(this.isTableViewMode);
                this.isTableViewMode = !this.isTableViewMode;
                try {
                    pstore.setValue("com.jaspersoft.studio.properties.view.mode", this.isTableViewMode);
                    ((ScopedPreferenceStore)pstore).save();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        btnSwitchTableFormToolItem.setToolTipText(Messages.JRPropertyExpressionPage_12);
    }

    private void createFormWidgets() {
        this.eds = HintsPropertiesList.getPropertiesMetadata(this.value.getJrElement(), this.value.geteContext());
        for (PropertyMetadata pm : this.eds) {
            this.props.put(pm.getName(), pm);
        }
        this.refreshFormWidgets();
    }

    protected void createProperties(String search) {
        String cat = null;
        this.sectionComposite = this.formComposite;
        for (PropertyExpressionDTO pdto : this.value.getProperties()) {
            if (this.props.containsKey(pdto.getName())) continue;
            StandardPropertyMetadata v = new StandardPropertyMetadata();
            v.setName(pdto.getName());
            v.setValueType(String.class.getName());
            this.props.put(pdto.getName(), (PropertyMetadata)v);
            this.added = true;
        }
        if (this.added) {
            this.sortedEDS = new ArrayList<PropertyMetadata>(this.props.values());
            Collections.sort(this.sortedEDS, new Comparator<PropertyMetadata>(){
                private NullComparator<String> nc = new NullComparator(true);

                @Override
                public int compare(PropertyMetadata o1, PropertyMetadata o2) {
                    int i = this.nc.compare((Object)o1.getCategory(), (Object)o2.getCategory());
                    if (i != 0) {
                        return i;
                    }
                    if (o1.getCategory() != null && o2.getCategory() != null && (i = o1.getCategory().compareTo(o2.getCategory())) != 0) {
                        return i;
                    }
                    return o1.getName().compareTo(o2.getName());
                }
            });
            this.added = false;
        }
        for (PropertyMetadata pm : this.sortedEDS) {
            boolean custom;
            if (this.canceled) {
                return;
            }
            if (this.formComposite == null) {
                return;
            }
            if (this.formComposite.isDisposed()) {
                return;
            }
            if (this.showExistingProperties && !this.value.hasProperty(pm.getName())) continue;
            String c = pm.getCategory();
            if (c != null && c.indexOf(58) >= 0) {
                c = c.substring(c.indexOf(58) + 1);
            }
            if (c == null) {
                c = Messages.JRPropertyExpressionPage_13;
            }
            if (!Misc.isNullOrEmpty((String)search) && !pm.getName().toLowerCase().trim().contains(search) && (pm.getLabel() == null || !pm.getLabel().toLowerCase().trim().contains(search)) && !c.toLowerCase().trim().contains(search)) continue;
            if (!StringUtils.equals((String)c, cat)) {
                cat = c;
                this.buildSection(c);
            }
            if (this.sectionComposite == this.formComposite) {
                this.buildSectionComposite();
            }
            TColumn col = TColumnFactory.getTColumn(pm);
            boolean bl = custom = !this.eds.contains(this.props.get(pm.getName()));
            if (custom && !this.value.hasProperty(pm.getName())) continue;
            col.setLabelEditable(custom);
            UIUtils.getDisplay().syncExec(() -> {
                AWidget aWidget = TColumnFactory.addWidget(col, this.sectionComposite, this.value, this.value.geteContext().getJasperReportsConfiguration());
            });
        }
        UIUtils.getDisplay().syncExec(() -> {
            if (this.formComposite != null && this.formComposite.getChildren().length == 0) {
                Label lbl = new Label(this.formComposite, 0x1000000);
                lbl.setText(Messages.JRPropertyExpressionPage_14);
                GridData gd = new GridData(832);
                gd.horizontalSpan = 2;
                lbl.setLayoutData((Object)gd);
            }
        });
    }

    private void buildSectionComposite() {
        UIUtils.getDisplay().syncExec(() -> {
            this.sectionComposite = new Composite(this.formComposite, 0);
            this.sectionComposite.setLayout((Layout)new GridLayout(2, false));
            GridData gd = new GridData(768);
            gd.horizontalSpan = 2;
            this.sectionComposite.setLayoutData((Object)gd);
        });
    }

    private void buildSection(String cat) {
        UIUtils.getDisplay().syncExec(() -> {
            if (this.formComposite.isDisposed()) {
                return;
            }
            if (this.sectionComposite != null) {
                this.formComposite.layout(true);
                this.scrolledCmp.setMinSize(this.formComposite.computeSize(this.scrolledCmp.getClientArea().width, -1));
            }
            this.sectionComposite = new Composite(this.formComposite, 0);
            this.sectionComposite.setLayout((Layout)new GridLayout(2, false));
            GridData gd = new GridData(768);
            gd.horizontalSpan = 2;
            this.sectionComposite.setLayoutData((Object)gd);
            Label lbl = new Label(this.sectionComposite, 0);
            String gn = WordUtils.capitalizeFully((String)cat.replace(".", " "));
            gn = gn.replaceAll("Jasperreports", "JasperReports");
            lbl.setText(gn);
            lbl.setFont(SWTResourceManager.getBoldFont((Font)lbl.getFont()));
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            lbl.setLayoutData((Object)gd);
            lbl = new Label(this.sectionComposite, 258);
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            lbl.setLayoutData((Object)gd);
        });
    }

    private void buildTable(Composite parent) {
        this.tableComposite = new Composite(parent, 0);
        this.tableComposite.setLayout((Layout)new GridLayout(2, false));
        this.tableComposite.setBackground(SWTResourceManager.getColor((int)1));
        this.tableComposite.setBackgroundMode(2);
        this.table = new Table(this.tableComposite, 68098);
        this.table.setHeaderVisible(true);
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                JRPropertyExpressionPage.this.editButton.push();
            }
        });
        TableHelpListener.setTableHelp(this.table);
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TPropertyLabelProvider());
        TableColumn[] column = new TableColumn[2];
        column[0] = new TableColumn(this.table, 0);
        column[0].setText(Messages.common_name);
        column[1] = new TableColumn(this.table, 0);
        column[1].setText(Messages.JRPropertyPage_value);
        this.fillTable();
        int i = 0;
        int n = column.length;
        while (i < n) {
            column[i].pack();
            ++i;
        }
        TableLayout tlayout = new TableLayout();
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, true));
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, true));
        this.table.setLayout((Layout)tlayout);
        this.createTablePopupMenu();
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = 400;
        this.table.setLayoutData((Object)gd);
        Composite bGroup = new Composite(this.tableComposite, 0);
        bGroup.setLayout((Layout)new GridLayout(1, false));
        bGroup.setLayoutData((Object)new GridData(1040));
        new NewButton().createNewButtons(bGroup, this.tableViewer, new INewElement(){

            @Override
            public Object newElement(List<?> input, int pos) {
                int i = 1;
                String name = "newproperty";
                while (this.getName(input, name, i) == null) {
                    ++i;
                }
                name = String.valueOf(name) + "_" + i;
                String defValue = "NEW_VALUE";
                PropertyExpressionDTO v = JRPropertyExpressionPage.this.value instanceof DatasetPropertyExpressionsDTO ? new DatasetPropertyExpressionDTO(false, name, defValue, false, null) : new PropertyExpressionDTO(false, name, defValue, false);
                v.seteContext(JRPropertyExpressionPage.this.value.geteContext());
                v.setJrElement(JRPropertyExpressionPage.this.value.getJrElement());
                JRPropertyExpressionDialog dialog = new JRPropertyExpressionDialog(JRPropertyExpressionPage.this.mainPropertiesComposite.getShell());
                dialog.setShowExpression(JRPropertyExpressionPage.this.showExpression);
                dialog.setValue(v);
                if (dialog.open() == 0) {
                    return v;
                }
                return null;
            }

            private String getName(List<?> input, String name, int i) {
                name = String.valueOf(name) + "_" + i;
                for (Object dto : input) {
                    PropertyDTO prm = (PropertyDTO)dto;
                    if (prm.getName() == null || !prm.getName().trim().equals(name)) continue;
                    return null;
                }
                return name;
            }
        });
        this.editButton = new EditButton();
        this.editButton.createEditButtons(bGroup, this.tableViewer, new EditElement());
        new DeleteButton().createDeleteButton(bGroup, this.tableViewer);
        new ListOrderButtons().createOrderButtons(bGroup, this.tableViewer);
    }

    private void createTablePopupMenu() {
        Menu tableMenu = new Menu((Control)this.table);
        final MenuItem copyItem = new MenuItem(tableMenu, 0);
        copyItem.setText(Messages.common_copy);
        copyItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection selection = (StructuredSelection)JRPropertyExpressionPage.this.tableViewer.getSelection();
                ArrayList<ICopyable> copyList = new ArrayList<ICopyable>();
                for (Object selected : selection.toList()) {
                    PropertyDTO prop = (PropertyDTO)selected;
                    if (prop.isExpression()) {
                        copyList.add(new CopyElementExpressionProperty(prop.getName(), prop.getValue()));
                        continue;
                    }
                    copyList.add(new CopyElementProperty(prop.getName(), prop.getValue()));
                }
                if (!copyList.isEmpty()) {
                    PastableProperties container = new PastableProperties(copyList);
                    Clipboard.getDefault().setContents((Object)container);
                }
            }
        });
        final MenuItem pasteItem = new MenuItem(tableMenu, 0);
        pasteItem.setText(Messages.common_paste);
        pasteItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PastableProperties pasteContainer = (PastableProperties)Clipboard.getDefault().getContents();
                List<CopyElementExpressionProperty> copiedProperties = pasteContainer.getCopiedProperties();
                for (CopyElementExpressionProperty property : copiedProperties) {
                    if (!JRPropertyExpressionPage.this.value.hasProperty(property.getPropertyName(), property.isExpression())) {
                        JRPropertyExpressionPage.this.value.addProperty(property.getPropertyName(), property.getValue(), property.isExpression(), property.isSimpleText());
                        continue;
                    }
                    JRPropertyExpressionPage.this.value.setProperty(property.getPropertyName(), property.getValue(), property.isExpression(), property.isSimpleText());
                }
                JRPropertyExpressionPage.this.tableViewer.setInput(JRPropertyExpressionPage.this.value.getProperties());
            }
        });
        tableMenu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                copyItem.setEnabled(!JRPropertyExpressionPage.this.tableViewer.getSelection().isEmpty());
                boolean pasteEnabled = false;
                if (Clipboard.getDefault().getContents() instanceof PastableProperties) {
                    PastableProperties pasteContainer = (PastableProperties)Clipboard.getDefault().getContents();
                    List<CopyElementExpressionProperty> copiedProperties = pasteContainer.getCopiedProperties();
                    pasteEnabled = JRPropertyExpressionPage.this.canPaste(copiedProperties);
                }
                pasteItem.setEnabled(pasteEnabled);
            }
        });
        this.table.setMenu(tableMenu);
    }

    private boolean canPaste(List<CopyElementExpressionProperty> copiedProperties) {
        return copiedProperties != null && !copiedProperties.isEmpty();
    }

    private void fillTable() {
        this.tableViewer.setInput(this.value.getProperties());
        this.tableViewer.refresh(true);
    }

    protected void refreshFormWidgets() {
        if (this.refreshing) {
            this.canceled = true;
            return;
        }
        this.refreshing = true;
        Job job = new Job(Messages.JRPropertyExpressionPage_21){

            protected IStatus run(IProgressMonitor monitor) {
                boolean ex = JRPropertyExpressionPage.this.showExistingProperties;
                try {
                    UIUtils.getDisplay().syncExec(() -> {
                        JRPropertyExpressionPage.this.search = JRPropertyExpressionPage.this.searchPropertyText.getText();
                        if (JRPropertyExpressionPage.this.formComposite != null) {
                            Control[] controlArray = JRPropertyExpressionPage.this.formComposite.getChildren();
                            int n = controlArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Control c = controlArray[n2];
                                if (c != JRPropertyExpressionPage.this.searchPropertyText && c != JRPropertyExpressionPage.this.leftTopToolbar && c != JRPropertyExpressionPage.this.rightTopToolbar) {
                                    c.dispose();
                                }
                                ++n2;
                            }
                        }
                    });
                    JRPropertyExpressionPage.this.canceled = false;
                    JRPropertyExpressionPage.this.createProperties(JRPropertyExpressionPage.this.search.trim().toLowerCase());
                    if (!JRPropertyExpressionPage.this.canceled) {
                        UIUtils.getDisplay().syncExec(() -> {
                            if (JRPropertyExpressionPage.this.formComposite == null || JRPropertyExpressionPage.this.formComposite.isDisposed()) {
                                return;
                            }
                            JRPropertyExpressionPage.this.scrolledCmp.setMinSize(JRPropertyExpressionPage.this.formComposite.computeSize(JRPropertyExpressionPage.this.scrolledCmp.getClientArea().width, -1));
                            JRPropertyExpressionPage.this.formComposite.layout(true);
                        });
                    }
                }
                catch (Throwable throwable) {
                    JRPropertyExpressionPage.this.refreshing = false;
                    UIUtils.getDisplay().syncExec(() -> {
                        if (!JRPropertyExpressionPage.this.searchPropertyText.isDisposed() && !JRPropertyExpressionPage.this.search.equals(JRPropertyExpressionPage.this.searchPropertyText.getText()) || ex != JRPropertyExpressionPage.this.showExistingProperties) {
                            JRPropertyExpressionPage.this.refreshFormWidgets();
                        }
                    });
                    throw throwable;
                }
                JRPropertyExpressionPage.this.refreshing = false;
                UIUtils.getDisplay().syncExec(() -> {
                    if (!JRPropertyExpressionPage.this.searchPropertyText.isDisposed() && !JRPropertyExpressionPage.this.search.equals(JRPropertyExpressionPage.this.searchPropertyText.getText()) || ex != JRPropertyExpressionPage.this.showExistingProperties) {
                        JRPropertyExpressionPage.this.refreshFormWidgets();
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.setPriority(20);
        job.schedule();
    }

    private final class EditElement
    implements IEditElement<PropertyDTO> {
        private EditElement() {
        }

        @Override
        public void editElement(List<PropertyDTO> input, int pos) {
            PropertyDTO v = input.get(pos);
            if (v == null) {
                return;
            }
            JRPropertyExpressionDialog dialog = new JRPropertyExpressionDialog(UIUtils.getShell());
            PropertyDTO editedValue = v.clone();
            dialog.setShowExpression(JRPropertyExpressionPage.this.showExpression);
            dialog.setValue(editedValue);
            if (dialog.open() == 0) {
                input.set(pos, editedValue);
            }
        }
    }
}

