/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.descriptor.subreport.parameter.dialog;

import com.jaspersoft.studio.model.subreport.MSubreport;
import com.jaspersoft.studio.property.descriptor.parameter.dialog.ParameterEditor;
import com.jaspersoft.studio.property.descriptor.parameter.dialog.ParameterPage;
import com.jaspersoft.studio.property.descriptor.subreport.parameter.dialog.SubreportParameterPage;
import com.jaspersoft.studio.utils.ExpressionUtil;
import com.jaspersoft.studio.utils.jasper.ExtensionLoader;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignSubreport;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import org.eclipse.core.resources.IFile;

public class SubreportParameterEditor
extends ParameterEditor {
    private JRReport subreportDesign;
    private boolean isLoading = false;
    private JasperDesign jd;
    private MSubreport subReport;

    public SubreportParameterEditor(MSubreport subReport) {
        this.jd = subReport.getJasperDesign();
        this.subReport = subReport;
        this.preloadReport(subReport);
    }

    @Override
    protected ParameterPage getEditingPage() {
        SubreportParameterPage page = new SubreportParameterPage(this.subReport, this.jd, this.getSubreportJasperDesign());
        return page;
    }

    private synchronized void setLoading(boolean value) {
        this.isLoading = value;
    }

    private synchronized boolean isLoading() {
        return this.isLoading;
    }

    public JRReport getSubreportJasperDesign() {
        while (this.isLoading()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return this.subreportDesign;
    }

    private void preloadReport(final MSubreport subreport) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                SubreportParameterEditor.this.setLoading(true);
                try {
                    JRExpression subreportExp;
                    ExtensionLoader.waitIfLoading();
                    Object reportFileName = null;
                    JRDesignSubreport jrSubreport = subreport.getValue();
                    JasperReportsConfiguration context = subreport.getJasperConfiguration();
                    if (jrSubreport != null && (subreportExp = jrSubreport.getExpression()) != null) {
                        JRDesignDataset dataset = (JRDesignDataset)subreport.getJasperDesign().getMainDataset();
                        reportFileName = ExpressionUtil.cachedExpressionEvaluation(subreportExp, context, dataset);
                    }
                    if (reportFileName != null) {
                        if (reportFileName instanceof File) {
                            reportFileName = ((File)reportFileName).toURI().toString();
                        }
                        if (!(reportFileName instanceof String)) {
                            return;
                        }
                        Object location = reportFileName;
                        File f = SubreportParameterEditor.findFile((String)location, context);
                        if ((f == null || !f.exists()) && ((String)location).toLowerCase().endsWith(".jasper")) {
                            location = String.valueOf(((String)location).substring(0, ((String)location).length() - ".jasper".length())) + ".jrxml";
                            f = SubreportParameterEditor.findFile((String)location, context);
                        }
                        SubreportParameterEditor.this.subreportDesign = f.getName().toLowerCase().endsWith(".jasper") ? (JRReport)JRLoader.loadObject((File)f) : JRXmlLoader.load((File)f);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    SubreportParameterEditor.this.subreportDesign = null;
                }
                SubreportParameterEditor.this.setLoading(false);
            }
        });
        t.start();
    }

    public static File findFile(String location, JasperReportsConfiguration context) {
        IFile file;
        File f = new File(location);
        if (f.exists()) {
            return f;
        }
        URL url = context.getClassLoader().getResource(location);
        if (url != null) {
            try {
                f = new File(url.toURI());
                if (f.exists()) {
                    return f;
                }
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        if ((file = (IFile)context.get("ifile")) != null) {
            f = new File(file.getParent().getLocationURI());
            if ((f = new File(f, location)).exists()) {
                return f;
            }
            f = new File(file.getProject().getLocationURI());
            if ((f = new File(f, location)).exists()) {
                return f;
            }
        }
        return null;
    }
}

