/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.descriptor.tabstops;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.property.descriptor.tabstops.TabStopsCellEditor;
import com.jaspersoft.studio.property.descriptor.tabstops.TabStopsLabelProvider;
import com.jaspersoft.studio.property.descriptor.tabstops.dialog.TabStopsEditor;
import com.jaspersoft.studio.property.descriptor.text.NTextPropertyDescriptor;
import com.jaspersoft.studio.property.section.AbstractSection;
import com.jaspersoft.studio.property.section.widgets.ASPropertyWidget;
import com.jaspersoft.studio.property.section.widgets.SPButton;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.TabStop;
import net.sf.jasperreports.engine.util.JRCloneUtils;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class TabStopsPropertyDescriptor
extends NTextPropertyDescriptor {
    public TabStopsPropertyDescriptor(Object id, String displayName) {
        super(id, displayName);
    }

    @Override
    public CellEditor createPropertyEditor(Composite parent) {
        TabStopsCellEditor editor = new TabStopsCellEditor(parent);
        return editor;
    }

    public ILabelProvider getLabelProvider() {
        if (this.isLabelProviderSet()) {
            return super.getLabelProvider();
        }
        return new TabStopsLabelProvider();
    }

    @Override
    public ASPropertyWidget<? extends IPropertyDescriptor> createWidget(Composite parent, AbstractSection section) {
        return new SPButton<IPropertyDescriptor>(parent, section, (IPropertyDescriptor)this, Messages.MParagraph_tabStopsTitle){
            private List<TabStop> value;

            @Override
            protected void handleButtonPressed() {
                TabStopsEditor wizard = new TabStopsEditor();
                wizard.setValue(JRCloneUtils.cloneList(this.value));
                WizardDialog dialog = new WizardDialog(UIUtils.getShellForWizardDialog(), (IWizard)wizard);
                dialog.create();
                if (dialog.open() == 0) {
                    this.section.changeProperty(this.pDescriptor.getId(), wizard.getValue());
                }
            }

            @Override
            public void setData(APropertyNode pnode, Object value) {
                this.value = (List)value;
                String size = Misc.isNullOrEmpty(this.value) ? " (Empty)" : " (" + this.value.size() + ")";
                this.button.setText(String.valueOf(Messages.MParagraph_tabStopsTitle) + size);
                this.button.getParent().layout();
            }
        };
    }
}

