/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.descriptors;

import com.jaspersoft.studio.editor.layout.FreeLayout;
import com.jaspersoft.studio.editor.layout.ILayout;
import com.jaspersoft.studio.editor.layout.LayoutManager;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.property.descriptors.AbstractJSSCellEditorValidator;
import java.text.MessageFormat;
import net.sf.jasperreports.engine.design.JRDesignElement;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Point;

public class JSSPixelLocationValidator
extends AbstractJSSCellEditorValidator {
    public String propertyID;

    public JSSPixelLocationValidator(String propertyID) {
        this.propertyID = propertyID;
    }

    public String isValid(Object value) {
        try {
            if (value == null) {
                return Messages.JSSPixelEditorValidator_errorNull;
            }
            if (value instanceof String) {
                value = new Integer((String)value);
            }
            if (this.isSizeNegative(value, this.propertyID)) {
                return Messages.JSSPixelEditorValidator_errorNegative;
            }
            Object newValue = this.checkValid(this.getTarget(), value, this.propertyID);
            if (newValue != value) {
                return MessageFormat.format(Messages.JSSPixelEditorValidator_errorExceed, newValue);
            }
            if (!this.checkLayoutValidity(value)) {
                return Messages.JSSPixelLocationValidator_errorLayout;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return Messages.common_this_is_not_an_integer_number;
        }
        return null;
    }

    private boolean checkLayoutValidity(Object value) {
        ANode parent = this.getTarget().getParent();
        JRDesignElement jrElement = (JRDesignElement)this.getTarget().getValue();
        Class<? extends ILayout> currentLayout = LayoutManager.getContainerLayout(parent);
        if (currentLayout == FreeLayout.class) {
            return true;
        }
        int currentHeight = jrElement.getHeight();
        int currentWidth = jrElement.getWidth();
        int currentX = jrElement.getX();
        int currentY = jrElement.getY();
        Rectangle oldBounds = new Rectangle(currentX, currentY, currentWidth, currentHeight);
        if ("height".equals(this.propertyID)) {
            currentHeight = (Integer)value;
        } else if ("width".equals(this.propertyID)) {
            currentWidth = (Integer)value;
        } else if ("x".equals(this.propertyID)) {
            currentX = (Integer)value;
        } else if ("y".equals(this.propertyID)) {
            currentY = (Integer)value;
        }
        Rectangle newBounds = new Rectangle(currentX, currentY, currentWidth, currentHeight);
        return LayoutManager.getLayout(currentLayout.getName()).allowChildBoundChange(this.getTarget(), oldBounds, newBounds);
    }

    protected boolean isSizeNegative(Object value, Object propertyId) {
        int newWidth;
        int newHeight;
        return "height".equals(this.propertyID) ? (newHeight = ((Integer)value).intValue()) < 0 : "width".equals(this.propertyID) && (newWidth = ((Integer)value).intValue()) < 0;
    }

    protected Object checkValid(ANode node, Object value, Object propertyID) {
        if (node == null) {
            return value;
        }
        if ("height".equals(propertyID)) {
            Point maximumSize = node.getAvailableSize();
            MGraphicElement gElement = (MGraphicElement)node;
            JRDesignElement jrElement = gElement.getValue();
            int newHeight = (Integer)value;
            if (newHeight < 0) {
                return 0;
            }
            if (Math.abs(jrElement.getY() + newHeight) > maximumSize.y) {
                int delta = maximumSize.y - jrElement.getY();
                return delta;
            }
            return value;
        }
        if ("width".equals(propertyID)) {
            Point maximumSize = node.getAvailableSize();
            MGraphicElement gElement = (MGraphicElement)node;
            JRDesignElement jrElement = gElement.getValue();
            int newWidth = (Integer)value;
            if (newWidth < 0) {
                return 0;
            }
            if (Math.abs(jrElement.getX() + newWidth) > maximumSize.x) {
                int delta = maximumSize.x - jrElement.getX();
                return delta;
            }
            return value;
        }
        if ("x".equals(propertyID)) {
            Point maximumSize = node.getAvailableSize();
            MGraphicElement gElement = (MGraphicElement)node;
            JRDesignElement jrElement = gElement.getValue();
            int newX = (Integer)value;
            if (Math.abs(jrElement.getWidth() + newX) > maximumSize.x) {
                if (newX >= 0) {
                    if (Math.abs(jrElement.getWidth()) + newX > maximumSize.x) {
                        int delta = maximumSize.x - jrElement.getWidth();
                        return delta;
                    }
                } else if (Math.abs(newX) > maximumSize.x) {
                    int delta = -maximumSize.x;
                    return delta;
                }
            }
        } else if ("y".equals(propertyID)) {
            Point maximumSize = node.getAvailableSize();
            MGraphicElement gElement = (MGraphicElement)node;
            JRDesignElement jrElement = gElement.getValue();
            int newY = (Integer)value;
            if (Math.abs(jrElement.getHeight() + newY) > maximumSize.y) {
                if (newY >= 0) {
                    if (Math.abs(jrElement.getHeight()) + newY > maximumSize.y) {
                        int delta = maximumSize.y - jrElement.getHeight();
                        return delta;
                    }
                } else if (Math.abs(newY) > maximumSize.y) {
                    int delta = -maximumSize.y;
                    return delta;
                }
            }
        }
        return value;
    }
}

