/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.descriptors;

import com.jaspersoft.studio.help.HelpSystem;
import com.jaspersoft.studio.help.IHelp;
import com.jaspersoft.studio.help.IHelpRefBuilder;
import com.jaspersoft.studio.messages.MessagesByKeys;
import com.jaspersoft.studio.property.descriptor.NullEnum;
import com.jaspersoft.studio.property.descriptors.IEnumDescriptors;
import com.jaspersoft.studio.property.descriptors.NamedEnumCellEditor;
import com.jaspersoft.studio.property.descriptors.NamedEnumLabelProvider;
import com.jaspersoft.studio.property.section.AbstractSection;
import com.jaspersoft.studio.property.section.widgets.ASPropertyWidget;
import com.jaspersoft.studio.property.section.widgets.IPropertyDescriptorWidget;
import com.jaspersoft.studio.property.section.widgets.SPReadComboEnum;
import java.util.ArrayList;
import java.util.HashMap;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.type.NamedEnum;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class NamedEnumPropertyDescriptor<T extends Enum<?>>
extends ComboBoxPropertyDescriptor
implements IPropertyDescriptorWidget,
IHelp,
IEnumDescriptors {
    private NullEnum type;
    private T[] jrEnums;
    private T nenum;
    private String[] allItems;
    private IHelpRefBuilder refBuilder;
    private static HashMap<Class<?>, Object[]> enumValuesMap = new HashMap();

    public NamedEnumPropertyDescriptor(Object id, String displayName, T nenum, NullEnum type) {
        super((Object)Misc.nvl((Object)id, (String)""), Misc.nvl((String)displayName), NamedEnumPropertyDescriptor.getEnumItems((NamedEnum[])((Enum)nenum).getDeclaringClass().getEnumConstants(), type));
        this.nenum = nenum;
        this.type = type;
        this.allItems = NamedEnumPropertyDescriptor.getEnumItems((NamedEnum[])((Enum)nenum).getDeclaringClass().getEnumConstants(), type);
        this.jrEnums = (Enum[])((Enum)nenum).getDeclaringClass().getEnumConstants();
        this.setLabelProvider((ILabelProvider)new NamedEnumLabelProvider(this.allItems));
    }

    public static String[] getEnumItems(NamedEnum[] items, NullEnum type) {
        ArrayList<String> res = new ArrayList<String>();
        if (type != NullEnum.NOTNULL) {
            res.add(type.getName());
        }
        int i = 0;
        while (i < items.length) {
            String eval = MessagesByKeys.getString(items[i].getName());
            try {
                Deprecated dep = items[i].getClass().getField(((Enum)items[i]).name()).getAnnotation(Deprecated.class);
                if (dep != null) {
                    eval = String.valueOf(eval) + " (deprecated)";
                }
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            res.add(eval);
            ++i;
        }
        return res.toArray(new String[res.size()]);
    }

    public CellEditor createPropertyEditor(Composite parent) {
        NamedEnumCellEditor editor = new NamedEnumCellEditor(parent, this.allItems, 8);
        if (this.getValidator() != null) {
            editor.setValidator(this.getValidator());
        }
        HelpSystem.bindToHelp((IPropertyDescriptor)this, editor.getControl());
        return editor;
    }

    public Integer getIntValue(T jrvalue) {
        if (jrvalue == null) {
            return 0;
        }
        int ind = 0;
        while (ind < this.jrEnums.length) {
            if (this.jrEnums[ind] == jrvalue) break;
            ++ind;
        }
        if (this.type != NullEnum.NOTNULL) {
            ++ind;
        }
        return ind;
    }

    public T getEnumValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value.getClass().isAssignableFrom(this.nenum.getClass())) {
            return (T)((Enum)value);
        }
        if (value instanceof String) {
            String v = (String)value;
            if (this.type != NullEnum.NOTNULL && Misc.isNullOrEmpty((String)v)) {
                return null;
            }
            T[] TArray = this.jrEnums;
            int n = this.jrEnums.length;
            int n2 = 0;
            while (n2 < n) {
                T en = TArray[n2];
                if (((NamedEnum)en).getName().equals(v)) {
                    return en;
                }
                ++n2;
            }
        }
        if (value instanceof Integer) {
            int ind = (Integer)value;
            if (this.type != NullEnum.NOTNULL && ind == 0) {
                return null;
            }
            if (this.type != NullEnum.NOTNULL) {
                --ind;
            }
            return this.jrEnums[ind];
        }
        return null;
    }

    @Override
    public String[] getEnumItems() {
        return this.allItems;
    }

    public T[] getEnumElements() {
        return this.jrEnums;
    }

    @Override
    public NullEnum getType() {
        return this.type;
    }

    public ASPropertyWidget<NamedEnumPropertyDescriptor<T>> createWidget(Composite parent, AbstractSection section) {
        return new SPReadComboEnum<NamedEnumPropertyDescriptor<T>>(parent, section, this);
    }

    @Override
    public void setHelpRefBuilder(IHelpRefBuilder refBuilder) {
        this.refBuilder = refBuilder;
    }

    @Override
    public String getHelpReference() {
        if (this.refBuilder != null) {
            return this.refBuilder.getHelpReference();
        }
        return null;
    }

    public ILabelProvider getLabelProvider() {
        if (this.isLabelProviderSet()) {
            return super.getLabelProvider();
        }
        return new NamedEnumLabelProvider(this.allItems);
    }

    private static <T extends Enum<?>> T[] getEnumValues(Class<T> enumClass) {
        Object[] cachedEnum = enumValuesMap.get(enumClass);
        if (cachedEnum == null) {
            cachedEnum = enumClass.getEnumConstants();
            enumValuesMap.put(enumClass, cachedEnum);
        }
        return (Enum[])cachedEnum;
    }

    public static <T extends Enum<?>> Integer getIntValue(NullEnum type, T jrvalue) {
        return NamedEnumPropertyDescriptor.getIntValue(jrvalue, type, jrvalue);
    }

    public static <T extends Enum<?>> Integer getIntValue(T nenum, NullEnum type, T jrvalue) {
        if (jrvalue == null) {
            return 0;
        }
        int ind = 0;
        Enum[] jrEnums = NamedEnumPropertyDescriptor.getEnumValues(nenum.getDeclaringClass());
        while (ind < jrEnums.length) {
            if (jrEnums[ind] == jrvalue) break;
            ++ind;
        }
        if (type != NullEnum.NOTNULL) {
            ++ind;
        }
        return ind;
    }

    public static <T extends Enum<?>> T getEnumValue(T nenum, NullEnum type, Object value) {
        if (value == null) {
            return null;
        }
        if (value.getClass().isAssignableFrom(nenum.getClass())) {
            return (T)((Enum)value);
        }
        Enum[] jrEnums = NamedEnumPropertyDescriptor.getEnumValues(nenum.getDeclaringClass());
        if (value instanceof String) {
            String v = (String)value;
            if (type != NullEnum.NOTNULL && Misc.isNullOrEmpty((String)v)) {
                return null;
            }
            Enum[] enumArray = jrEnums;
            int n = jrEnums.length;
            int n2 = 0;
            while (n2 < n) {
                Enum en = enumArray[n2];
                if (((NamedEnum)en).getName().equals(v)) {
                    return (T)en;
                }
                ++n2;
            }
        }
        if (value instanceof Integer) {
            int ind = (Integer)value;
            if (type != NullEnum.NOTNULL && ind == 0) {
                return null;
            }
            if (type != NullEnum.NOTNULL) {
                --ind;
            }
            return (T)jrEnums[ind];
        }
        return null;
    }
}

