/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.itemproperty.celleditor;

import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.property.descriptor.EditableDialogCellEditor;
import com.jaspersoft.studio.property.itemproperty.desc.ADescriptor;
import com.jaspersoft.studio.property.itemproperty.desc.AItemDataListPropertyDescriptor;
import com.jaspersoft.studio.property.itemproperty.dialog.ItemDataListDialog;
import com.jaspersoft.studio.property.itemproperty.label.ItemLabelProvider;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.components.items.ItemData;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.util.JRCloneUtils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ItemListCellEditor
extends EditableDialogCellEditor {
    private ItemLabelProvider labelProvider;
    private ADescriptor descriptor;
    private ExpressionContext expContext;
    private AItemDataListPropertyDescriptor pd;
    private APropertyNode pNode;

    public ItemListCellEditor(Composite parent, ExpressionContext expContext, ADescriptor descriptor, AItemDataListPropertyDescriptor pd, APropertyNode pNode) {
        super(parent);
        this.descriptor = descriptor;
        this.expContext = expContext;
        this.pd = pd;
        this.pNode = pNode;
    }

    public ItemListCellEditor(Composite parent, int style) {
        super(parent, style);
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        ArrayList<ItemData> v = JRCloneUtils.cloneList((List)((List)this.getValue()));
        if (v == null) {
            v = new ArrayList<ItemData>();
        }
        ItemDataListDialog dialog = new ItemDataListDialog(UIUtils.getShell(), this.descriptor, v, this.pd, this.pNode);
        dialog.setExpressionContext(this.expContext);
        if (dialog.open() == 0) {
            return dialog.getValue();
        }
        return null;
    }

    public void setLabelProvider(ItemLabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    protected void updateContents(Object value) {
        if (this.getDefaultLabel() == null) {
            return;
        }
        if (this.labelProvider == null) {
            this.labelProvider = new ItemLabelProvider(this.descriptor);
        }
        String text = this.labelProvider.getText(value);
        this.getDefaultLabel().setText(text);
    }

    public void setPNode(APropertyNode pNode) {
        this.pNode = pNode;
    }

    public void setExpressionContext(ExpressionContext expContext) {
        this.expContext = expContext;
    }
}

