/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.itemproperty.dialog;

import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.editor.expression.IExpressionContextSetter;
import com.jaspersoft.studio.jface.dialogs.EditableDatasetBaseComposite;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.dataset.ComponentElementDatasetAdapter;
import com.jaspersoft.studio.model.dataset.ComponentElementDatasetRunAdapter;
import com.jaspersoft.studio.model.dataset.IEditableDatasetRun;
import com.jaspersoft.studio.property.dataset.DatasetRunSelectionListener;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import net.sf.jasperreports.engine.JRElementDataset;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignElementDataset;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ElementDatasetDialog
extends TitleAreaDialog
implements IExpressionContextSetter {
    private String title;
    private String message;
    private JRDesignElementDataset dataset;
    private JasperReportsConfiguration jConfig;
    protected EditableDatasetBaseComposite compositeDatasetInfo;
    private ExpressionContext expContext;

    public ElementDatasetDialog(Shell parentShell, String title, String message, JRElementDataset dataset, JasperReportsConfiguration jConfig) {
        super(parentShell);
        this.title = title;
        this.message = message;
        this.dataset = (JRDesignElementDataset)dataset;
        if (this.dataset == null) {
            this.dataset = new JRDesignElementDataset();
        }
        this.jConfig = jConfig;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.ElementDatasetDialog_0);
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        this.createElementDatasetArea(area);
        return area;
    }

    protected void createElementDatasetArea(Composite area) {
        this.preElementDataset(area);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new FillLayout());
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        this.compositeDatasetInfo = new EditableDatasetBaseComposite(new ComponentElementDatasetAdapter(this.dataset, this.jConfig), container, 0){

            @Override
            protected IEditableDatasetRun getEditableDatesetRun() {
                return new ComponentElementDatasetRunAdapter(this.getEditableDataset());
            }
        };
        this.compositeDatasetInfo.addDatasetRunSelectionListener(new DatasetRunSelectionListener(){

            @Override
            public void selectionChanged() {
                ExpressionContext contextFromDSRun = ElementDatasetDialog.this.getExpressionContextFromDSRun();
                ElementDatasetDialog.this.compositeDatasetInfo.setExpressionContext(contextFromDSRun);
            }
        });
        this.compositeDatasetInfo.setExpressionContext(this.getExpressionContextFromDSRun());
        this.compositeDatasetInfo.setDefaultExpressionContext(this.expContext);
        this.setTitle(this.title);
        this.setMessage(this.message);
    }

    protected void preElementDataset(Composite parent) {
    }

    @Override
    public void setExpressionContext(ExpressionContext expContext) {
        this.expContext = expContext;
    }

    private ExpressionContext getExpressionContextFromDSRun() {
        if (this.dataset != null) {
            JRDesignDataset ds = ModelUtils.getDesignDatasetForDatasetRun(this.jConfig.getJasperDesign(), this.dataset.getDatasetRun());
            return new ExpressionContext(ds, this.jConfig);
        }
        return null;
    }

    public JRElementDataset getDataset() {
        return this.dataset;
    }
}

