/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.itemproperty.label;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.property.itemproperty.desc.ADescriptor;
import com.jaspersoft.studio.property.itemproperty.desc.DescriptorPropertyLabelProvider;
import com.jaspersoft.studio.widgets.framework.ui.ItemPropertyDescription;
import java.util.Collection;
import net.sf.jasperreports.components.items.Item;
import net.sf.jasperreports.components.items.ItemData;
import net.sf.jasperreports.components.items.ItemProperty;
import net.sf.jasperreports.components.items.StandardItem;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRElementDataset;
import net.sf.jasperreports.engine.type.DatasetResetTypeEnum;
import net.sf.jasperreports.engine.type.IncrementTypeEnum;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class ItemLabelProvider
extends ColumnLabelProvider
implements ITableLabelProvider {
    private DescriptorPropertyLabelProvider iplp;
    private ADescriptor descriptor;

    public ItemLabelProvider(ADescriptor showProperties) {
        this.descriptor = showProperties;
        this.iplp = new DescriptorPropertyLabelProvider(this.descriptor);
    }

    public String getText(Object element) {
        if (element instanceof Collection) {
            return String.valueOf(((Collection)element).size()) + Messages.ItemLabelProvider_1;
        }
        if (element instanceof JRElementDataset) {
            JRDatasetRun dsrun = ((JRElementDataset)element).getDatasetRun();
            if (dsrun == null) {
                return Messages.ItemLabelProvider_3;
            }
            return this.getText(dsrun);
        }
        if (element instanceof JRDatasetRun) {
            return Misc.nvl((Object)((JRDatasetRun)element).getDatasetName(), (String)Messages.ItemLabelProvider_3);
        }
        if (element instanceof ItemData) {
            return this.getText4ItemData((ItemData)element);
        }
        if (element instanceof Item) {
            StandardItem item = (StandardItem)element;
            if (!Misc.isNullOrEmpty((Collection)item.getProperties())) {
                String str = "";
                if (this.descriptor.isShowAllProperties() && Misc.isNullOrEmpty((Object[])this.descriptor.getItemPropertyDescriptors())) {
                    for (ItemProperty ip : item.getProperties()) {
                        str = String.valueOf(str) + ip.getName() + ": " + this.iplp.getText(ip) + "; ";
                    }
                } else {
                    ItemPropertyDescription<?>[] itemPropertyDescriptionArray = this.descriptor.getItemPropertyDescriptors();
                    int n = itemPropertyDescriptionArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ItemPropertyDescription<?> ipd = itemPropertyDescriptionArray[n2];
                        for (ItemProperty ip : item.getProperties()) {
                            if (!ip.getName().equals(ipd.getName())) continue;
                            str = String.valueOf(str) + ipd.getName() + ": " + this.iplp.getText(ip) + "; ";
                        }
                        ++n2;
                    }
                }
                return str;
            }
            return "- Empty -";
        }
        return super.getText(element);
    }

    public String getText4ItemData(ItemData element) {
        ItemData id = element;
        JRElementDataset ds = id.getDataset();
        return ds != null ? String.valueOf(this.getText(ds)) + " ; " + id.getItems().size() + " Items" : Messages.ItemLabelProvider_2;
    }

    public Image getImage(Object element) {
        if (this.descriptor != null) {
            return this.descriptor.getIcon(element);
        }
        return null;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (this.descriptor != null) {
            return this.descriptor.getIcon(element);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        StandardItem item;
        if (element instanceof ItemData) {
            return this.getColumnText4ItemData((ItemData)element, columnIndex);
        }
        if (element instanceof StandardItem && this.descriptor.getItemPropertyDescriptors().length > columnIndex && !Misc.isNullOrEmpty((Collection)(item = (StandardItem)element).getProperties())) {
            ItemPropertyDescription<?> showProperty = this.descriptor.getItemPropertyDescriptors()[columnIndex];
            for (ItemProperty ip : item.getProperties()) {
                if (!ip.getName().equals(showProperty.getName())) continue;
                return this.iplp.getText(ip);
            }
            return "NULL";
        }
        return "";
    }

    protected String getColumnText4ItemData(ItemData element, int columnIndex) {
        if (columnIndex == 0) {
            return String.valueOf(Messages.ItemLabelProvider_7) + " " + (columnIndex + 1);
        }
        return "";
    }

    public void update(ViewerCell cell) {
        super.update(cell);
    }

    public String getToolTipText(Object element) {
        if (element instanceof JRElementDataset) {
            JRElementDataset ed = (JRElementDataset)element;
            String str = ed.getDatasetRun() == null ? Messages.ItemLabelProvider_3 : String.valueOf(this.getText(ed.getDatasetRun())) + "\n";
            str = String.valueOf(str) + "\n";
            str = String.valueOf(str) + Messages.ItemLabelProvider_11 + ed.getDatasetResetType();
            if (ed.getDatasetResetType() == DatasetResetTypeEnum.GROUP && ed.getResetGroup() != null) {
                str = String.valueOf(str) + ed.getResetGroup().getName();
            }
            str = String.valueOf(str) + "\n";
            str = String.valueOf(str) + Messages.ItemLabelProvider_13 + ed.getIncrementTypeValue();
            if (ed.getIncrementTypeValue() == IncrementTypeEnum.GROUP && ed.getIncrementGroup() != null) {
                str = String.valueOf(str) + ed.getIncrementGroup().getName();
            }
            if (ed.getIncrementWhenExpression() != null) {
                str = String.valueOf(str) + "\n";
                str = String.valueOf(str) + Messages.ItemLabelProvider_15 + ed.getIncrementWhenExpression().getText();
            }
            return str;
        }
        if (element instanceof ItemData) {
            return this.getToolTipText4ItemData(element);
        }
        if (element instanceof Item) {
            StandardItem item = (StandardItem)element;
            if (!Misc.isNullOrEmpty((Collection)item.getProperties())) {
                String str = "";
                if (this.descriptor.isShowAllProperties() && Misc.isNullOrEmpty((Object[])this.descriptor.getItemPropertyDescriptors())) {
                    for (ItemProperty ip : item.getProperties()) {
                        str = String.valueOf(str) + ip.getName() + ": " + this.iplp.getText(ip) + "; ";
                    }
                } else {
                    ItemPropertyDescription<?>[] itemPropertyDescriptionArray = this.descriptor.getItemPropertyDescriptors();
                    int n = itemPropertyDescriptionArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ItemPropertyDescription<?> ipd = itemPropertyDescriptionArray[n2];
                        for (ItemProperty ip : item.getProperties()) {
                            if (!ip.getName().equals(ipd.getName())) continue;
                            str = String.valueOf(str) + ipd.getName() + ":" + this.iplp.getText(ip) + "\n";
                        }
                        ++n2;
                    }
                }
                return str;
            }
            return "";
        }
        return super.getToolTipText(element);
    }

    protected String getToolTipText4ItemData(Object element) {
        ItemData id = (ItemData)element;
        JRElementDataset ds = id.getDataset();
        return ds != null ? String.valueOf(this.getToolTipText(ds)) + "\n" + id.getItems().size() + " Items" : Messages.ItemLabelProvider_18;
    }

    public Point getToolTipShift(Object object) {
        return new Point(5, 5);
    }

    public int getToolTipDisplayDelayTime(Object object) {
        return 100;
    }

    public int getToolTipTimeDisplayed(Object object) {
        return 5000;
    }
}

