/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.propertiesviewer;

import com.jaspersoft.studio.property.propertiesviewer.IPropertiesViewerNode;
import com.jaspersoft.studio.property.propertiesviewer.PropertiesNodeChangeListener;
import com.jaspersoft.studio.property.propertiesviewer.PropertiesPatternFilter;
import com.jaspersoft.studio.property.propertiesviewer.PropertiesViewerContentProvider;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class TreePropertiesViewerPanel<T extends IPropertiesViewerNode>
extends Composite {
    public static final int SASH_WEIGHT_LEFT_PANEL = 25;
    public static final int SASH_WEIGHT_MAIN_AREA = 75;
    protected FormToolkit toolkit;
    private List<T> nodes;
    private List<PropertiesNodeChangeListener> nodeChangedListeners;
    protected IPropertiesViewerNode currentSelectedNode;
    protected Composite titleArea;
    protected Composite contentArea;
    private StackLayout contentAreaLayout;
    protected FilteredTree filteredTree;
    protected CLabel titleLabel;
    private SashForm panelSash;
    private ScrolledComposite scrollComposite;

    public TreePropertiesViewerPanel(Composite parent, int style, List<T> nodes) {
        super(parent, style);
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.nodes = nodes;
        this.nodeChangedListeners = new ArrayList<PropertiesNodeChangeListener>(1);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (TreePropertiesViewerPanel.this.nodeChangedListeners != null) {
                    Object[] listeners;
                    Object[] objectArray = listeners = TreePropertiesViewerPanel.this.nodeChangedListeners.toArray();
                    int n = listeners.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object l = objectArray[n2];
                        TreePropertiesViewerPanel.this.removePropertiesNodeChangedListener((PropertiesNodeChangeListener)l);
                        ++n2;
                    }
                    TreePropertiesViewerPanel.this.nodeChangedListeners.clear();
                    TreePropertiesViewerPanel.this.nodeChangedListeners = null;
                }
                if (TreePropertiesViewerPanel.this.toolkit != null) {
                    TreePropertiesViewerPanel.this.toolkit.dispose();
                    TreePropertiesViewerPanel.this.toolkit = null;
                }
            }
        });
        this.createPanelContent();
    }

    private void createPanelContent() {
        GridLayout gl_panel = new GridLayout(1, false);
        gl_panel.marginWidth = 0;
        gl_panel.marginHeight = 0;
        this.setLayout((Layout)gl_panel);
        this.panelSash = new SashForm((Composite)this, 256);
        GridData gdsash = new GridData(4, 4, true, true);
        this.panelSash.setLayoutData((Object)gdsash);
        this.panelSash.SASH_WIDTH = 1;
        Composite treeContainer = this.toolkit.createComposite((Composite)this.panelSash);
        treeContainer.setLayout((Layout)new GridLayout());
        this.filteredTree = this.createTreeViewer(treeContainer);
        this.filteredTree.getViewer().setInput(new Object());
        this.addListeners(this.filteredTree.getViewer());
        Composite panelContainer = new Composite((Composite)this.panelSash, 0);
        GridLayout gl_panelContainer = new GridLayout(2, false);
        gl_panelContainer.marginWidth = 0;
        gl_panelContainer.marginHeight = 0;
        gl_panelContainer.horizontalSpacing = 0;
        panelContainer.setLayout((Layout)gl_panelContainer);
        panelContainer.setBackground(this.getDisplay().getSystemColor(22));
        Label separator = this.toolkit.createSeparator(panelContainer, 512);
        GridData gd_Separator = new GridData(16384, 4, false, true, 1, 3);
        separator.setLayoutData((Object)gd_Separator);
        this.titleArea = this.createTitleArea(panelContainer);
        Label separator2 = new Label(panelContainer, 258);
        GridData gd_Separator2 = new GridData(4, 128, true, false, 1, 1);
        separator2.setLayoutData((Object)gd_Separator2);
        this.contentArea = this.createContentArea(panelContainer);
        this.contentAreaLayout = new StackLayout();
        this.contentArea.setLayout((Layout)this.contentAreaLayout);
        this.panelSash.setWeights(new int[]{25, 75});
    }

    public int[] safeGetPanelSashWeights() {
        if (this.panelSash != null && !this.panelSash.isDisposed()) {
            return this.panelSash.getWeights();
        }
        return new int[]{25, 75};
    }

    public void setPanelSashWeights(int[] weights) {
        if (this.panelSash != null && !this.panelSash.isDisposed()) {
            this.panelSash.setWeights(weights);
        }
    }

    protected void addListeners(final TreeViewer viewer) {
        viewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IPropertiesViewerNode selection = TreePropertiesViewerPanel.this.getSingleSelection(event.getSelection());
                if (selection instanceof IPropertiesViewerNode) {
                    TreePropertiesViewerPanel.this.showNodeContent(selection);
                    TreePropertiesViewerPanel.this.notifyPropertiesNodeChanged(selection);
                }
            }
        });
        ((Tree)viewer.getControl()).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent event) {
                IPropertiesViewerNode singleSelection;
                ISelection selection = viewer.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                boolean expanded = viewer.getExpandedState((Object)(singleSelection = TreePropertiesViewerPanel.this.getSingleSelection(selection)));
                viewer.setExpandedState((Object)singleSelection, !expanded);
            }
        });
    }

    protected Composite createTitleArea(Composite parent) {
        Composite titleArea = new Composite(parent, 0);
        GridData gd_TitleArea = new GridData(4, 4, true, false, 1, 1);
        titleArea.setLayoutData((Object)gd_TitleArea);
        FillLayout fl_TitleArea = new FillLayout(512);
        fl_TitleArea.marginHeight = 5;
        fl_TitleArea.marginWidth = 5;
        titleArea.setLayout((Layout)fl_TitleArea);
        this.titleLabel = new CLabel(titleArea, 0);
        this.titleLabel.setFont(JFaceResources.getBannerFont());
        return titleArea;
    }

    protected Composite createContentArea(Composite parent) {
        this.scrollComposite = new ScrolledComposite(parent, 768);
        GridData gd_ContentArea = new GridData(4, 4, true, true, 1, 1);
        this.scrollComposite.setLayoutData((Object)gd_ContentArea);
        Composite cmpContentArea = new Composite((Composite)this.scrollComposite, 0);
        this.scrollComposite.setContent((Control)cmpContentArea);
        this.scrollComposite.setExpandHorizontal(true);
        this.scrollComposite.setExpandVertical(true);
        return cmpContentArea;
    }

    protected FilteredTree createTreeViewer(Composite parent) {
        FilteredTree filteredTree = new FilteredTree(parent, 4, (PatternFilter)new PropertiesPatternFilter(), true);
        filteredTree.setBackground(Display.getDefault().getSystemColor(25));
        TreeViewer viewer = filteredTree.getViewer();
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)viewer);
        viewer.setLabelProvider((IBaseLabelProvider)new CellLabelProvider(){

            public void update(ViewerCell cell) {
                cell.setText(((IPropertiesViewerNode)cell.getElement()).getName());
            }

            public String getToolTipText(Object element) {
                return ((IPropertiesViewerNode)element).getDescription();
            }
        });
        viewer.setContentProvider(new PropertiesViewerContentProvider<T>(this.nodes));
        return filteredTree;
    }

    private boolean showNodeContent(IPropertiesViewerNode node) {
        if (node == null) {
            return false;
        }
        if (node.getControl() == null) {
            node.createControl(this.contentArea);
        }
        if (node.getControl() == null) {
            return false;
        }
        this.currentSelectedNode = node;
        Control[] children = this.contentArea.getChildren();
        Control currentControl = node.getControl();
        int i = 0;
        while (i < children.length) {
            if (children[i] != currentControl) {
                children[i].setEnabled(false);
                children[i].setVisible(false);
            }
            ++i;
        }
        currentControl.setEnabled(true);
        currentControl.setVisible(true);
        this.contentAreaLayout.topControl = currentControl;
        this.contentArea.layout();
        this.scrollComposite.setMinSize(currentControl.computeSize(-1, -1));
        this.updateTitleArea();
        node.update();
        return true;
    }

    protected void updateTitleArea() {
        this.titleLabel.setText(this.currentSelectedNode.getName());
        this.titleArea.layout();
    }

    private IPropertiesViewerNode getSingleSelection(ISelection selection) {
        IStructuredSelection structured;
        if (!selection.isEmpty() && (structured = (IStructuredSelection)selection).getFirstElement() instanceof IPropertiesViewerNode) {
            return (IPropertiesViewerNode)structured.getFirstElement();
        }
        return null;
    }

    protected void checkSubclass() {
    }

    public IPropertiesViewerNode getCurrentSelectedNode() {
        return this.currentSelectedNode;
    }

    public void selectPropertiesNode(IPropertiesViewerNode node) {
        this.filteredTree.getViewer().setSelection((ISelection)new StructuredSelection((Object)node));
    }

    public void addPropertiesNodeChangedListener(PropertiesNodeChangeListener l) {
        this.nodeChangedListeners.add(l);
    }

    public void removePropertiesNodeChangedListener(PropertiesNodeChangeListener l) {
        this.nodeChangedListeners.remove(l);
    }

    private void notifyPropertiesNodeChanged(IPropertiesViewerNode node) {
        for (PropertiesNodeChangeListener l : this.nodeChangedListeners) {
            l.nodeChanged(node);
        }
    }
}

