/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.section.graphic;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.editor.layout.ChangeLayoutCommand;
import com.jaspersoft.studio.editor.layout.ILayout;
import com.jaspersoft.studio.editor.layout.LayoutCommand;
import com.jaspersoft.studio.editor.layout.LayoutManager;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.IContainerLayout;
import com.jaspersoft.studio.model.IGraphicElementContainer;
import com.jaspersoft.studio.model.IGroupElement;
import com.jaspersoft.studio.property.section.graphic.LayoutSection;
import com.jaspersoft.studio.property.section.widgets.ASPropertyWidget;
import java.util.ArrayList;
import net.sf.jasperreports.eclipse.ui.JSSTableCombo;
import net.sf.jasperreports.eclipse.ui.ValueChangedEvent;
import net.sf.jasperreports.eclipse.ui.ValueChangedListener;
import net.sf.jasperreports.engine.JRCommonElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.base.JRBaseElement;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class SPLayoutCombo
extends ASPropertyWidget<IPropertyDescriptor> {
    private APropertyNode pnode;
    private int index = 0;
    private ILayout[] layouts;
    private boolean refreshing = false;
    private JSSTableCombo combo;
    private String longestName = null;

    public SPLayoutCombo(Composite parent, LayoutSection section, IPropertyDescriptor pDescriptor) {
        super(parent, section, pDescriptor);
    }

    protected void handlePropertyChange() {
        if (this.refreshing) {
            return;
        }
        int ind = this.combo.getSelectionIndex();
        if (ind == this.index && this.index != 1) {
            return;
        }
        ILayout selectedLayout = (ILayout)this.combo.getTable().getItem(ind).getData();
        CommandStack cs = this.section.getEditDomain().getCommandStack();
        ChangeLayoutCommand changeLayoutCommand = new ChangeLayoutCommand(this.pnode, selectedLayout);
        JSSCompoundCommand container = new JSSCompoundCommand(this.pnode);
        container.add(changeLayoutCommand);
        Object destValue = this.pnode.getValue();
        if (this.pnode instanceof IGroupElement) {
            destValue = ((IGroupElement)((Object)this.pnode)).getJRElementGroup();
        }
        if (destValue instanceof JRElementGroup) {
            Dimension d = new Dimension(0, 0);
            if (this.pnode instanceof IGraphicElementContainer) {
                d = LayoutManager.getPaddedSize((IGraphicElementContainer)((Object)this.pnode));
            }
            if (destValue instanceof JRCommonElement) {
                d = LayoutManager.getPaddedSize((JRCommonElement)destValue);
            }
            if (destValue instanceof JRDesignBand) {
                JasperDesign jDesign = this.pnode.getJasperDesign();
                int w = jDesign.getPageWidth() - jDesign.getLeftMargin() - jDesign.getRightMargin();
                d.setSize(new Dimension(w, ((JRDesignBand)destValue).getHeight()));
            }
            container.add(new LayoutCommand(this.pnode.getJasperDesign(), (JRElementGroup)destValue, selectedLayout, d));
        }
        cs.execute((Command)container);
    }

    @Override
    public void setData(APropertyNode pnode, Object b) {
        this.refreshing = true;
        try {
            this.pnode = pnode;
            this.index = -1;
            Object obj = pnode.getValue();
            this.combo.setEnabled(true);
            String layoutName = null;
            if (b instanceof JRPropertiesMap) {
                layoutName = this.getLayoutName(null, (JRPropertiesMap)b);
            } else if (obj != null && obj instanceof JRPropertiesHolder) {
                layoutName = this.getLayoutName((JRPropertiesHolder)obj, null);
            } else if (obj instanceof JRBaseElement) {
                JasperDesign jDesign = pnode.getJasperDesign();
                layoutName = this.getLayoutName((JRPropertiesHolder)jDesign, ((JRBaseElement)obj).getUUID().toString());
            }
            if (layoutName != null) {
                this.index = this.getIndex(layoutName, (Control)this.combo.getTable());
                if (this.index == -1) {
                    ILayout resolvedLayout = this.resoveLayout(layoutName);
                    if (resolvedLayout != null) {
                        this.combo.setText(resolvedLayout.getName());
                        return;
                    }
                    this.index = 0;
                    this.combo.select(this.index);
                } else {
                    this.combo.select(this.index);
                }
            } else {
                IContainerLayout layoutContainer;
                ILayout defaultLayout;
                if (pnode != null && pnode instanceof IContainerLayout && (defaultLayout = (layoutContainer = (IContainerLayout)((Object)pnode)).getDefaultLayout()) != null) {
                    this.index = this.getIndex(defaultLayout.getClass().getName(), (Control)this.combo.getTable());
                }
                if (this.index == -1) {
                    this.index = 0;
                }
                this.combo.select(this.index);
            }
        }
        finally {
            this.refreshing = false;
        }
    }

    private String getLayoutName(JRPropertiesHolder pholder, String uuid) {
        return this.getLayoutName(uuid, pholder.getPropertiesMap());
    }

    private String getLayoutName(String uuid, JRPropertiesMap pmap) {
        String key = "com.jaspersoft.studio.layout";
        if (uuid != null) {
            key = String.valueOf(key) + "." + uuid;
        }
        String str = pmap.getProperty(key);
        return str;
    }

    private int getIndex(String layoutName, Control combo) {
        if (layoutName != null) {
            ILayout[] visibleLayouts = (ILayout[])combo.getData();
            int i = 0;
            while (i < visibleLayouts.length) {
                if (visibleLayouts[i].getClass().getName().equals(layoutName)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    private ILayout resoveLayout(String layoutName) {
        if (layoutName != null) {
            int i = 0;
            while (i < this.layouts.length) {
                if (this.layouts[i].getClass().getName().equals(layoutName)) {
                    return this.layouts[i];
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    protected void createComponent(Composite parent) {
        this.layouts = LayoutManager.getAllLayouts();
        Composite container = this.section.getWidgetFactory().createComposite(parent);
        container.setLayout((Layout)new GridLayout(1, false));
        this.combo = new JSSTableCombo(container, 8){

            protected void setTableData(Table table) {
                SPLayoutCombo.this.refreshTableItems(table);
            }

            protected void dropDown(boolean drop) {
                if (drop) {
                    this.refreshItems();
                }
                super.dropDown(drop);
            }

            protected String getLongestText() {
                return SPLayoutCombo.this.computeLongestName();
            }
        };
        this.combo.addModifyListener(new ValueChangedListener(){

            public void valueChanged(ValueChangedEvent e) {
                SPLayoutCombo.this.handlePropertyChange();
            }
        });
        this.combo.setToolTipText(this.pDescriptor.getDescription());
    }

    @Override
    public Control getControl() {
        return this.combo;
    }

    private void refreshTableItems(Table table) {
        table.clearAll();
        ArrayList<ILayout> visibleLayouts = new ArrayList<ILayout>();
        int i = 0;
        while (i < this.layouts.length) {
            if (this.layouts[i].isSelectable(this.section.getElement())) {
                visibleLayouts.add(this.layouts[i]);
            }
            ++i;
        }
        for (ILayout item : visibleLayouts) {
            TableItem tableItem = new TableItem(table, 0);
            tableItem.setText(0, item.getName());
            tableItem.setData((Object)item);
        }
        table.setData((Object)visibleLayouts.toArray(new ILayout[visibleLayouts.size()]));
    }

    private String computeLongestName() {
        if (this.longestName == null) {
            this.longestName = "";
            ILayout[] iLayoutArray = this.layouts;
            int n = this.layouts.length;
            int n2 = 0;
            while (n2 < n) {
                ILayout item = iLayoutArray[n2];
                String currentText = item.getName();
                if (this.longestName.length() < currentText.length()) {
                    this.longestName = currentText;
                }
                ++n2;
            }
        }
        return this.longestName;
    }
}

