/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.section.graphic.borders;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.java2d.J2DLightweightSystem;
import com.jaspersoft.studio.help.HelpSystem;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.MLineBox;
import com.jaspersoft.studio.model.MLinePen;
import com.jaspersoft.studio.properties.internal.IHighlightPropertyWidget;
import com.jaspersoft.studio.properties.view.TabbedPropertySheetPage;
import com.jaspersoft.studio.property.section.AbstractSection;
import com.jaspersoft.studio.property.section.graphic.ASHighlightControl;
import com.jaspersoft.studio.property.section.graphic.borders.BorderSelectionEvent;
import com.jaspersoft.studio.property.section.graphic.borders.BorderSelectionListener;
import com.jaspersoft.studio.property.section.graphic.borders.LineBoxDrawer;
import com.jaspersoft.studio.property.section.graphic.borders.LineBoxRectangle;
import com.jaspersoft.studio.property.section.widgets.BackgroundHighlight;
import com.jaspersoft.studio.property.section.widgets.BorderHightLight;
import com.jaspersoft.studio.property.section.widgets.SPLineStyleEnum;
import com.jaspersoft.studio.swt.widgets.ColorStyledText;
import com.jaspersoft.studio.swt.widgets.NullableSpinner;
import com.jaspersoft.studio.utils.AlfaRGB;
import com.jaspersoft.studio.utils.Colors;
import java.awt.Color;
import java.util.ArrayList;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRStyleContainer;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.base.JRBoxPen;
import net.sf.jasperreports.engine.type.LineStyleEnum;
import net.sf.jasperreports.engine.util.StyleResolver;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class BordersSection
extends AbstractSection {
    private ToolItem allBorder;
    private ToolItem noneBorder;
    private ToolItem upDownBorder;
    private ToolItem leftRightBorder;
    private LineBoxDrawer bd;
    private NullableSpinner lineWidth;
    private CLabel lineWidthLabel;
    private SPLineStyleEnum lineStyle;
    private CLabel lineStyleLabel;
    private Button checkBoxPadding;
    private NullableSpinner paddingLeft;
    private CLabel leftPaddingLabel;
    private NullableSpinner paddingRight;
    private CLabel rightPaddingLabel;
    private NullableSpinner paddingBottom;
    private CLabel bottomPaddingLabel;
    private NullableSpinner paddingTop;
    private CLabel topPaddingLabel;
    private RectangleFigure borderPreview;
    private Canvas square;
    private Group rightPanel;
    private ColorStyledText lineColor;
    private CLabel lineColorLabel;
    private static final String PREFIX = "net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1";
    private static final String PADDING_GENERAL = "net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1".concat("#box_padding");
    private static final String PADDING_TOP = "net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1".concat("#box_topPadding");
    private static final String PADDING_BOTTOM = "net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1".concat("#box_bottomPadding");
    private static final String PADDING_LEFT = "net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1".concat("#box_leftPadding");
    private static final String PADDING_RIGHT = "net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1".concat("#box_rightPadding");
    private static final String LINE_COLOR = "net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1".concat("#pen_lineColor");
    private static final String LINE_WIDTH = "net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1".concat("#pen_lineWidth");
    private static final String LINE_STYLE = "net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1".concat("#pen_lineStyle");
    private static final String BOX = "net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1".concat("#box");

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        Composite mainLayout = new Composite(parent, 0);
        mainLayout.setLayout((Layout)new GridLayout(1, true));
        mainLayout.setLayoutData((Object)new GridData(4, 128, true, false));
        this.createPaddingPanel(mainLayout);
        this.rightPanel = new Group(mainLayout, 0);
        this.rightPanel.setText(Messages.common_borders);
        this.rightPanel.setLayoutData((Object)new GridData(4, 128, true, false));
        this.rightPanel.setLayout((Layout)new GridLayout(2, false));
        this.createBorderPreview((Composite)this.rightPanel);
        this.createStyle((Composite)this.rightPanel, "padding");
        Composite toolBarLayout = new Composite((Composite)this.rightPanel, 0);
        toolBarLayout.setLayout((Layout)new GridLayout(1, false));
        GridData toolBardGridData = new GridData(1, 1, true, false);
        toolBardGridData.horizontalSpan = 2;
        toolBardGridData.widthHint = 200;
        toolBardGridData.horizontalIndent = 5;
        toolBarLayout.setLayoutData((Object)toolBardGridData);
        Label textLabel = new Label(toolBarLayout, 0);
        textLabel.setText(Messages.BordersSection_Default_Label);
        ToolBar toolBar = new ToolBar(toolBarLayout, 0x800040);
        this.createButtons(toolBar);
        this.allBorder.setSelection(false);
        this.noneBorder.setSelection(false);
        this.leftRightBorder.setSelection(false);
        this.upDownBorder.setSelection(false);
    }

    private void createBorderPreview(Composite composite) {
        this.square = new Canvas(composite, 0x100800);
        this.square.setBackground(ColorConstants.white);
        HelpSystem.setHelp((Control)this.square, BOX);
        GridData gd = new GridData(1108);
        gd.widthHint = 120;
        gd.heightHint = 120;
        this.square.setLayoutData((Object)gd);
        J2DLightweightSystem lws = new J2DLightweightSystem();
        lws.setControl(this.square);
        this.bd = new LineBoxDrawer((JasperReportsContext)this.jasperReportsContext, this.square);
        this.bd.addBorderSelectionListener(new BorderSelectionListener(){

            @Override
            public void borderSelected(BorderSelectionEvent event) {
                BordersSection.this.updateRightPanel();
            }
        });
        this.borderPreview = new LineBoxRectangle(this.bd, this);
        this.square.setToolTipText(Messages.BordersSection_preview_ToolTip);
        lws.setContents((IFigure)this.borderPreview);
    }

    private void checkBoxValueChange() {
        if (this.checkBoxPadding.getSelection()) {
            this.paddingRight.setEnabled(false);
            this.rightPaddingLabel.setEnabled(false);
            this.paddingTop.setEnabled(false);
            this.topPaddingLabel.setEnabled(false);
            this.paddingBottom.setEnabled(false);
            this.bottomPaddingLabel.setEnabled(false);
            this.paddingRight.setDefaultValue(null);
            this.paddingTop.setDefaultValue(null);
            this.paddingBottom.setDefaultValue(null);
            this.paddingRight.setValue(null);
            this.paddingTop.setValue(null);
            this.paddingBottom.setValue(null);
        } else {
            this.paddingRight.setDefaultValue(0);
            this.paddingTop.setDefaultValue(0);
            this.paddingBottom.setDefaultValue(0);
            this.paddingRight.setEnabled(true);
            this.rightPaddingLabel.setEnabled(true);
            this.paddingTop.setEnabled(true);
            this.topPaddingLabel.setEnabled(true);
            this.paddingBottom.setEnabled(true);
            this.bottomPaddingLabel.setEnabled(true);
        }
    }

    private void uniformAfterCheck() {
        JSSCompoundCommand cc = new JSSCompoundCommand("Change padding", null);
        if (this.checkBoxPadding.getSelection()) {
            for (APropertyNode m : this.getElements()) {
                cc.setReferenceNodeIfNull(m);
                Command c = null;
                MLineBox lb = (MLineBox)m.getPropertyValue("LineBox");
                c = this.getChangePropertyCommand("padding", new Integer(this.paddingLeft.getValueAsInteger()), lb);
                if (c != null) {
                    cc.add(c);
                }
                if ((c = this.getChangePropertyCommand("bottomPadding", null, lb)) != null) {
                    cc.add(c);
                }
                if ((c = this.getChangePropertyCommand("topPadding", null, lb)) != null) {
                    cc.add(c);
                }
                if ((c = this.getChangePropertyCommand("leftPadding", null, lb)) != null) {
                    cc.add(c);
                }
                if ((c = this.getChangePropertyCommand("rightPadding", null, lb)) == null) continue;
                cc.add(c);
            }
        } else {
            for (APropertyNode m : this.getElements()) {
                cc.setReferenceNodeIfNull(m);
                Command c = null;
                MLineBox lb = (MLineBox)m.getPropertyValue("LineBox");
                Integer oldValue = this.getPaddingValue(lb.getPropertyValue("padding"));
                c = this.getChangePropertyCommand("padding", null, lb);
                if (c != null) {
                    cc.add(c);
                }
                if ((c = this.getChangePropertyCommand("bottomPadding", oldValue, lb)) != null) {
                    cc.add(c);
                }
                if ((c = this.getChangePropertyCommand("topPadding", oldValue, lb)) != null) {
                    cc.add(c);
                }
                if ((c = this.getChangePropertyCommand("rightPadding", oldValue, lb)) != null) {
                    cc.add(c);
                }
                if ((c = this.getChangePropertyCommand("leftPadding", oldValue, lb)) == null) continue;
                cc.add(c);
            }
        }
        CommandStack cs = this.getEditDomain().getCommandStack();
        cs.execute((Command)cc);
        this.refresh();
        this.paddingLeft.forceFocus();
    }

    private void createPaddingPanel(Composite parent) {
        Group composite = new Group(parent, 0);
        composite.setText(Messages.BordersSection_Padding_Box_Title);
        GridLayout layout = new GridLayout(4, false);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 128, true, false));
        GridData gd = new GridData();
        gd.horizontalSpan = 4;
        this.checkBoxPadding = this.getWidgetFactory().createButton((Composite)composite, Messages.BordersSection_Same_Padding_Value_Check, 32);
        this.checkBoxPadding.setLayoutData((Object)gd);
        HelpSystem.setHelp((Control)this.checkBoxPadding, PADDING_GENERAL);
        this.checkBoxPadding.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BordersSection.this.checkBoxValueChange();
                BordersSection.this.uniformAfterCheck();
            }
        });
        this.leftPaddingLabel = this.getWidgetFactory().createCLabel((Composite)composite, Messages.BordersSection_Left_Label, 131072);
        this.paddingLeft = new NullableSpinner((Composite)composite, 2048);
        this.paddingLeft.setDefaultValue(0);
        this.paddingLeft.setValues(0, 0, 999);
        this.paddingLeft.setToolTipText(Messages.BordersSection_padding_tool_tip);
        HelpSystem.setHelp((Control)this.paddingLeft, PADDING_LEFT);
        this.paddingLeft.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BordersSection.this.changePropertyPadding("leftPadding", BordersSection.this.paddingLeft.getValueAsInteger());
                BordersSection.this.setControlTooltipInherithed(BordersSection.this.paddingLeft.getValueAsInteger() == null, BordersSection.this.paddingLeft, BordersSection.this.leftPaddingLabel, Messages.BordersSection_padding_tool_tip);
            }
        });
        this.createPaddingContextualMenu((Control)this.paddingLeft, "leftPadding");
        this.rightPaddingLabel = this.getWidgetFactory().createCLabel((Composite)composite, Messages.common_right, 131072);
        this.paddingRight = new NullableSpinner((Composite)composite, 2048);
        this.paddingRight.setDefaultValue(0);
        this.paddingRight.setValues(0, 0, 999);
        this.paddingRight.setToolTipText(Messages.BordersSection_padding_tool_tip);
        HelpSystem.setHelp((Control)this.paddingRight, PADDING_RIGHT);
        this.paddingRight.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BordersSection.this.changePropertyPadding("rightPadding", BordersSection.this.paddingRight.getValueAsInteger());
                BordersSection.this.setControlTooltipInherithed(BordersSection.this.paddingRight.getValueAsInteger() == null, BordersSection.this.paddingRight, BordersSection.this.rightPaddingLabel, Messages.BordersSection_padding_tool_tip);
            }
        });
        this.createPaddingContextualMenu((Control)this.paddingRight, "rightPadding");
        this.topPaddingLabel = this.getWidgetFactory().createCLabel((Composite)composite, Messages.BordersSection_Top_Label, 131072);
        this.paddingTop = new NullableSpinner((Composite)composite, 2048);
        this.paddingTop.setDefaultValue(0);
        this.paddingTop.setValues(0, 0, 999);
        this.paddingTop.setToolTipText(Messages.BordersSection_padding_tool_tip);
        HelpSystem.setHelp((Control)this.paddingTop, PADDING_TOP);
        this.paddingTop.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BordersSection.this.changePropertyPadding("topPadding", BordersSection.this.paddingTop.getValueAsInteger());
                BordersSection.this.setControlTooltipInherithed(BordersSection.this.paddingTop.getValueAsInteger() == null, BordersSection.this.paddingTop, BordersSection.this.topPaddingLabel, Messages.BordersSection_padding_tool_tip);
            }
        });
        this.createPaddingContextualMenu((Control)this.paddingTop, "topPadding");
        this.bottomPaddingLabel = this.getWidgetFactory().createCLabel((Composite)composite, Messages.common_bottom, 131072);
        this.paddingBottom = new NullableSpinner((Composite)composite, 2048);
        this.paddingBottom.setDefaultValue(0);
        this.paddingBottom.setValues(0, 0, 999);
        this.paddingBottom.setToolTipText(Messages.BordersSection_padding_tool_tip);
        HelpSystem.setHelp((Control)this.paddingBottom, PADDING_BOTTOM);
        this.paddingBottom.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BordersSection.this.changePropertyPadding("bottomPadding", BordersSection.this.paddingBottom.getValueAsInteger());
                BordersSection.this.setControlTooltipInherithed(BordersSection.this.paddingBottom.getValueAsInteger() == null, BordersSection.this.paddingBottom, BordersSection.this.bottomPaddingLabel, Messages.BordersSection_padding_tool_tip);
            }
        });
        this.createPaddingContextualMenu((Control)this.paddingBottom, "bottomPadding");
    }

    private Control createStyle(Composite parent, String property) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        this.lineColorLabel = this.getWidgetFactory().createCLabel(composite, String.valueOf(Messages.common_pen_color) + ":", 131072);
        this.lineColor = new ColorStyledText(composite);
        this.lineColor.setColor(AlfaRGB.getFullyOpaque(new RGB(0, 0, 0)));
        this.lineColor.setHelp(LINE_COLOR);
        this.lineColor.addListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BordersSection.this.changeProperty("lineColor", (Object)BordersSection.this.lineColor.getColor());
                BordersSection.this.refresh();
            }
        });
        this.createLineContextualMenu((Control)this.lineColor, "lineColor");
        this.lineStyleLabel = this.getWidgetFactory().createCLabel(composite, String.valueOf(Messages.common_pen_style) + ":");
        this.createLineStyle(property, composite);
        this.lineWidthLabel = this.getWidgetFactory().createCLabel(composite, String.valueOf(Messages.common_pen_width) + ":", 131072);
        this.lineWidth = new NullableSpinner(composite, 2048, 2, 6);
        this.lineWidth.setDefaultValue(Float.valueOf(0.0f));
        this.lineWidth.setIncrement(0.25f);
        GridData lineWidthData = new GridData();
        lineWidthData.widthHint = 50;
        this.lineWidth.setLayoutData(lineWidthData);
        this.lineWidth.setValues(null, 0, 999);
        this.lineWidth.setToolTipText(Messages.BordersSection_width_tool_tip);
        HelpSystem.setHelp((Control)this.lineWidth, LINE_WIDTH);
        this.lineWidth.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BordersSection.this.changeProperty("lineWidth", (Object)BordersSection.this.lineWidth.getValueAsFloat());
                boolean isInheirted = BordersSection.this.lineWidth.getValueAsFloat() == null;
                BordersSection.this.setControlTooltipInherithed(isInheirted, BordersSection.this.lineWidth, BordersSection.this.lineWidthLabel, Messages.BordersSection_width_tool_tip);
            }
        });
        this.createLineContextualMenu((Control)this.lineWidth, "lineWidth");
        return composite;
    }

    private void createLineStyle(String prop, Composite composite) {
        this.lineStyle = new SPLineStyleEnum(composite, this, prop){

            @Override
            public void propertyChange(AbstractSection section, String property, Object value) {
                ((BordersSection)section).changeProperty(property, value);
                this.setInhterited(false);
                Float beforeSelectionWidth = BordersSection.this.lineWidth.getValueAsFloat();
                if (beforeSelectionWidth == null || beforeSelectionWidth.equals(Float.valueOf(0.0f))) {
                    BordersSection.this.changeProperty("lineWidth", (Object)Float.valueOf(1.0f));
                    BordersSection.this.refresh();
                }
            }
        };
        this.lineStyle.setData(1);
        this.lineStyle.setHelp(LINE_STYLE);
    }

    private void createButtons(ToolBar toolBar) {
        this.noneBorder = new ToolItem(toolBar, 8);
        this.noneBorder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AlfaRGB beforeSelectionColor = BordersSection.this.lineColor.getColor();
                Float selection = BordersSection.this.lineWidth.getValueAsFloat();
                Object beforeSelectionStyle = BordersSection.this.lineStyle.getSelectedValue();
                BordersSection.this.bd.setBorderSelected(LineBoxDrawer.Location.LEFT);
                BordersSection.this.bd.setBorderSelected(LineBoxDrawer.Location.RIGHT);
                BordersSection.this.bd.setBorderSelected(LineBoxDrawer.Location.TOP);
                BordersSection.this.bd.setBorderSelected(LineBoxDrawer.Location.BOTTOM);
                AlfaRGB color = AlfaRGB.getFullyOpaque(new RGB(0, 0, 0));
                Float newValue = new Float(0.0f);
                BordersSection.this.changeProperty("lineStyle", (Object)1);
                BordersSection.this.changeProperty("lineColor", (Object)color);
                BordersSection.this.changeProperty("lineWidth", (Object)newValue);
                BordersSection.this.bd.unselectAll();
                BordersSection.this.lineStyle.setData((LineStyleEnum)beforeSelectionStyle);
                BordersSection.this.lineWidth.setValue(selection);
                BordersSection.this.lineColor.setColor(beforeSelectionColor);
            }
        });
        this.noneBorder.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/resources/border.png"));
        this.noneBorder.setToolTipText(Messages.BordersSection_No_Borders);
        this.allBorder = new ToolItem(toolBar, 8);
        this.allBorder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Float beforeSelectionWidth = BordersSection.this.lineWidth.getValueAsFloat();
                if (beforeSelectionWidth == null || beforeSelectionWidth.equals(Float.valueOf(0.0f))) {
                    beforeSelectionWidth = Float.valueOf(1.0f);
                }
                BordersSection.this.bd.setBorderSelected(LineBoxDrawer.Location.LEFT);
                BordersSection.this.bd.setBorderSelected(LineBoxDrawer.Location.RIGHT);
                BordersSection.this.bd.setBorderSelected(LineBoxDrawer.Location.TOP);
                BordersSection.this.bd.setBorderSelected(LineBoxDrawer.Location.BOTTOM);
                AlfaRGB color = BordersSection.this.lineColor.getColor();
                Object style = BordersSection.this.lineStyle.getSelectedValue();
                BordersSection.this.changeProperty("lineStyle", style);
                BordersSection.this.changeProperty("lineColor", (Object)color);
                BordersSection.this.changeProperty("lineWidth", (Object)beforeSelectionWidth);
                BordersSection.this.lineWidth.setValue(beforeSelectionWidth);
                BordersSection.this.bd.unselectAll();
            }
        });
        this.allBorder.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/resources/border-outside.png"));
        this.allBorder.setToolTipText(Messages.BordersSection_all_borders_tool_tip);
        this.leftRightBorder = new ToolItem(toolBar, 8);
        this.leftRightBorder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AlfaRGB beforeSelectionColor = BordersSection.this.lineColor.getColor();
                Float beforeSelectionWidth = BordersSection.this.lineWidth.getValueAsFloat();
                Object beforeSelectionStyle = BordersSection.this.lineStyle.getSelectedValue();
                if (beforeSelectionWidth == null || beforeSelectionWidth.equals(Float.valueOf(0.0f))) {
                    beforeSelectionWidth = Float.valueOf(1.0f);
                }
                BordersSection.this.bd.setBorderSelected(LineBoxDrawer.Location.LEFT, false);
                BordersSection.this.bd.setBorderSelected(LineBoxDrawer.Location.RIGHT, false);
                BordersSection.this.bd.setBorderSelected(LineBoxDrawer.Location.TOP);
                BordersSection.this.bd.setBorderSelected(LineBoxDrawer.Location.BOTTOM);
                Float newValue = new Float(0.0f);
                BordersSection.this.changeProperty("lineStyle", (Object)1);
                BordersSection.this.changeProperty("lineColor", (Object)new AlfaRGB(new RGB(0, 0, 0), 255));
                BordersSection.this.changeProperty("lineWidth", (Object)newValue);
                BordersSection.this.bd.setBorderSelected(LineBoxDrawer.Location.LEFT);
                BordersSection.this.bd.setBorderSelected(LineBoxDrawer.Location.RIGHT);
                BordersSection.this.bd.setBorderSelected(LineBoxDrawer.Location.TOP, false);
                BordersSection.this.bd.setBorderSelected(LineBoxDrawer.Location.BOTTOM, false);
                BordersSection.this.changeProperty("lineStyle", beforeSelectionStyle);
                BordersSection.this.changeProperty("lineColor", (Object)beforeSelectionColor);
                BordersSection.this.changeProperty("lineWidth", (Object)beforeSelectionWidth);
                BordersSection.this.bd.unselectAll();
                BordersSection.this.lineColor.setColor(beforeSelectionColor);
                BordersSection.this.lineWidth.setValue(beforeSelectionWidth);
                BordersSection.this.lineStyle.setData((LineStyleEnum)beforeSelectionStyle);
            }
        });
        this.leftRightBorder.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/resources/border-right-left.png"));
        this.leftRightBorder.setToolTipText(Messages.BordersSection_Left_Right_Borders);
        this.upDownBorder = new ToolItem(toolBar, 8);
        this.upDownBorder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AlfaRGB beforeSelectionColor = BordersSection.this.lineColor.getColor();
                Object beforeSelectionStyle = BordersSection.this.lineStyle.getSelectedValue();
                Float beforeSelectionWidth = BordersSection.this.lineWidth.getValueAsFloat();
                if (beforeSelectionWidth == null || beforeSelectionWidth.equals(Float.valueOf(0.0f))) {
                    beforeSelectionWidth = Float.valueOf(1.0f);
                }
                BordersSection.this.bd.setBorderSelected(LineBoxDrawer.Location.LEFT);
                BordersSection.this.bd.setBorderSelected(LineBoxDrawer.Location.RIGHT);
                BordersSection.this.bd.setBorderSelected(LineBoxDrawer.Location.TOP, false);
                BordersSection.this.bd.setBorderSelected(LineBoxDrawer.Location.BOTTOM, false);
                Float newValue = new Float(0.0f);
                BordersSection.this.changeProperty("lineStyle", (Object)1);
                BordersSection.this.changeProperty("lineColor", (Object)new AlfaRGB(new RGB(0, 0, 0), 255));
                BordersSection.this.changeProperty("lineWidth", (Object)newValue);
                BordersSection.this.bd.setBorderSelected(LineBoxDrawer.Location.LEFT, false);
                BordersSection.this.bd.setBorderSelected(LineBoxDrawer.Location.RIGHT, false);
                BordersSection.this.bd.setBorderSelected(LineBoxDrawer.Location.TOP);
                BordersSection.this.bd.setBorderSelected(LineBoxDrawer.Location.BOTTOM);
                BordersSection.this.changeProperty("lineStyle", beforeSelectionStyle);
                BordersSection.this.changeProperty("lineColor", (Object)beforeSelectionColor);
                BordersSection.this.changeProperty("lineWidth", (Object)beforeSelectionWidth);
                BordersSection.this.bd.unselectAll();
                BordersSection.this.lineColor.setColor(beforeSelectionColor);
                BordersSection.this.lineWidth.setValue(beforeSelectionWidth);
                BordersSection.this.lineStyle.setData((LineStyleEnum)beforeSelectionStyle);
            }
        });
        this.upDownBorder.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/resources/border-top-bottom.png"));
        this.upDownBorder.setToolTipText(Messages.BordersSection_Top_Bottom_Borders);
    }

    public void changePropertyPadding(String property, Object newValue) {
        if (!this.isRefreshing()) {
            JSSCompoundCommand cc = new JSSCompoundCommand("Change padding", null);
            for (APropertyNode m : this.getElements()) {
                cc.setReferenceNodeIfNull(m);
                Command c = null;
                MLineBox lb = (MLineBox)m.getPropertyValue("LineBox");
                if (this.checkBoxPadding.getSelection()) {
                    c = this.getChangePropertyCommand("padding", newValue, lb);
                } else {
                    c = this.getChangePropertyCommand("padding", null, lb);
                    if (c != null) {
                        cc.add(c);
                    }
                    c = this.getChangePropertyCommand(property, newValue, lb);
                }
                if (c == null) continue;
                cc.add(c);
            }
            CommandStack cs = this.getEditDomain().getCommandStack();
            cs.execute((Command)cc);
        }
    }

    public void changeProperty(String property, Object newValue) {
        if (!this.isRefreshing()) {
            JSSCompoundCommand cc = new JSSCompoundCommand("Change border", null);
            for (APropertyNode m : this.getElements()) {
                MLinePen lp;
                cc.setReferenceNodeIfNull(m);
                Command c = null;
                MLineBox lb = (MLineBox)m.getPropertyValue("LineBox");
                boolean areAllUnselected = this.bd.areAllUnslected();
                if (areAllUnselected) {
                    lp = (MLinePen)lb.getPropertyValue("LinePen");
                    c = this.getChangePropertyCommand(property, newValue, lp);
                    if (c == null) continue;
                    cc.add(c);
                    continue;
                }
                if (this.bd.isBottomSelected() && (c = this.getChangePropertyCommand(property, newValue, lp = (MLinePen)lb.getPropertyValue("LinePen_BOTTOM"))) != null) {
                    cc.add(c);
                }
                if (this.bd.isTopSelected() && (c = this.getChangePropertyCommand(property, newValue, lp = (MLinePen)lb.getPropertyValue("LinePen_TOP"))) != null) {
                    cc.add(c);
                }
                if (this.bd.isLeftSelected() && (c = this.getChangePropertyCommand(property, newValue, lp = (MLinePen)lb.getPropertyValue("LinePen_LEFT"))) != null) {
                    cc.add(c);
                }
                if (!this.bd.isRightSelected() || (c = this.getChangePropertyCommand(property, newValue, lp = (MLinePen)lb.getPropertyValue("LinePen_RIGHT"))) == null) continue;
                cc.add(c);
            }
            CommandStack cs = this.getEditDomain().getCommandStack();
            cs.execute((Command)cc);
            this.bd.refresh();
        }
    }

    protected void getLinePenClearCommand(CompoundCommand cc, String linePenProperty, MLineBox lb) {
        MLinePen lp = (MLinePen)lb.getPropertyValue(linePenProperty);
        Command c = this.getChangePropertyCommand("lineWidth", null, lp);
        if (c != null) {
            cc.add(c);
        }
        if ((c = this.getChangePropertyCommand("lineStyle", null, lp)) != null) {
            cc.add(c);
        }
        if ((c = this.getChangePropertyCommand("lineColor", null, lp)) != null) {
            cc.add(c);
        }
    }

    private String locationToLine(LineBoxDrawer.Location loc) {
        if (loc == LineBoxDrawer.Location.TOP) {
            return "LinePen_TOP";
        }
        if (loc == LineBoxDrawer.Location.BOTTOM) {
            return "LinePen_BOTTOM";
        }
        if (loc == LineBoxDrawer.Location.RIGHT) {
            return "LinePen_RIGHT";
        }
        return "LinePen_LEFT";
    }

    private void updateRightPanel() {
        APropertyNode m = this.getElement();
        if (m != null) {
            MLineBox lb = (MLineBox)m.getPropertyActualValue("LineBox");
            if (this.bd.getLastSelected() != null && this.bd.getLastSelected().isSelected()) {
                this.refreshLinePen(lb, this.locationToLine(this.bd.getLastSelected().getLocation()));
            } else if (this.bd.isTopSelected()) {
                this.refreshLinePen(lb, "LinePen_TOP");
            } else if (this.bd.isBottomSelected()) {
                this.refreshLinePen(lb, "LinePen_BOTTOM");
            } else if (this.bd.isLeftSelected()) {
                this.refreshLinePen(lb, "LinePen_LEFT");
            } else if (this.bd.isRightSelected()) {
                this.refreshLinePen(lb, "LinePen_RIGHT");
            } else {
                this.refreshLinePen(lb, "LinePen");
            }
        }
    }

    private JRBoxPen getIntesectionValues(MLineBox lb) {
        if (lb != null && lb.getValue() != null) {
            JRLineBox jrLineBox = (JRLineBox)lb.getValue();
            ArrayList<JRBoxPen> edgePen = new ArrayList<JRBoxPen>();
            edgePen.add(jrLineBox.getLeftPen());
            edgePen.add(jrLineBox.getRightPen());
            edgePen.add(jrLineBox.getTopPen());
            edgePen.add(jrLineBox.getBottomPen());
            Color intersectionLineColor = null;
            LineStyleEnum intersectionLineStyle = null;
            Float intersectionLineWidth = null;
            JRBoxPen resultPen = null;
            for (JRBoxPen pen : edgePen) {
                if (pen == null) continue;
                resultPen = pen;
                if (intersectionLineColor != null && !intersectionLineColor.equals(pen.getLineColor())) {
                    resultPen = null;
                    break;
                }
                if (intersectionLineStyle != null && !intersectionLineStyle.equals((Object)pen.getLineStyleValue())) {
                    resultPen = null;
                    break;
                }
                if (intersectionLineWidth != null && !intersectionLineWidth.equals(pen.getLineWidth())) {
                    resultPen = null;
                    break;
                }
                intersectionLineColor = pen.getLineColor();
                intersectionLineStyle = pen.getLineStyleValue();
                intersectionLineWidth = pen.getLineWidth();
            }
            if (resultPen == null && jrLineBox.getPen() != null) {
                return jrLineBox.getPen();
            }
            return resultPen;
        }
        return null;
    }

    @Override
    public void refresh() {
        this.setRefreshing(true);
        APropertyNode m = this.getElement();
        if (m != null) {
            MLineBox lb = (MLineBox)m.getPropertyActualValue("LineBox");
            this.bd.unselectAll();
            this.updateRightPanel();
            if (!m.isEditable()) {
                this.enableControls(false);
            } else {
                this.enableControls(true);
                this.refreshPadding(lb);
            }
        }
        if (this.square != null) {
            this.square.redraw();
        }
        this.setRefreshing(false);
    }

    private void enableControls(boolean enable) {
        this.lineColor.setEnabled(enable);
        this.lineStyle.getControl().setEnabled(enable);
        this.lineWidth.setEnabled(enable);
        this.paddingRight.setEnabled(enable);
        this.paddingLeft.setEnabled(enable);
        this.paddingTop.setEnabled(enable);
        this.paddingBottom.setEnabled(enable);
        this.checkBoxPadding.setEnabled(enable);
        this.allBorder.setEnabled(enable);
        this.noneBorder.setEnabled(enable);
        this.leftRightBorder.setEnabled(enable);
        this.upDownBorder.setEnabled(enable);
    }

    private Integer getPaddingValue(Object padding) {
        return padding != null ? (Integer)padding : 0;
    }

    protected void createPaddingContextualMenu(final Control control, final String propertyID) {
        if (control != null && !control.isDisposed() && control.getMenu() == null) {
            Menu controlMenu = new Menu(control);
            MenuItem nullItem = new MenuItem(controlMenu, 0);
            nullItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BordersSection.this.changePropertyPadding(propertyID, null);
                    BordersSection.this.refresh();
                    control.setFocus();
                }
            });
            nullItem.setText(Messages.ASPropertyWidget_1);
            control.setMenu(controlMenu);
        }
    }

    protected void createLineContextualMenu(final Control control, final String propertyID) {
        if (control != null && !control.isDisposed() && control.getMenu() == null) {
            Menu controlMenu = new Menu(control);
            MenuItem nullItem = new MenuItem(controlMenu, 0);
            nullItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BordersSection.this.changeProperty(propertyID, null);
                    BordersSection.this.refresh();
                    control.setFocus();
                }
            });
            nullItem.setText(Messages.ASPropertyWidget_1);
            control.setMenu(controlMenu);
        }
    }

    public void refreshPadding(MLineBox lb) {
        if (lb != null) {
            this.paddingBottom.setValue(null);
            this.paddingLeft.setValue(null);
            this.paddingRight.setValue(null);
            this.paddingTop.setValue(null);
            Object propertyPadding = lb.getPropertyValue("padding");
            if (propertyPadding != null) {
                this.checkBoxPadding.setSelection(true);
                Integer value = (Integer)propertyPadding;
                this.paddingLeft.setValue(value);
            } else {
                this.checkBoxPadding.setSelection(false);
                this.paddingTop.setValue(this.getPaddingValue(lb.getPropertyActualValue("topPadding")));
                this.paddingBottom.setValue(this.getPaddingValue(lb.getPropertyActualValue("bottomPadding")));
                this.paddingLeft.setValue(this.getPaddingValue(lb.getPropertyActualValue("leftPadding")));
                this.paddingRight.setValue(this.getPaddingValue(lb.getPropertyActualValue("rightPadding")));
                this.setControlTooltipInherithed(lb.getPropertyValue("topPadding") == null, this.paddingTop, this.topPaddingLabel, Messages.BordersSection_padding_tool_tip);
                this.setControlTooltipInherithed(lb.getPropertyValue("bottomPadding") == null, this.paddingBottom, this.bottomPaddingLabel, Messages.BordersSection_padding_tool_tip);
                this.setControlTooltipInherithed(lb.getPropertyValue("leftPadding") == null, this.paddingLeft, this.leftPaddingLabel, Messages.BordersSection_padding_tool_tip);
                this.setControlTooltipInherithed(lb.getPropertyValue("rightPadding") == null, this.paddingRight, this.rightPaddingLabel, Messages.BordersSection_padding_tool_tip);
            }
            this.checkBoxValueChange();
        }
    }

    protected void setControlTooltipInherithed(boolean isInherithed, NullableSpinner paddingControl, CLabel paddingLabel, String tooltipText) {
        paddingControl.setInherited(isInherithed);
        if (isInherithed) {
            paddingControl.setToolTipText(String.valueOf(Messages.common_inherited_attribute) + tooltipText);
            paddingLabel.setToolTipText(String.valueOf(Messages.common_inherited_attribute) + tooltipText);
            paddingLabel.setForeground(UIUtils.INHERITED_COLOR);
        } else {
            paddingControl.setToolTipText(tooltipText);
            paddingLabel.setToolTipText(tooltipText);
            paddingLabel.setForeground(ColorConstants.black);
        }
    }

    private LineStyleEnum getLineStyleValue(JRBoxPen boxPen, StyleResolver sr) {
        LineStyleEnum lineStyle;
        LineStyleEnum ownLineStyle = boxPen.getOwnLineStyleValue();
        if (ownLineStyle != null) {
            return ownLineStyle;
        }
        LineStyleEnum penLineStyle = boxPen.getBox().getPen().getOwnLineStyleValue();
        if (penLineStyle != null) {
            return penLineStyle;
        }
        JRStyle baseStyle = sr.getBaseStyle((JRStyleContainer)boxPen.getPenContainer());
        if (baseStyle != null && (lineStyle = boxPen.getPen(baseStyle.getLineBox()).getLineStyleValue()) != null) {
            return lineStyle;
        }
        return null;
    }

    private Float getLineWidthValue(JRBoxPen boxPen, StyleResolver sr) {
        Float lineWidth;
        Float ownLineWidth = boxPen.getOwnLineWidth();
        if (ownLineWidth != null) {
            return ownLineWidth;
        }
        Float penLineWidth = boxPen.getBox().getPen().getOwnLineWidth();
        if (penLineWidth != null) {
            return penLineWidth;
        }
        JRStyle baseStyle = sr.getBaseStyle((JRStyleContainer)boxPen.getPenContainer());
        if (baseStyle != null && (lineWidth = boxPen.getPen(baseStyle.getLineBox()).getLineWidth()) != null) {
            return lineWidth;
        }
        return null;
    }

    private Color getLineColorValue(JRBoxPen boxPen, StyleResolver sr) {
        Color lineColor;
        Color ownLineColor = boxPen.getOwnLineColor();
        if (ownLineColor != null) {
            return ownLineColor;
        }
        Color penLineColor = boxPen.getBox().getPen().getOwnLineColor();
        if (penLineColor != null) {
            return penLineColor;
        }
        JRStyle baseStyle = sr.getBaseStyle((JRStyleContainer)boxPen.getPenContainer());
        if (baseStyle != null && (lineColor = boxPen.getPen(baseStyle.getLineBox()).getLineColor()) != null) {
            return lineColor;
        }
        return null;
    }

    public void refreshLinePen(MLineBox lb, String property) {
        if (lb != null) {
            boolean isInherited;
            StyleResolver sr = new StyleResolver((JasperReportsContext)lb.getJasperConfiguration());
            MLinePen lp = (MLinePen)lb.getPropertyActualValue(property);
            JRBoxPen pen = (JRBoxPen)lp.getValue();
            LineStyleEnum currentStyle = this.getLineStyleValue(pen, sr);
            Color currentColor = this.getLineColorValue(pen, sr);
            Float currentWidth = this.getLineWidthValue(pen, sr);
            LineStyleEnum ownStyle = pen.getOwnLineStyleValue();
            Color ownColor = pen.getOwnLineColor();
            Float ownWidth = pen.getOwnLineWidth();
            AlfaRGB backcolor = null;
            if (currentStyle == null) {
                currentStyle = LineStyleEnum.values()[(Integer)lp.getPropertyActualValue("lineStyle") - 1];
            }
            if (currentWidth == null) {
                currentWidth = (Float)lp.getPropertyActualValue("lineWidth");
            }
            backcolor = currentColor == null ? (AlfaRGB)lp.getPropertyActualValue("lineColor") : new AlfaRGB(new RGB(currentColor.getRed(), currentColor.getGreen(), currentColor.getBlue()), currentColor.getAlpha());
            if (this.lineWidth != null && !this.lineWidth.isDisposed()) {
                this.lineWidth.setValue(ownWidth);
                this.lineWidth.setDefaultValue(currentWidth);
                this.setControlTooltipInherithed(ownWidth == null, this.lineWidth, this.lineWidthLabel, Messages.BordersSection_width_tool_tip);
            }
            if (this.lineStyle != null && !this.isDisposed()) {
                isInherited = ownStyle == null;
                this.lineStyle.setData(currentStyle, isInherited);
                if (isInherited) {
                    this.lineStyle.setToolTipText(String.valueOf(Messages.common_inherited_attribute) + "Style");
                    this.lineStyleLabel.setToolTipText(String.valueOf(Messages.common_inherited_attribute) + "Style");
                    this.lineStyleLabel.setForeground(UIUtils.INHERITED_COLOR);
                } else {
                    this.lineStyle.setToolTipText("Style");
                    this.lineStyleLabel.setToolTipText("Style");
                    this.lineStyleLabel.setForeground(ColorConstants.black);
                }
            }
            if (this.lineColor != null) {
                if (backcolor != null) {
                    this.lineColor.setColor(backcolor);
                } else {
                    this.lineColor.setColor(AlfaRGB.getFullyOpaque(ColorConstants.black.getRGB()));
                }
                isInherited = ownColor == null;
                this.lineColor.setInhterited(isInherited);
                if (isInherited) {
                    this.lineColor.setToolTipText(String.valueOf(Messages.common_inherited_attribute) + "Color");
                    this.lineColorLabel.setToolTipText(String.valueOf(Messages.common_inherited_attribute) + "Color");
                    this.lineColorLabel.setForeground(UIUtils.INHERITED_COLOR);
                } else {
                    this.lineColor.setToolTipText("Color");
                    this.lineColorLabel.setToolTipText("Color");
                    this.lineColorLabel.setForeground(ColorConstants.black);
                }
            }
        }
    }

    protected Float getLineWidth(LineBoxDrawer.Location location) {
        MLineBox lb = (MLineBox)this.getElement().getPropertyValue("LineBox");
        if (location == LineBoxDrawer.Location.BOTTOM) {
            MLinePen lp = (MLinePen)lb.getPropertyValue("LinePen_BOTTOM");
            return (Float)lp.getPropertyActualValue("lineWidth");
        }
        if (location == LineBoxDrawer.Location.TOP) {
            MLinePen lp = (MLinePen)lb.getPropertyValue("LinePen_TOP");
            return (Float)lp.getPropertyActualValue("lineWidth");
        }
        if (location == LineBoxDrawer.Location.LEFT) {
            MLinePen lp = (MLinePen)lb.getPropertyValue("LinePen_LEFT");
            return (Float)lp.getPropertyActualValue("lineWidth");
        }
        if (location == LineBoxDrawer.Location.RIGHT) {
            MLinePen lp = (MLinePen)lb.getPropertyValue("LinePen_RIGHT");
            return (Float)lp.getPropertyActualValue("lineWidth");
        }
        return null;
    }

    public void refreshLinePen(JRBoxPen pen) {
        if (pen != null) {
            Float width = pen.getLineWidth();
            if (this.lineWidth != null && !this.lineWidth.isDisposed()) {
                if (width == null) {
                    this.lineWidth.setValues(null, 0, 999);
                } else {
                    this.lineWidth.setValue(width);
                }
                this.lineWidth.setInherited(pen.getOwnLineWidth() == null);
            }
            if (this.lineStyle != null && !this.isDisposed()) {
                if (pen.getLineStyleValue() == null) {
                    this.lineStyle.setData(1);
                } else {
                    int ls = this.lineStyle.getIndexByType(pen.getLineStyleValue());
                    this.lineStyle.setData(ls);
                }
            }
            if (this.lineColor != null && !this.lineColor.isDisposed()) {
                if (pen.getLineColor() == null) {
                    this.lineColor.setColor(AlfaRGB.getFullyOpaque(new RGB(0, 0, 0)));
                } else {
                    AlfaRGB backcolor = Colors.getSWTRGB4AWTGBColor(pen.getLineColor());
                    this.lineColor.setColor(backcolor);
                }
                this.lineColor.setInhterited(pen.getOwnLineColor() == null);
            }
        }
    }

    @Override
    protected void initializeProvidedProperties() {
        super.initializeProvidedProperties();
        this.addProvidedProperties("padding", Messages.BordersSection_Padding_Box_Title);
        this.addProvidedProperties("leftPadding", Messages.BordersSection_Left_Label);
        this.addProvidedProperties("rightPadding", Messages.common_right);
        this.addProvidedProperties("topPadding", Messages.BordersSection_Top_Label);
        this.addProvidedProperties("bottomPadding", Messages.common_bottom);
        this.addProvidedProperties("lineColor", Messages.common_pen_color);
        this.addProvidedProperties("lineWidth", Messages.common_pen_width);
        this.addProvidedProperties("lineStyle", Messages.common_pen_style);
        this.addProvidedProperties("BordersDefinitionGroup", Messages.common_borders);
    }

    @Override
    public IHighlightPropertyWidget getWidgetForProperty(Object propertyId) {
        if (propertyId.equals("padding")) {
            return new ASHighlightControl((Control)this.checkBoxPadding.getParent(), new BorderHightLight((Control)this.checkBoxPadding.getParent(), Composite.class));
        }
        if (propertyId.equals("leftPadding")) {
            return new ASHighlightControl((Control)this.paddingLeft, new BackgroundHighlight((Control)this.paddingLeft));
        }
        if (propertyId.equals("rightPadding")) {
            return new ASHighlightControl((Control)this.paddingRight, new BackgroundHighlight((Control)this.paddingRight));
        }
        if (propertyId.equals("topPadding")) {
            return new ASHighlightControl((Control)this.paddingTop, new BackgroundHighlight((Control)this.paddingTop));
        }
        if (propertyId.equals("bottomPadding")) {
            return new ASHighlightControl((Control)this.paddingBottom, new BackgroundHighlight((Control)this.paddingBottom));
        }
        if (propertyId.equals("lineColor")) {
            return new ASHighlightControl((Control)this.lineColor, new BackgroundHighlight((Control)this.lineColor));
        }
        if (propertyId.equals("lineWidth")) {
            return new ASHighlightControl((Control)this.lineWidth, new BackgroundHighlight((Control)this.lineWidth));
        }
        if (propertyId.equals("lineStyle")) {
            return new ASHighlightControl(this.lineStyle.getControl(), new BackgroundHighlight(this.lineStyle.getControl()));
        }
        if (propertyId.equals("BordersDefinitionGroup")) {
            return new ASHighlightControl((Control)this.rightPanel, new BorderHightLight((Control)this.rightPanel, Composite.class));
        }
        return null;
    }
}

