/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.section.graphic.borders;

import com.jaspersoft.studio.property.section.graphic.borders.BorderSelectionEvent;
import com.jaspersoft.studio.property.section.graphic.borders.BorderSelectionListener;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.draw.BoxDrawer;
import net.sf.jasperreports.engine.type.LineStyleEnum;
import net.sf.jasperreports.engine.util.JRPenUtil;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Canvas;

public class LineBoxDrawer
extends BoxDrawer {
    private static final int selectionWidth = 9;
    private List<Border> clickablesElements = new ArrayList<Border>();
    private Canvas paintingSquare;
    private Border lastSelected = null;
    private static Stroke dashedStroke = null;
    private static Color guideColor = null;
    private List<BorderSelectionListener> listeners = new ArrayList<BorderSelectionListener>();

    public Border getLastSelected() {
        return this.lastSelected;
    }

    public LineBoxDrawer(JasperReportsContext jasperReportsContext, Canvas square) {
        super(jasperReportsContext);
        if (dashedStroke == null) {
            dashedStroke = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{2.0f, 2.0f}, 0.0f);
            guideColor = new Color(192, 192, 192);
        }
        this.paintingSquare = square;
        this.paintingSquare.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                for (Border border : LineBoxDrawer.this.clickablesElements) {
                    if (!border.isIntersecting(e.x, e.y)) continue;
                    border.changeSelected();
                    LineBoxDrawer.this.paintingSquare.redraw();
                    LineBoxDrawer.this.fireSelectionListeners(border);
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
    }

    public void refresh() {
        this.paintingSquare.redraw();
    }

    public boolean isLeftSelected() {
        Border border = this.getBorder(Location.LEFT);
        return border != null ? border.isSelected() : false;
    }

    public boolean isRightSelected() {
        Border border = this.getBorder(Location.RIGHT);
        return border != null ? border.isSelected() : false;
    }

    public boolean isTopSelected() {
        Border border = this.getBorder(Location.TOP);
        return border != null ? border.isSelected() : false;
    }

    public boolean isBottomSelected() {
        Border border = this.getBorder(Location.BOTTOM);
        return border != null ? border.isSelected() : false;
    }

    public boolean areAllUnslected() {
        return !this.isBottomSelected() && !this.isTopSelected() && !this.isLeftSelected() && !this.isRightSelected();
    }

    public void drawBox(Graphics2D graphics2d, JRLineBox box, JRPrintElement element) {
        this.drawGuideLines(graphics2d, (JRPen)box.getTopPen(), (JRPen)box.getLeftPen(), (JRPen)box.getBottomPen(), (JRPen)box.getRightPen(), element, 0, 0);
        this.drawLeftPen(graphics2d, (JRPen)box.getTopPen(), (JRPen)box.getLeftPen(), (JRPen)box.getBottomPen(), element, 0, 0);
        this.drawTopPen(graphics2d, (JRPen)box.getTopPen(), (JRPen)box.getLeftPen(), (JRPen)box.getRightPen(), element, 0, 0);
        this.drawBottomPen(graphics2d, (JRPen)box.getLeftPen(), (JRPen)box.getBottomPen(), (JRPen)box.getRightPen(), element, 0, 0);
        this.drawRightPen(graphics2d, (JRPen)box.getTopPen(), (JRPen)box.getBottomPen(), (JRPen)box.getRightPen(), element, 0, 0);
        this.drawSelections(graphics2d);
    }

    private void drawSelection(Location loc, Graphics2D grx, boolean isOffset1, boolean isOffset2) {
        Border border = this.getBorder(loc);
        if (border != null && this.getBorder(loc).isSelected()) {
            int offset1 = 0;
            int offset2 = 0;
            Rectangle rect = border.getRect();
            if (isOffset1) {
                offset1 = Math.round(4.0f);
            }
            offset2 = offset1;
            if (isOffset2) {
                offset2 += Math.round(4.0f);
            }
            if (loc == Location.LEFT || loc == Location.RIGHT) {
                grx.drawRect(rect.x, rect.y + offset1, rect.width, rect.height - offset2);
            } else {
                grx.drawRect(rect.x + offset1, rect.y, rect.width - offset2, rect.height);
            }
        }
    }

    private void drawSelections(Graphics2D grx) {
        Stroke oldStroke = grx.getStroke();
        Color oldColor = grx.getColor();
        grx.setColor(Color.black);
        grx.setXORMode(Color.white);
        grx.setStroke(dashedStroke);
        boolean isLeftSelected = this.isLeftSelected();
        boolean isTopSelected = this.isTopSelected();
        boolean isRightSelected = this.isRightSelected();
        boolean isBottomSelected = this.isBottomSelected();
        this.drawSelection(Location.LEFT, grx, isTopSelected, isBottomSelected);
        this.drawSelection(Location.RIGHT, grx, isTopSelected, isBottomSelected);
        this.drawSelection(Location.TOP, grx, isLeftSelected, isRightSelected);
        this.drawSelection(Location.BOTTOM, grx, isLeftSelected, isRightSelected);
        grx.setStroke(oldStroke);
        grx.setColor(oldColor);
        grx.setXORMode(oldColor);
    }

    public void setBorderSelected(Location borderPosition) {
        this.setBorderSelected(borderPosition, true);
    }

    public void setBorderSelected(Location borderPosition, boolean selectedValue) {
        Border selected = this.getBorder(borderPosition);
        if (selected != null) {
            selected.setSelected(selectedValue);
        } else {
            selected = new Border(new Rectangle(), borderPosition);
            selected.setSelected(selectedValue);
            this.clickablesElements.add(selected);
        }
        this.lastSelected = selected;
    }

    public void unselectAll() {
        for (Border bord : this.clickablesElements) {
            bord.setSelected(false);
        }
    }

    private Border getBorder(Location borderPosition) {
        Iterator<Border> it = this.clickablesElements.iterator();
        Border result = null;
        while (it.hasNext() && result == null) {
            Border actBorder = it.next();
            if (!actBorder.getLocation().equals((Object)borderPosition)) continue;
            result = actBorder;
        }
        return result;
    }

    private Border updateBorder(Location borderPosition, Rectangle newSize) {
        Iterator<Border> it = this.clickablesElements.iterator();
        boolean notFound = true;
        Border actualElement = null;
        while (it.hasNext() && notFound) {
            actualElement = it.next();
            if (!actualElement.getLocation().equals((Object)borderPosition)) continue;
            notFound = false;
            actualElement.setRectangle(newSize);
        }
        if (notFound) {
            actualElement = new Border(newSize, borderPosition);
            this.clickablesElements.add(actualElement);
        }
        return actualElement;
    }

    protected void drawGuideLines(Graphics2D grx, JRPen topPen, JRPen leftPen, JRPen bottomPen, JRPen rightPen, JRPrintElement element, int offsetX, int offsetY) {
        Stroke oldStroke = grx.getStroke();
        Color oldColor = grx.getColor();
        grx.setStroke(new BasicStroke(1.0f));
        grx.setColor(guideColor);
        int topOffset = 0;
        int width = element.getWidth();
        int height = element.getHeight();
        int translationLeftUpperX = element.getX() + offsetX;
        int translationLeftUpperY = element.getY() + offsetY - topOffset;
        int translationRightUpperX = element.getX() + offsetX + width;
        int translationRightUpperY = element.getY() + offsetY - topOffset;
        int translationLeftBottomY = element.getY() + offsetY + height;
        int voidOffset = 2;
        grx.drawLine(0, translationLeftUpperY, translationLeftUpperX - voidOffset, translationLeftUpperY);
        grx.drawLine(translationLeftUpperX, 0, translationLeftUpperX, translationRightUpperY - voidOffset);
        grx.drawLine(translationRightUpperX + voidOffset, translationRightUpperY, this.paintingSquare.getBounds().width, translationRightUpperY);
        grx.drawLine(translationRightUpperX, 0, translationRightUpperX, translationRightUpperY - voidOffset);
        grx.drawLine(0, translationLeftBottomY, translationLeftUpperX - voidOffset, translationLeftBottomY);
        grx.drawLine(translationLeftUpperX, translationLeftBottomY + voidOffset, translationLeftUpperX, this.paintingSquare.getBounds().height);
        grx.drawLine(translationRightUpperX + voidOffset, translationLeftBottomY, this.paintingSquare.getBounds().width, translationLeftBottomY);
        grx.drawLine(translationRightUpperX, translationLeftBottomY + voidOffset, translationRightUpperX, this.paintingSquare.getBounds().height);
        grx.setStroke(oldStroke);
        grx.setColor(oldColor);
        Rectangle leftRect = new Rectangle(translationLeftUpperX - 4, translationLeftUpperY, 9, translationLeftBottomY - translationLeftUpperY);
        this.updateBorder(Location.LEFT, leftRect);
        Rectangle rightRect = new Rectangle(translationRightUpperX - 4, translationRightUpperY, 9, translationLeftBottomY - translationLeftUpperY);
        this.updateBorder(Location.RIGHT, rightRect);
        Rectangle topRect = new Rectangle(translationLeftUpperX, translationLeftUpperY - 4, translationRightUpperX - translationLeftUpperX, 9);
        this.updateBorder(Location.TOP, topRect);
        Rectangle bottomRect = new Rectangle(translationLeftUpperX, translationLeftBottomY - 4, translationRightUpperX - translationLeftUpperX, 9);
        this.updateBorder(Location.BOTTOM, bottomRect);
    }

    protected void drawLeftPen(Graphics2D grx, JRPen topPen, JRPen leftPen, JRPen bottomPen, JRPrintElement element, int offsetX, int offsetY) {
        LineStyleEnum lineStyle;
        Stroke leftStroke = JRPenUtil.getStroke((JRPen)leftPen, (int)0);
        int height = element.getHeight();
        float topOffset = topPen.getLineWidth().floatValue() / 2.0f;
        float bottomOffset = bottomPen.getLineWidth().floatValue();
        float leftPenWidth = leftPen.getLineWidth().floatValue();
        if (leftStroke != null && height > 0) {
            lineStyle = leftPen.getLineStyleValue();
            grx.setStroke(leftStroke);
            grx.setColor(leftPen.getLineColor());
        } else {
            grx.setStroke(new BasicStroke(2.0f));
            grx.setColor(Color.LIGHT_GRAY);
            grx.setStroke(dashedStroke);
            lineStyle = LineStyleEnum.DASHED;
        }
        AffineTransform oldTx = grx.getTransform();
        if (lineStyle == LineStyleEnum.DOUBLE) {
            float translationX = (float)(element.getX() + offsetX) - leftPenWidth / 3.0f;
            float translationY = (float)(element.getY() + offsetY) - topOffset;
            grx.translate(translationX, translationY);
            float scaleX = 1.0f;
            float scaleY = ((float)height + (topOffset + bottomOffset)) / (float)height;
            grx.scale(scaleX, scaleY);
            grx.drawLine(0, 0, 0, height);
            grx.setTransform(oldTx);
            grx.translate((float)(element.getX() + offsetX) + leftPenWidth / 3.0f, (float)(element.getY() + offsetY) + topOffset / 3.0f);
            if ((float)height > (topOffset + bottomOffset) / 3.0f) {
                grx.scale(1.0, ((float)height - (topOffset + bottomOffset) / 3.0f) / (float)height);
            }
            grx.drawLine(0, 0, 0, height);
            grx.setTransform(oldTx);
        } else {
            float translationX = element.getX() + offsetX;
            float translationY = (float)(element.getY() + offsetY) - topOffset;
            grx.translate(translationX, translationY);
            float scaleX = 1.0f;
            float scaleY = ((float)height + topOffset + bottomOffset) / (float)height;
            grx.scale(scaleX, scaleY);
            grx.drawLine(0, 0, 0, height);
            grx.setTransform(oldTx);
        }
    }

    protected void drawRightPen(Graphics2D grx, JRPen topPen, JRPen bottomPen, JRPen rightPen, JRPrintElement element, int offsetX, int offsetY) {
        LineStyleEnum lineStyle;
        Stroke rightStroke = JRPenUtil.getStroke((JRPen)rightPen, (int)0);
        int height = element.getHeight();
        int width = element.getWidth();
        float topOffset = topPen.getLineWidth().floatValue() / 2.0f;
        float bottomOffset = bottomPen.getLineWidth().floatValue() / 2.0f;
        float rightPenWidth = rightPen.getLineWidth().floatValue();
        if (rightStroke != null && height > 0) {
            lineStyle = rightPen.getLineStyleValue();
            grx.setStroke(rightStroke);
            grx.setColor(rightPen.getLineColor());
        } else {
            grx.setStroke(new BasicStroke(2.0f));
            grx.setColor(Color.LIGHT_GRAY);
            grx.setStroke(dashedStroke);
            lineStyle = LineStyleEnum.DASHED;
        }
        AffineTransform oldTx = grx.getTransform();
        if (lineStyle == LineStyleEnum.DOUBLE) {
            float translationX = (float)(element.getX() + offsetX + width) + rightPenWidth / 3.0f;
            float translationY = (float)(element.getY() + offsetY) - topOffset;
            grx.translate(translationX, translationY);
            float scaleX = 1.0f;
            float scaleY = ((float)height + topOffset + bottomOffset) / (float)height;
            grx.scale(scaleX, scaleY);
            grx.drawLine(0, 0, 0, height);
            grx.setTransform(oldTx);
            grx.translate((float)(element.getX() + offsetX + width) - rightPenWidth / 3.0f, (float)(element.getY() + offsetY) + topOffset / 3.0f);
            if ((float)height > (topOffset + bottomOffset) / 3.0f) {
                grx.scale(1.0, ((float)height - (topOffset + bottomOffset) / 3.0f) / (float)height);
            }
            grx.drawLine(0, 0, 0, height);
            grx.setTransform(oldTx);
        } else {
            float translationX = element.getX() + offsetX + width;
            float translationY = (float)(element.getY() + offsetY) - topOffset;
            grx.translate(translationX, translationY);
            float scaleX = 1.0f;
            float scaleY = ((float)height + topOffset + bottomOffset) / (float)height;
            grx.scale(scaleX, scaleY);
            grx.drawLine(0, 0, 0, height);
            grx.setTransform(oldTx);
        }
    }

    protected void drawTopPen(Graphics2D grx, JRPen topPen, JRPen leftPen, JRPen rightPen, JRPrintElement element, int offsetX, int offsetY) {
        LineStyleEnum lineStyle;
        Stroke topStroke = JRPenUtil.getStroke((JRPen)topPen, (int)0);
        int width = element.getWidth();
        float leftOffset = leftPen.getLineWidth().floatValue() / 2.0f;
        float rightOffset = rightPen.getLineWidth().floatValue() / 2.0f;
        float topPenWidth = topPen.getLineWidth().floatValue();
        if (topStroke != null && width > 0) {
            lineStyle = topPen.getLineStyleValue();
            grx.setStroke(topStroke);
            grx.setColor(topPen.getLineColor());
        } else {
            grx.setStroke(new BasicStroke(2.0f));
            grx.setColor(Color.LIGHT_GRAY);
            grx.setStroke(dashedStroke);
            lineStyle = LineStyleEnum.DASHED;
        }
        AffineTransform oldTx = grx.getTransform();
        if (lineStyle == LineStyleEnum.DOUBLE) {
            float translationX = (float)(element.getX() + offsetX) - leftOffset;
            float translationY = (float)(element.getY() + offsetY) - topPenWidth / 3.0f;
            grx.translate(translationX, translationY);
            float scaleX = ((float)width + leftOffset + rightOffset) / (float)width;
            float scaleY = 1.0f;
            grx.scale(scaleX, scaleY);
            grx.drawLine(0, 0, width, 0);
            grx.setTransform(oldTx);
            grx.translate((float)(element.getX() + offsetX) + leftOffset / 3.0f, (float)(element.getY() + offsetY) + topPenWidth / 3.0f);
            if ((float)width > (leftOffset + rightOffset) / 3.0f) {
                grx.scale(((float)width - (leftOffset + rightOffset) / 3.0f) / (float)width, 1.0);
            }
            grx.drawLine(0, 0, width, 0);
            grx.setTransform(oldTx);
        } else {
            float translationX = (float)(element.getX() + offsetX) - leftOffset;
            float translationY = element.getY() + offsetY;
            grx.translate(translationX, translationY);
            float scaleX = ((float)width + leftOffset + rightOffset) / (float)width;
            float scaleY = 1.0f;
            grx.scale(scaleX, scaleY);
            grx.drawLine(0, 0, width, 0);
            grx.setTransform(oldTx);
        }
    }

    protected void drawBottomPen(Graphics2D grx, JRPen leftPen, JRPen bottomPen, JRPen rightPen, JRPrintElement element, int offsetX, int offsetY) {
        LineStyleEnum lineStyle;
        Stroke bottomStroke = JRPenUtil.getStroke((JRPen)bottomPen, (int)0);
        int width = element.getWidth();
        int height = element.getHeight();
        float leftOffset = leftPen.getLineWidth().floatValue() / 2.0f;
        float rightOffset = rightPen.getLineWidth().floatValue() / 2.0f;
        float bottomPenWidth = bottomPen.getLineWidth().floatValue();
        if (bottomStroke != null && width > 0) {
            lineStyle = bottomPen.getLineStyleValue();
            grx.setStroke(bottomStroke);
            grx.setColor(bottomPen.getLineColor());
        } else {
            grx.setStroke(new BasicStroke(2.0f));
            grx.setColor(Color.LIGHT_GRAY);
            grx.setStroke(dashedStroke);
            lineStyle = LineStyleEnum.DASHED;
        }
        AffineTransform oldTx = grx.getTransform();
        if (lineStyle == LineStyleEnum.DOUBLE) {
            float translationX = (float)(element.getX() + offsetX) - leftOffset;
            float translationY = (float)(element.getY() + offsetY + height) + bottomPenWidth / 3.0f;
            grx.translate(translationX, translationY);
            float scaleX = ((float)width + leftOffset + rightOffset) / (float)width;
            float scaleY = 1.0f;
            grx.scale(scaleX, scaleY);
            grx.drawLine(0, 0, width, 0);
            grx.setTransform(oldTx);
            grx.translate((float)(element.getX() + offsetX) + leftOffset / 3.0f, (float)(element.getY() + offsetY + height) - bottomPenWidth / 3.0f);
            if ((float)width > (leftOffset + rightOffset) / 3.0f) {
                grx.scale(((float)width - (leftOffset + rightOffset) / 3.0f) / (float)width, 1.0);
            }
            grx.drawLine(0, 0, width, 0);
            grx.setTransform(oldTx);
        } else {
            float translationX = (float)(element.getX() + offsetX) - leftOffset;
            float translationY = element.getY() + offsetY + height;
            grx.translate(translationX, translationY);
            float scaleX = ((float)width + leftOffset + rightOffset) / (float)width;
            float scaleY = 1.0f;
            grx.scale(scaleX, scaleY);
            grx.drawLine(0, 0, width, 0);
            grx.setTransform(oldTx);
        }
    }

    public void addBorderSelectionListener(BorderSelectionListener listener) {
        if (listener != null && !this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    protected void fireSelectionListeners(Border border) {
        BorderSelectionEvent event = new BorderSelectionEvent(border.getLocation(), border.isSelected());
        for (BorderSelectionListener listener : this.listeners) {
            listener.borderSelected(event);
        }
    }

    public class Border {
        private Rectangle rect;
        private Location border;
        private boolean selected;

        public Border(Rectangle rect, Location border) {
            this.rect = rect;
            this.border = border;
            this.selected = false;
        }

        public Location getLocation() {
            return this.border;
        }

        public boolean isIntersecting(int x, int y) {
            return this.rect.contains(new Point(x, y));
        }

        public void setRectangle(Rectangle rect) {
            this.rect = rect;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public boolean changeSelected() {
            boolean bl = this.selected = !this.selected;
            if (this.selected) {
                LineBoxDrawer.this.lastSelected = this;
            }
            return this.selected;
        }

        public Rectangle getRect() {
            return this.rect;
        }

        public void setSelected(boolean newValue) {
            this.selected = newValue;
        }
    }

    public static enum Location {
        LEFT,
        RIGHT,
        BOTTOM,
        TOP;

    }
}

