/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.section.report.util;

import com.jaspersoft.studio.messages.Messages;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public class Unit {
    protected static final BigDecimal MAXIMUM_PIXELS = new BigDecimal(Integer.MAX_VALUE);
    protected static final BigDecimal MINIMUM_PIXELS = new BigDecimal(Integer.MIN_VALUE);
    public static final String MM = "mm";
    public static final String CM = "cm";
    public static final String INCH = "inch";
    public static final String PX = "pixel";
    private static final Map<String, BigDecimal> units = new LinkedHashMap<String, BigDecimal>();
    private static final Map<String, String> alias;
    private int dpi = 72;
    private int value = 0;
    private String unit = "pixel";
    private static String[] unitsArrays;

    static {
        units.put(PX, new BigDecimal(1));
        units.put(MM, new BigDecimal("25.4"));
        units.put(CM, new BigDecimal("2.54"));
        units.put(INCH, new BigDecimal(1));
        alias = new LinkedHashMap<String, String>();
        alias.put(PX, PX);
        alias.put("pixels", PX);
        alias.put("px", PX);
        alias.put(CM, CM);
        alias.put("centimeter", CM);
        alias.put("centimeters", CM);
        alias.put("millimeter", MM);
        alias.put("millimeters", MM);
        alias.put(MM, MM);
        alias.put("inches", INCH);
        alias.put("''", INCH);
        alias.put("\"", INCH);
        alias.put(INCH, INCH);
    }

    public Unit(double value, String unit) throws PixelConversionException {
        this.setValue(value, unit);
    }

    public boolean setUnit(String unit) {
        if (this.unit.equals(unit)) {
            return false;
        }
        if (units.get(unit) != null) {
            this.unit = unit;
            return true;
        }
        return false;
    }

    private int toValue(double value, BigDecimal c) throws PixelConversionException {
        BigDecimal pixel = new BigDecimal(value * (double)this.dpi).divide(c, 0, RoundingMode.FLOOR);
        if (pixel.compareTo(MAXIMUM_PIXELS) == 1) {
            throw this.getErrorException(true, pixel.toPlainString());
        }
        if (pixel.compareTo(MINIMUM_PIXELS) == -1) {
            throw this.getErrorException(false, pixel.toPlainString());
        }
        return pixel.intValue();
    }

    protected PixelConversionException getErrorException(boolean isMaximum, String inputValue) {
        if (isMaximum) {
            String message = MessageFormat.format(Messages.Unit_errorTooBig, inputValue, MAXIMUM_PIXELS.toPlainString());
            return new PixelConversionException(message, Integer.MAX_VALUE);
        }
        String message = MessageFormat.format(Messages.Unit_errorTooSmall, inputValue, MINIMUM_PIXELS.toPlainString());
        return new PixelConversionException(message, Integer.MIN_VALUE);
    }

    public double pixel2unit(int val) {
        if (this.unit.equals(PX)) {
            return val;
        }
        BigDecimal c = units.get(this.unit);
        if (c != null) {
            return c.multiply(new BigDecimal(val)).divide(new BigDecimal(this.dpi), 6, RoundingMode.CEILING).doubleValue();
        }
        return val;
    }

    private double fromValue(BigDecimal c) {
        double uval = c.multiply(new BigDecimal(this.value)).divide(new BigDecimal(this.dpi), 6, RoundingMode.CEILING).doubleValue();
        return uval;
    }

    public void setValue(double value, String unit) throws PixelConversionException {
        if (unit.equals(PX)) {
            if (value > 2.147483647E9) {
                throw this.getErrorException(true, String.format("%.0f", value));
            }
            if (value < -2.147483648E9) {
                throw this.getErrorException(false, String.format("%.0f", value));
            }
            this.value = (int)value;
        } else {
            BigDecimal c = units.get(unit);
            if (c != null) {
                this.value = this.toValue(value, c);
                this.unit = unit;
            }
        }
    }

    public double getValue(String unit) {
        if (unit.equals(PX)) {
            return this.value;
        }
        BigDecimal c = units.get(unit);
        if (c != null) {
            return this.fromValue(c);
        }
        return 0.0;
    }

    public int getPxValue() {
        return this.value;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setDPI(int dpi) {
        this.dpi = dpi;
    }

    public static int getUnitIndex(String key) {
        int ind = 0;
        int i = 0;
        while (i < unitsArrays.length) {
            if (unitsArrays[i].equals(key)) {
                return i;
            }
            ++i;
        }
        return ind;
    }

    public static String[] getUnits() {
        if (unitsArrays == null) {
            unitsArrays = units.keySet().toArray(new String[units.keySet().size()]);
        }
        return unitsArrays;
    }

    public static String getKeyFromAlias(String aliasValue) {
        return alias.get(aliasValue);
    }

    public static void addAlias(String aliasName, String key) {
        alias.put(aliasName, key);
    }

    public static String[] getAliasList() {
        ArrayList<String> result = new ArrayList<String>();
        for (String key : alias.keySet()) {
            result.add(key);
        }
        return result.toArray(new String[result.size()]);
    }

    public static String[][] getUnits2() {
        String[][] res = new String[Unit.getUnits().length][2];
        int i = 0;
        while (i < res.length) {
            res[i][0] = unitsArrays[i];
            res[i][1] = unitsArrays[i];
            ++i;
        }
        return res;
    }

    public class PixelConversionException
    extends RuntimeException {
        private static final long serialVersionUID = -9221259595310027388L;
        private final int nearestValue;

        public PixelConversionException(String message, int nearestValue) {
            super(message);
            this.nearestValue = nearestValue;
        }

        public int getNearestValue() {
            return this.nearestValue;
        }
    }
}

