/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.section.style.inerithance;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.editor.gef.parts.EditableFigureEditPart;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.property.section.style.inerithance.ElementClickListener;
import com.jaspersoft.studio.property.section.style.inerithance.StyleContainer;
import com.jaspersoft.studio.property.section.style.inerithance.StylesListSection;
import net.sf.jasperreports.engine.JRStyle;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.MessageBox;

public class StyleClickListener
extends MouseAdapter {
    private APropertyNode targetElement;
    private String property;
    private StylesListSection parentSection;

    public StyleClickListener(APropertyNode styleElement, String property, StylesListSection parentSection) {
        this.targetElement = styleElement;
        this.property = property;
        this.parentSection = parentSection;
    }

    public void mouseUp(MouseEvent e) {
        if (!this.targetElement.isEditable()) {
            MessageBox messageBox = new MessageBox(e.widget.getDisplay().getActiveShell(), 196);
            messageBox.setText(Messages.StylesListSection_NotEditable_Title);
            messageBox.setMessage(Messages.StylesListSection_NotEditable_Message);
            int response = messageBox.open();
            if (response == 64) {
                StyleContainer styleReference = this.parentSection.styleMaps.get(((JRStyle)this.targetElement.getValue()).getName());
                DefaultEditDomain domain = (DefaultEditDomain)this.parentSection.getEditDomain();
                EditableFigureEditPart.openEditor(styleReference.getTemplateValue(), domain.getEditorPart(), styleReference.getTemplate());
            }
        } else {
            MessageBox messageBox = new MessageBox(e.widget.getDisplay().getActiveShell(), 200);
            messageBox.setText(Messages.StylesListSection_Warining_Box_Title);
            messageBox.setMessage(Messages.StylesListSection_Warning_Box_Message);
            int buttonID = messageBox.open();
            if (buttonID == 64) {
                Command c;
                JSSCompoundCommand cc = new JSSCompoundCommand("Set " + this.property, (ANode)this.targetElement);
                String propertyName = this.property;
                int lastSegment = propertyName.lastIndexOf(".");
                if (lastSegment != -1) {
                    propertyName = propertyName.substring(lastSegment + 1);
                }
                if ((c = this.parentSection.generateSetAttributeCommand(ElementClickListener.getRealElement(this.targetElement, this.property), propertyName)) != null) {
                    cc.add(c);
                }
                if (!cc.getCommands().isEmpty()) {
                    this.parentSection.executeAndRefresh((Command)cc);
                }
            }
        }
    }
}

