/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.section.style.inerithance;

import com.jaspersoft.studio.editor.gef.parts.EditableFigureEditPart;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.messages.MessagesByKeys;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.DefaultValuesMap;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.MLineBox;
import com.jaspersoft.studio.model.MLinePen;
import com.jaspersoft.studio.model.MPage;
import com.jaspersoft.studio.model.style.MConditionalStyle;
import com.jaspersoft.studio.model.style.MStyle;
import com.jaspersoft.studio.model.style.MStyleTemplate;
import com.jaspersoft.studio.model.style.MStyles;
import com.jaspersoft.studio.model.style.MStylesTemplate;
import com.jaspersoft.studio.model.text.MParagraph;
import com.jaspersoft.studio.properties.view.TabbedPropertySheetPage;
import com.jaspersoft.studio.property.section.AbstractSection;
import com.jaspersoft.studio.property.section.style.inerithance.AbstractContextualMenu;
import com.jaspersoft.studio.property.section.style.inerithance.ElementClickListener;
import com.jaspersoft.studio.property.section.style.inerithance.ElementContextualMenu;
import com.jaspersoft.studio.property.section.style.inerithance.IconMouseTracker;
import com.jaspersoft.studio.property.section.style.inerithance.StyleClickListener;
import com.jaspersoft.studio.property.section.style.inerithance.StyleContainer;
import com.jaspersoft.studio.utils.Colors;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.type.JREnum;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.progress.WorkbenchJob;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.wb.swt.ResourceCache;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.wb.swt.SWTResourceManager;

public class StylesListSection
extends AbstractSection {
    private static org.eclipse.swt.graphics.Color leftStringColor = null;
    private static final int ITEM_WIDTH = 220;
    private static Image image = ResourceManager.getPluginImage((String)"com.jaspersoft.studio", (String)"icons/resources/remove-16.png");
    protected HashMap<Object, StyleContainer> styleMaps;
    private HashSet<String> overriddenAttributes;
    private MStyle defaultStyle = null;
    private Composite mainComposite = null;
    private INode listenedRoot = null;
    private IconMouseTracker trackerListener = new IconMouseTracker();
    private UpdatePanelJob updatePanelJob = new UpdatePanelJob();
    private Layout colorLayout = new Layout(){

        protected void layout(Composite parent, boolean flushCache) {
            Control[] children = parent.getChildren();
            Rectangle carea = parent.getClientArea();
            Control colorLabel = children[0];
            int color_y = carea.height > 13 ? (carea.height - 13) / 2 : 0;
            colorLabel.setBounds(0, color_y, 13, 13);
            Control text = children[1];
            text.setBounds(15, 0, carea.width - 15, carea.height);
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            Control[] children = composite.getChildren();
            Point size = children[1].computeSize(wHint, hHint);
            return new Point(size.x + 15, Math.max(size.y, 13));
        }
    };
    private Layout removeLayout = new Layout(){

        protected void layout(Composite parent, boolean flushCache) {
            Control[] children = parent.getChildren();
            Rectangle carea = parent.getClientArea();
            Control imageLabel = children[0];
            int image_y = carea.height > 16 ? (carea.height - 16) / 2 : 0;
            imageLabel.setBounds(0, image_y, 16, 16);
            Control text = children[1];
            text.setBounds(18, 0, carea.width - 18, carea.height);
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            Control[] children = composite.getChildren();
            Point size = children[1].computeSize(wHint, hHint);
            return new Point(size.x + 18, Math.max(size.y, 16));
        }
    };
    private static final int UPDATE_DELAY = 100;
    private boolean shown = false;
    private static final org.eclipse.swt.graphics.Color labelBackgroundColor = SWTResourceManager.getColor((int)240, (int)240, (int)240);
    private ResourceCache colorCache = new ResourceCache();

    protected Object getElementStyle(APropertyNode element) {
        if (element.getValue() instanceof JRElement) {
            JRElement jrElement = (JRElement)element.getValue();
            if (jrElement.getStyle() != null) {
                return jrElement.getStyle();
            }
            return jrElement.getStyleNameReference();
        }
        if (element.getValue() instanceof JRStyle) {
            JRStyle jrStyle = (JRStyle)element.getValue();
            String jrStyleName = jrStyle.getStyleNameReference();
            if (jrStyleName != null) {
                return jrStyleName;
            }
            return jrStyle.getStyle();
        }
        return null;
    }

    private Object getStyleKey(ANode element) {
        if (element == null) {
            return null;
        }
        if (element instanceof MConditionalStyle) {
            return this.getStyleKey(element.getParent());
        }
        if (element instanceof MStyle) {
            MStyle nodeStyle = (MStyle)element;
            if (nodeStyle.getParent() instanceof MStyleTemplate) {
                return nodeStyle.getValue().getName();
            }
            return element.getValue();
        }
        return null;
    }

    private LinkedList<MStyle> buildStylesGerarchy(APropertyNode element) {
        LinkedList<MStyle> result = new LinkedList<MStyle>();
        Object style = this.getElementStyle(element);
        StyleContainer styleContainer = this.styleMaps.get(style);
        while (styleContainer != null) {
            MStyle styleModel = styleContainer.getStyle();
            if (result.contains(styleModel)) break;
            result.addLast(styleModel);
            style = this.getElementStyle(styleModel);
            styleContainer = this.styleMaps.get(style);
        }
        return result;
    }

    private void strikeStyledText(StyledText valueText) {
        StyleRange style1 = new StyleRange();
        style1.strikeout = true;
        style1.start = 0;
        style1.length = valueText.getText().length();
        valueText.setStyleRange(style1);
    }

    private String getHexFromRGB(RGB color) {
        int r = color.red;
        int g = color.green;
        int b = color.blue;
        String s = String.valueOf(Integer.toHexString(r)) + Integer.toHexString(g) + Integer.toHexString(b);
        return "#" + StringUtils.rightPad((String)s, (int)6, (String)"0").toUpperCase();
    }

    private Control paintColor(Composite parent, RGB colorValue, String colorName, boolean addLine, String toolTip) {
        String stringValue = this.getHexFromRGB(colorValue);
        Composite nameComp = new Composite(parent, 0);
        nameComp.setLayoutData((Object)this.generateElementGridData());
        Label imageLabel = new Label(nameComp, 0);
        imageLabel.setImage(image);
        imageLabel.setVisible(false);
        StyledText label = new StyledText(nameComp, 0);
        label.setText(colorName);
        label.setForeground(leftStringColor);
        label.setEditable(false);
        label.setEnabled(false);
        nameComp.setToolTipText(toolTip);
        nameComp.setLayout(this.removeLayout);
        Composite valueComp = new Composite(parent, 0);
        RowLayout inLineLayout = new RowLayout();
        valueComp.setLayout((Layout)inLineLayout);
        valueComp.setLayoutData((Object)this.generateElementGridData());
        Label valueColor = new Label(valueComp, 0);
        valueColor.setBackground(this.colorCache.getColor(colorValue));
        valueColor.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.setBackground(ColorConstants.black);
                e.gc.drawRectangle(0, 0, 12, 12);
            }
        });
        StyledText valueText = new StyledText(valueComp, 0);
        valueText.setText(stringValue);
        valueText.setEditable(false);
        valueText.setEnabled(true);
        if (addLine) {
            this.strikeStyledText(valueText);
            this.strikeStyledText(label);
        }
        valueComp.setLayout(this.colorLayout);
        return imageLabel;
    }

    protected Control printLabels(Composite parent, String name, String value, boolean addLine, String toolTip) {
        Composite valueComp = new Composite(parent, 0);
        valueComp.setLayoutData((Object)this.generateElementGridData());
        Label imageLabel = new Label(valueComp, 0);
        imageLabel.setImage(image);
        imageLabel.setVisible(false);
        StyledText label = new StyledText(valueComp, 0);
        label.setText(name);
        label.setForeground(leftStringColor);
        label.setEditable(false);
        label.setEnabled(false);
        valueComp.setToolTipText(toolTip);
        valueComp.setLayout(this.removeLayout);
        StyledText valueText = new StyledText(parent, 0);
        valueText.setText(value);
        valueText.setEditable(false);
        valueText.setEnabled(false);
        if (addLine) {
            this.strikeStyledText(valueText);
            this.strikeStyledText(label);
        }
        return imageLabel;
    }

    private Control paintCheckBox(Composite parent, String name, boolean checked, boolean addLine, String toolTip) {
        String stringValue = MessagesByKeys.getString("common_boolean_" + checked);
        return this.printLabels(parent, name, stringValue, addLine, toolTip);
    }

    private IPropertyDescriptor getNestedDescriptor(String fullProperty, APropertyNode actualElement) {
        String lastSegment = fullProperty;
        int lastSeparator = fullProperty.lastIndexOf(".");
        if (lastSeparator != -1) {
            lastSegment = fullProperty.substring(lastSeparator + 1);
        }
        IPropertyDescriptor result = actualElement.getPropertyDescriptor(lastSegment);
        return result;
    }

    private String propertyNamePrefixProvider(String fullPropertyName) {
        String prefix = "";
        if (fullPropertyName.startsWith("LineBox")) {
            prefix = "Box ";
            if (fullPropertyName.contains("LinePen_LEFT")) {
                prefix = String.valueOf(prefix) + "Left ";
            } else if (fullPropertyName.contains("LinePen_RIGHT")) {
                prefix = String.valueOf(prefix) + "Right ";
            } else if (fullPropertyName.contains("LinePen_BOTTOM")) {
                prefix = String.valueOf(prefix) + "Bottom ";
            } else if (fullPropertyName.contains("LinePen_TOP")) {
                prefix = String.valueOf(prefix) + "Top ";
            }
        } else if (fullPropertyName.startsWith("LinePen")) {
            prefix = "Pen ";
        }
        return prefix;
    }

    private void printObject(String fullPropertyName, Object value, Composite parent, APropertyNode actualElement, AttributeParent parentType, boolean addListener) {
        if (value instanceof MLinePen) {
            MLinePen lineValue = (MLinePen)value;
            this.printStyleAttribute(parent, lineValue, fullPropertyName, parentType, addListener);
        } else if (value instanceof MParagraph) {
            MParagraph paragraphValue = (MParagraph)value;
            this.printStyleAttribute(parent, paragraphValue, fullPropertyName, parentType, addListener);
        } else if (value instanceof MLineBox) {
            MLineBox boxValue = (MLineBox)value;
            this.printStyleAttribute(parent, boxValue, fullPropertyName, parentType, addListener);
        } else {
            boolean printLine = this.isOverridden(fullPropertyName);
            IPropertyDescriptor descriptor = this.getNestedDescriptor(fullPropertyName, actualElement);
            String name = String.valueOf(this.propertyNamePrefixProvider(fullPropertyName)) + descriptor.getDisplayName();
            if (value instanceof org.eclipse.swt.graphics.Color) {
                RGB valImage = ((org.eclipse.swt.graphics.Color)value).getRGB();
                Control label = this.paintColor(parent, valImage, name, printLine, descriptor.getDescription());
                if (addListener) {
                    this.addListeners(label, actualElement, fullPropertyName, parentType);
                }
                this.overriddenAttributes.add(fullPropertyName);
            } else if (value instanceof Color) {
                Color valImage = (Color)value;
                Control label = this.paintColor(parent, this.getSWTColorFromAWT(valImage), name, printLine, descriptor.getDescription());
                if (addListener) {
                    this.addListeners(label, actualElement, fullPropertyName, parentType);
                }
                this.overriddenAttributes.add(fullPropertyName);
            } else if (value instanceof JREnum) {
                JREnum enumValue = (JREnum)value;
                Control label = this.printLabels(parent, name, enumValue.getName(), printLine, descriptor.getDescription());
                if (addListener) {
                    this.addListeners(label, actualElement, fullPropertyName, parentType);
                }
                this.overriddenAttributes.add(fullPropertyName);
            } else if (value instanceof Boolean) {
                Control label = this.paintCheckBox(parent, name, (Boolean)value, printLine, descriptor.getDescription());
                if (addListener) {
                    this.addListeners(label, actualElement, fullPropertyName, parentType);
                }
                this.overriddenAttributes.add(fullPropertyName);
            } else {
                Control label = this.printLabels(parent, name, value.toString(), printLine, descriptor.getDescription());
                if (addListener) {
                    this.addListeners(label, actualElement, fullPropertyName, parentType);
                }
                this.overriddenAttributes.add(fullPropertyName);
            }
        }
    }

    private void addListeners(Control control, APropertyNode actualElement, String attributeId, AttributeParent parentType) {
        Composite parent = control.getParent();
        parent.addMouseTrackListener((MouseTrackListener)this.trackerListener);
        Control[] controlArray = parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control son = controlArray[n2];
            son.addMouseTrackListener((MouseTrackListener)this.trackerListener);
            ++n2;
        }
        control.setToolTipText(Messages.StylesListSection_removeAttribure_tooltip);
        if (parentType == AttributeParent.ELEMENT) {
            control.addMouseListener((MouseListener)new ElementClickListener(attributeId, this));
        } else {
            control.addMouseListener((MouseListener)new StyleClickListener(actualElement, attributeId, this));
        }
    }

    private Label printTitle(Composite parent, String value) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        container.setLayout((Layout)layout);
        container.setBackground(labelBackgroundColor);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        gridData.widthHint = 4;
        container.setLayoutData((Object)gridData);
        Label label = new Label(container, 0);
        gridData = new GridData();
        gridData.verticalAlignment = 0x1000000;
        gridData.horizontalAlignment = 16384;
        label.setBackground(labelBackgroundColor);
        label.setText(" " + value);
        label.setLayoutData((Object)gridData);
        return label;
    }

    private Button printTitleWithButton(Composite parent, String value, final AbstractContextualMenu contextualOpener) {
        Composite buttonContainer = this.printTitle(parent, value).getParent();
        Button btn = new Button(buttonContainer, 1028);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 16384;
        btn.setLayoutData((Object)gridData);
        btn.addSelectionListener((SelectionListener)contextualOpener);
        btn.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                contextualOpener.dispose();
            }
        });
        return btn;
    }

    private void printElementAttribute(Composite parent, APropertyNode element, String titleValue) {
        if (titleValue != null) {
            if (element.isEditable()) {
                this.printTitleWithButton(parent, titleValue, new ElementContextualMenu(this));
            } else {
                this.printTitle(parent, titleValue);
            }
        }
        for (Map.Entry<String, Object> entry : element.getStylesDescriptors().entrySet()) {
            String attributeKey = entry.getKey();
            Object attributeValue = entry.getValue();
            if (attributeValue == null) continue;
            this.printObject(attributeKey, attributeValue, parent, element, AttributeParent.ELEMENT, element.isEditable());
        }
    }

    private void printStyleAttribute(Composite parent, APropertyNode element, String keyPrefix, AttributeParent parentType, boolean addListener) {
        HashMap<String, Object> properties = element.getStylesDescriptors();
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            String attributeKey = entry.getKey();
            Object attributeValue = entry.getValue();
            if (attributeValue == null) continue;
            if (keyPrefix != null) {
                attributeKey = keyPrefix.concat(".").concat(attributeKey);
            }
            this.printObject(attributeKey, attributeValue, parent, element, parentType, addListener);
        }
    }

    private GridData generateElementGridData() {
        GridData sameSizeGridData = new GridData();
        sameSizeGridData.verticalAlignment = 0x1000000;
        return sameSizeGridData;
    }

    private void printStyleTitle(String titleValue, APropertyNode element, Composite parent) {
        StyleContainer styleReference;
        if (titleValue != null && (styleReference = this.styleMaps.get(this.getStyleKey(element))) != null) {
            if (styleReference.isExternal()) {
                Label titleLabel = this.printTitle(parent, titleValue);
                titleLabel.setText(titleLabel.getText().concat(Messages.StylesListSection_NotEditable_Visual_Marker));
                titleLabel.addMouseListener((MouseListener)new MouseAdapter(){

                    public void mouseDoubleClick(MouseEvent e) {
                        EditableFigureEditPart.openEditor(styleReference.getTemplateValue(), ((DefaultEditDomain)StylesListSection.this.getEditDomain()).getEditorPart(), styleReference.getTemplate());
                    }
                });
            } else {
                this.printTitle(parent, titleValue);
            }
        }
    }

    private void printStyles(LinkedList<MStyle> styles, Composite parent) {
        ListIterator itr = styles.listIterator();
        boolean hasDefaultStyleInGerarchy = false;
        while (itr.hasNext()) {
            MStyle style = (MStyle)itr.next();
            String titleLabelText = MessageFormat.format(Messages.StylesSectionList_Inherited_From_Style, style.getPropertyValue("name"));
            this.printStyleTitle(titleLabelText, style, parent);
            this.printStyleAttribute(parent, style, null, AttributeParent.STYLE, false);
            if (style != this.defaultStyle) continue;
            hasDefaultStyleInGerarchy = true;
        }
        if (styles.isEmpty() && !hasDefaultStyleInGerarchy && this.defaultStyle != null && this.defaultStyle != this.getElement()) {
            String titleLabelText = MessageFormat.format(Messages.StylesListSection_Inherited_From_Default_Style, this.defaultStyle.getPropertyValue("name"));
            this.printStyleTitle(titleLabelText, this.defaultStyle, parent);
            this.printStyleAttribute(parent, this.defaultStyle, null, AttributeParent.STYLE, false);
        }
    }

    private void recursiveReadStyles(List<INode> stylesList, MStyleTemplate parentReference, JRStyle defaultValue) {
        for (INode style : stylesList) {
            if (style instanceof MStyle) {
                MStyle element = (MStyle)style;
                if (element.getValue() == defaultValue) {
                    this.defaultStyle = element;
                }
                this.styleMaps.put(this.getStyleKey(element), new StyleContainer(element, parentReference));
                continue;
            }
            if (!(style instanceof MStyleTemplate)) continue;
            this.recursiveReadStyles(style.getChildren(), (MStyleTemplate)style, defaultValue);
        }
    }

    protected IPropertyDescriptor getDefaultDescriptor(String fullProperty) {
        String[] properties = fullProperty.split("\\.");
        APropertyNode element = this.getElement();
        int i = 0;
        while (i < properties.length - 1) {
            element = (APropertyNode)element.getPropertyValue(properties[i]);
            ++i;
        }
        IPropertyDescriptor result = element.getPropertyDescriptor(properties[properties.length - 1]);
        return result;
    }

    protected void printDefaultObject(String fullPropertyName, Object value, Composite parent) {
        boolean printLine = this.isOverridden(fullPropertyName);
        IPropertyDescriptor descriptor = this.getDefaultDescriptor(fullPropertyName);
        if (descriptor != null) {
            String name = String.valueOf(this.propertyNamePrefixProvider(fullPropertyName)) + descriptor.getDisplayName();
            if (value instanceof org.eclipse.swt.graphics.Color) {
                RGB valImage = ((org.eclipse.swt.graphics.Color)value).getRGB();
                this.paintColor(parent, valImage, name, printLine, descriptor.getDescription());
            } else if (value instanceof Color) {
                Color valImage = (Color)value;
                this.paintColor(parent, this.getSWTColorFromAWT(valImage), name, printLine, descriptor.getDescription());
            } else if (value instanceof JREnum) {
                JREnum enumValue = (JREnum)value;
                this.printLabels(parent, name, enumValue.getName(), printLine, descriptor.getDescription());
            } else if (value instanceof Boolean) {
                this.paintCheckBox(parent, name, (Boolean)value, printLine, descriptor.getDescription());
            } else {
                this.printLabels(parent, name, value.toString(), printLine, descriptor.getDescription());
            }
        }
    }

    private void printDefaultValues(Composite parent, Map<String, Object> defaultValues) {
        this.printTitle(parent, Messages.StylesListSection_defaultAttributesTitle);
        for (Map.Entry<String, Object> entry : defaultValues.entrySet()) {
            String attributeKey = entry.getKey();
            Object attributeValue = entry.getValue();
            if (attributeValue == null) continue;
            this.printDefaultObject(attributeKey, attributeValue, parent);
        }
    }

    private void initStyleMaps() {
        this.styleMaps = new HashMap();
        this.overriddenAttributes = new HashSet();
        this.defaultStyle = null;
        if (leftStringColor == null) {
            leftStringColor = SWTResourceManager.getColor((int)42, (int)96, (int)213);
        }
        JRStyle defaultValue = this.getElement().getJasperDesign().getDefaultStyle();
        ANode stylesRoot = this.getStylesRoot(this.getElement());
        if (stylesRoot != null) {
            List<INode> list = stylesRoot.getChildren();
            ArrayList<INode> externalList = new ArrayList<INode>();
            for (INode style : list) {
                if (style instanceof MStyle) {
                    MStyle element = (MStyle)style;
                    Object styleKey = this.getStyleKey(element);
                    this.styleMaps.put(styleKey, new StyleContainer(element));
                    if (element.getValue() != defaultValue) continue;
                    this.defaultStyle = element;
                    continue;
                }
                if (!(style instanceof MStyleTemplate)) continue;
                externalList.add(style);
            }
            this.recursiveReadStyles(externalList, null, defaultValue);
        }
    }

    protected boolean isOverridden(String fullPropertyName) {
        return this.overriddenAttributes.contains(fullPropertyName);
    }

    private ANode getStylesRoot(INode element) {
        INode root = element.getRoot();
        ANode stylesClass = null;
        if (root != null) {
            List<INode> children = element.getRoot().getChildren();
            Iterator<INode> it = children.iterator();
            while (it.hasNext() && stylesClass == null) {
                INode childElement = it.next();
                if (childElement instanceof MStyles || childElement instanceof MStylesTemplate) {
                    stylesClass = (ANode)childElement;
                }
                if (!(childElement instanceof MPage)) continue;
                children = childElement.getChildren();
                it = children.iterator();
            }
        }
        return stylesClass;
    }

    @Override
    public void aboutToBeShown() {
        if (this.listenedRoot != null) {
            this.listenedRoot.getPropertyChangeSupport().removePropertyChangeListener(this);
            this.listenedRoot = null;
        }
        if (this.getElement() != null && this.getElement().getRoot() != null) {
            this.listenedRoot = this.getElement().getRoot();
            this.listenedRoot.getPropertyChangeSupport().addPropertyChangeListener(this);
            ANode stylesRoot = this.getStylesRoot(this.listenedRoot);
            if (stylesRoot != null) {
                for (INode style : stylesRoot.getChildren()) {
                    style.getPropertyChangeSupport().removePropertyChangeListener(this);
                    style.getPropertyChangeSupport().addPropertyChangeListener(this);
                }
            }
        }
        this.shown = true;
        this.createContent();
    }

    @Override
    public void aboutToBeHidden() {
        if (this.listenedRoot != null) {
            this.listenedRoot.getPropertyChangeSupport().removePropertyChangeListener(this);
            ANode styles = this.getStylesRoot(this.listenedRoot);
            if (styles != null) {
                for (INode style : styles.getChildren()) {
                    style.getPropertyChangeSupport().removePropertyChangeListener(this);
                }
            }
            this.listenedRoot = null;
        }
        this.shown = false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!evt.getPropertyName().equals("templateReferenceFound")) {
            this.updatePanelJob.cancel();
            this.updatePanelJob.schedule(100L);
        }
    }

    private RGB getSWTColorFromAWT(Color awtColor) {
        return Colors.getSWTRGB4AWTGBColor(awtColor).getRgb();
    }

    private void printSectionTitle(Composite parent) {
        StyledText label = new StyledText(parent, 64);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 128;
        gridData.horizontalSpan = 2;
        gridData.horizontalIndent = 5;
        label.setLayoutData((Object)gridData);
        label.setFont(ResourceManager.getBoldFont((Font)label.getFont()));
        label.setText(Messages.StylesListSection_Title);
        label.setEnabled(false);
    }

    private void createContent() {
        if (!this.isRefreshing()) {
            this.setRefreshing(true);
            this.trackerListener.refresh();
            this.clearOldContent();
            this.mainComposite = new Composite(this.parent, 0);
            GridLayout compositeLayout = new GridLayout(2, false);
            compositeLayout.marginWidth = 0;
            compositeLayout.marginHeight = 2;
            this.mainComposite.setLayout((Layout)compositeLayout);
            this.mainComposite.setLayoutData((Object)new GridData(1808));
            this.initStyleMaps();
            LinkedList<MStyle> styles = this.buildStylesGerarchy(this.getElement());
            this.printSectionTitle(this.mainComposite);
            this.printElementAttribute(this.mainComposite, this.getElement(), Messages.StylesSectionList_Element_Attributes);
            this.printStyles(styles, this.mainComposite);
            this.printDefaultValues(this.mainComposite, this.getDefaultValues());
            this.parent.layout();
            this.setRefreshing(false);
        }
    }

    protected Map<String, Object> getDefaultValues() {
        return DefaultValuesMap.getPropertiesByType(this.getElement());
    }

    private void clearOldContent() {
        if (this.mainComposite != null && !this.mainComposite.isDisposed()) {
            this.mainComposite.dispose();
        }
        this.mainComposite = null;
    }

    protected Command generateSetAttributeCommand(APropertyNode targetElement, String propertyId) {
        return this.getChangePropertyCommand(propertyId, null, targetElement);
    }

    protected void executeAndRefresh(Command commantToExecute) {
        CommandStack cs = this.getEditDomain().getCommandStack();
        cs.execute(commantToExecute);
        this.createContent();
        this.parent.setFocus();
    }

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.mainComposite = new Composite(parent, 0);
        this.mainComposite.setLayout((Layout)new GridLayout(2, false));
        GridData data = new GridData(1808);
        data.widthHint = 440;
        this.mainComposite.setLayoutData((Object)data);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.colorCache.dispose();
        this.updatePanelJob.cancel();
    }

    private static enum AttributeParent {
        ELEMENT,
        STYLE;

    }

    private class UpdatePanelJob
    extends WorkbenchJob {
        public UpdatePanelJob() {
            super("Update Styles Tab");
            this.setSystem(true);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (StylesListSection.this.shown) {
                monitor.beginTask("Update Styles Tab", -1);
                StylesListSection.this.createContent();
                monitor.done();
                return Status.OK_STATUS;
            }
            return Status.CANCEL_STATUS;
        }
    }
}

