/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.section.widgets;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.help.HelpSystem;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.DefaultValue;
import com.jaspersoft.studio.properties.internal.IHighlightPropertyWidget;
import com.jaspersoft.studio.properties.view.validation.ValidationError;
import com.jaspersoft.studio.property.ResetValueCommand;
import com.jaspersoft.studio.property.SetValueCommand;
import com.jaspersoft.studio.property.combomenu.ComboButton;
import com.jaspersoft.studio.property.section.AbstractSection;
import com.jaspersoft.studio.property.section.widgets.BackgroundHighlight;
import com.jaspersoft.studio.property.section.widgets.BorderHightLight;
import com.jaspersoft.studio.property.section.widgets.DoubleControlHighlight;
import com.jaspersoft.studio.property.section.widgets.IHighlightControl;
import com.jaspersoft.studio.utils.UIUtil;
import com.jaspersoft.studio.widgets.framework.manager.DoubleControlComposite;
import java.util.Map;
import net.sf.jasperreports.eclipse.ui.WritableComboButton;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertySheet;

public abstract class ASPropertyWidget<T extends IPropertyDescriptor>
implements IHighlightPropertyWidget {
    protected T pDescriptor;
    protected AbstractSection section;
    private CLabel label;
    protected static MouseAdapter macComboMenuOpener = new MouseAdapter(){

        public void mouseUp(MouseEvent e) {
            Menu menu;
            if (e.button == 3 && ((Control)e.widget).getMenu() != null && !(menu = ((Control)e.widget).getMenu()).isDisposed() && !menu.isVisible()) {
                Point location = e.widget.getDisplay().getCursorLocation();
                menu.setLocation(location.x, location.y);
                menu.setVisible(true);
            }
        }
    };
    protected FocusListener focusListener = new FocusListener(){

        public void focusLost(FocusEvent e) {
            ASPropertyWidget.this.handleFocusLost();
        }

        public void focusGained(FocusEvent e) {
            ASPropertyWidget.this.handleFocusGained();
        }
    };
    private static int defCharWidth = -1;
    private IHighlightControl searchHighLight;
    private IHighlightControl errorHighLight;
    private ControlDecoration errorDeco;

    public ASPropertyWidget(Composite parent, AbstractSection section, T pDescriptor) {
        this.pDescriptor = pDescriptor;
        this.section = section;
        this.createComponent(parent);
        if (this.getControl() != null) {
            this.setupFocusControl((IPropertyDescriptor)pDescriptor, this.getControl());
        }
    }

    protected void setupFocusControl(IPropertyDescriptor pDescriptor, Control c) {
        if (c.isEnabled()) {
            c.removeFocusListener(this.focusListener);
            c.addFocusListener(this.focusListener);
            HelpSystem.bindToHelp(pDescriptor, c);
        }
        if (c instanceof Composite) {
            Control[] controlArray = ((Composite)c).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control cc = controlArray[n2];
                this.setupFocusControl(pDescriptor, cc);
                ++n2;
            }
        }
    }

    public void setReadOnly(boolean readonly) {
        if (this.getControl() != null) {
            this.getControl().setEnabled(!readonly);
        }
    }

    protected abstract void createComponent(Composite var1);

    public abstract void setData(APropertyNode var1, Object var2);

    protected void refresh() {
        this.setData(this.section.getElement(), this.section.getElement().getPropertyValue(this.getId()));
    }

    public void setData(APropertyNode pnode, Object resolvedValue, Object elementValue) {
        this.setData(pnode, resolvedValue);
    }

    protected void createContextualMenu(APropertyNode node) {
        Control control = this.getControl();
        this.createContextualMenu(node, control, this.pDescriptor.getId().toString());
    }

    protected void createContextualMenu(final APropertyNode node, final Control control, final String propertyID) {
        if (node != null && control != null && !control.isDisposed()) {
            DefaultValue defaultEntry;
            boolean handleComboListener;
            boolean bl = handleComboListener = Util.isMac() && control.getClass() == Combo.class;
            if (handleComboListener) {
                control.removeMouseListener((MouseListener)macComboMenuOpener);
            }
            boolean entryCreated = false;
            Map<String, DefaultValue> defaultMap = node.getDefaultsPropertiesMap();
            if (defaultMap != null && (defaultEntry = defaultMap.get(propertyID)) != null && (defaultEntry.isNullable() || defaultEntry.hasDefault())) {
                Menu controlMenu = new Menu(control);
                if (defaultEntry.hasDefault()) {
                    MenuItem resetItem = new MenuItem(controlMenu, 0);
                    entryCreated = true;
                    resetItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            JSSCompoundCommand resetCommand = new JSSCompoundCommand(node);
                            for (APropertyNode selectedNode : ASPropertyWidget.this.section.getElements()) {
                                ResetValueCommand cmd = new ResetValueCommand();
                                cmd.setPropertyId(propertyID);
                                cmd.setTarget(selectedNode);
                                resetCommand.add(cmd);
                            }
                            ASPropertyWidget.this.section.getEditDomain().getCommandStack().execute((Command)resetCommand);
                            ASPropertyWidget.this.focusControl(control);
                        }
                    });
                    resetItem.setText(Messages.ASPropertyWidget_0);
                }
                if (defaultEntry.isNullable()) {
                    MenuItem nullItem = new MenuItem(controlMenu, 0);
                    entryCreated = true;
                    nullItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            JSSCompoundCommand resetCommand = new JSSCompoundCommand(node);
                            for (APropertyNode selectedNode : ASPropertyWidget.this.section.getElements()) {
                                SetValueCommand cmd = new SetValueCommand();
                                cmd.setPropertyId(propertyID);
                                cmd.setTarget(selectedNode);
                                cmd.setPropertyValue(null);
                                resetCommand.add(cmd);
                            }
                            ASPropertyWidget.this.section.getEditDomain().getCommandStack().execute((Command)resetCommand);
                            ASPropertyWidget.this.focusControl(control);
                        }
                    });
                    nullItem.setText(Messages.ASPropertyWidget_1);
                }
                if (control.getMenu() != null) {
                    control.getMenu().dispose();
                }
                control.setMenu(controlMenu);
                if (handleComboListener) {
                    control.addMouseListener((MouseListener)macComboMenuOpener);
                }
            }
            if (!entryCreated) {
                if (control.getMenu() != null) {
                    control.getMenu().dispose();
                }
                control.setMenu(null);
            }
        }
    }

    protected void focusControl(Control control) {
        if (control != null) {
            UIUtil.updateFocus(control);
        }
    }

    public String getId() {
        return this.pDescriptor.getId().toString();
    }

    public String getName() {
        return this.pDescriptor.getDisplayName();
    }

    public CLabel getLabel() {
        return this.label;
    }

    public void setLabel(CLabel label) {
        this.label = label;
    }

    private IStatusLineManager getStatusLineManager() {
        IStatusLineManager statusLineManager = null;
        IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        try {
            IWorkbenchPart workbenchPart = activeWindow.getActivePage().getActivePart();
            if (workbenchPart instanceof PropertySheet) {
                IViewPart viewPart = (IViewPart)workbenchPart;
                statusLineManager = viewPart.getViewSite().getActionBars().getStatusLineManager();
            }
            return statusLineManager;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void handleFocusGained() {
        IStatusLineManager statusLineManager = this.getStatusLineManager();
        if (statusLineManager != null) {
            statusLineManager.setMessage(this.pDescriptor.getDescription());
        }
    }

    protected void handleFocusLost() {
        IStatusLineManager statusLineManager = this.getStatusLineManager();
        if (statusLineManager != null) {
            statusLineManager.setMessage(null);
        }
    }

    public abstract Control getControl();

    public Control getControlToBorder() {
        return this.getControl();
    }

    public static IHighlightControl getControlHighlight(Control control) {
        if (control.getClass().equals(Spinner.class)) {
            return new BackgroundHighlight(control);
        }
        if (control.getClass().equals(Text.class)) {
            return new BackgroundHighlight(control);
        }
        if (control.getClass().equals(ToolBar.class)) {
            return new BackgroundHighlight(control);
        }
        if (control.getClass().equals(Combo.class) && (control.getStyle() & 8) != 8) {
            return new BackgroundHighlight(control);
        }
        if (control.getClass().equals(Button.class) && (control.getStyle() & 0x20) == 32) {
            return new BackgroundHighlight(control);
        }
        if (control.getClass().equals(Button.class) && (control.getStyle() & 8) == 8) {
            return new BorderHightLight(control, Combo.class);
        }
        if (control.getClass().equals(ComboButton.GraphicButton.class)) {
            return new BackgroundHighlight(control);
        }
        if (control.getClass().equals(WritableComboButton.class)) {
            return new BackgroundHighlight(control);
        }
        if (control instanceof DoubleControlComposite) {
            return new DoubleControlHighlight((DoubleControlComposite)control);
        }
        if (control instanceof Composite) {
            return new BorderHightLight(control);
        }
        if (control instanceof Button) {
            return new BorderHightLight(control);
        }
        return null;
    }

    public void highLightWidget(final long ms) {
        final Control ctb = this.getControlToBorder();
        if (ctb == null) {
            return;
        }
        if (this.searchHighLight == null) {
            this.searchHighLight = ASPropertyWidget.getControlHighlight(ctb);
        }
        if (this.searchHighLight == null) {
            return;
        }
        this.searchHighLight.highLightControl();
        ctb.forceFocus();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(ms);
                    ctb.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            (this).ASPropertyWidget.this.searchHighLight.deHighLightControl();
                            if ((this).ASPropertyWidget.this.errorDeco != null) {
                                (this).ASPropertyWidget.this.errorDeco.showHoverText((this).ASPropertyWidget.this.errorDeco.getDescriptionText());
                            }
                        }
                    });
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    public static int getCharWidth(Control c) {
        if (defCharWidth < 0) {
            defCharWidth = UIUtil.getCharWidth((Drawable)c);
        }
        return defCharWidth;
    }

    public void toggleVisibility(boolean show) {
        if (this.getLabel().getLayoutData() instanceof GridData) {
            ((GridData)this.getLabel().getLayoutData()).exclude = !show;
        }
        this.getLabel().setVisible(show);
        this.getLabel().setEnabled(show);
        if (this.getControl().getLayoutData() instanceof GridData) {
            ((GridData)this.getControl().getLayoutData()).exclude = !show;
        }
        this.getControl().setVisible(show);
        this.getControl().setEnabled(show);
    }

    public void resetErrors() {
        if (this.errorDeco != null) {
            this.errorDeco.hideHover();
        }
        if (this.getControlToBorder() == null) {
            return;
        }
        if (this.errorHighLight == null) {
            return;
        }
        this.errorHighLight.deHighLightControl(null);
    }

    public void showErrors(String msg, boolean warning) {
        if (this.errorDeco == null) {
            Control c = this.getControlToBorder();
            if (c == null) {
                c = this.getControl();
            }
            this.errorDeco = new ControlDecoration(c, 16512);
            this.errorDeco.setShowOnlyOnFocus(true);
        }
        this.errorDeco.showHoverText(msg);
        if (this.getControlToBorder() == null) {
            return;
        }
        if (this.errorHighLight == null) {
            this.errorHighLight = ASPropertyWidget.getControlHighlight(this.getControlToBorder());
            if (this.errorHighLight instanceof BackgroundHighlight) {
                if (warning) {
                    ((BackgroundHighlight)this.errorHighLight).setColor(ValidationError.WARN);
                } else {
                    ((BackgroundHighlight)this.errorHighLight).setColor(ValidationError.ERROR);
                }
            }
        }
        if (this.errorHighLight == null) {
            return;
        }
        this.errorHighLight.highLightControl();
    }
}

