/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.section.widgets;

import com.jaspersoft.studio.property.section.widgets.IHighlightControl;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.ResourceManager;

public class BackgroundHighlight
implements IHighlightControl {
    private Control controlToHighlight;
    private RGB oldBackground;
    private Color color;

    public BackgroundHighlight(Control control) {
        this(control, ColorConstants.orange);
    }

    public BackgroundHighlight(Control control, Color color) {
        this.controlToHighlight = control;
        this.color = color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    public void highLightControl() {
        if (this.controlToHighlight != null && !this.controlToHighlight.isDisposed()) {
            this.oldBackground = this.controlToHighlight.getBackground().getRGB();
            this.controlToHighlight.setBackground(this.color);
        }
    }

    @Override
    public void deHighLightControl() {
        Color oldColor = null;
        if (this.oldBackground != null) {
            oldColor = ResourceManager.getColor((RGB)this.oldBackground);
        }
        this.deHighLightControl(oldColor);
    }

    @Override
    public void deHighLightControl(Color oldColor) {
        if (this.oldBackground != null && !this.controlToHighlight.isDisposed()) {
            if (this.controlToHighlight.isFocusControl() && System.getProperty("os.name").toLowerCase().contains("mac")) {
                Point p = null;
                if (this.controlToHighlight instanceof Text) {
                    p = ((Text)this.controlToHighlight).getSelection();
                }
                this.controlToHighlight.setEnabled(false);
                this.controlToHighlight.setBackground(oldColor);
                this.controlToHighlight.setEnabled(true);
                this.controlToHighlight.setFocus();
                if (this.controlToHighlight instanceof Text) {
                    ((Text)this.controlToHighlight).setSelection(p);
                }
            } else {
                this.controlToHighlight.setBackground(oldColor);
            }
            this.controlToHighlight.redraw();
        }
    }
}

