/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.section.widgets;

import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.property.descriptor.classname.ClassTypeCellEditor;
import com.jaspersoft.studio.property.section.AbstractSection;
import com.jaspersoft.studio.property.section.widgets.SPRWCombo;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class SPClassTypeCombo<T extends IPropertyDescriptor>
extends SPRWCombo<T> {
    protected Button btn;
    private List<Class<?>> classes;

    public void setClassesOfType(List<Class<?>> classes) {
        this.classes = classes;
    }

    public SPClassTypeCombo(Composite parent, AbstractSection section, T pDescriptor) {
        super(parent, section, pDescriptor);
    }

    @Override
    public void setReadOnly(boolean readonly) {
        super.setReadOnly(readonly);
        this.btn.setEnabled(!readonly);
    }

    @Override
    protected void createComponent(Composite parent) {
        super.createComponent(parent);
        this.setWidth(parent, 15);
        this.btn = this.section.getWidgetFactory().createButton(parent, "...", 8);
        this.btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String classname = ClassTypeCellEditor.getJavaClassDialog(SPClassTypeCombo.this.btn.getShell(), SPClassTypeCombo.this.classes);
                if (classname != null) {
                    SPClassTypeCombo.this.handleTextChanged(SPClassTypeCombo.this.section, SPClassTypeCombo.this.pDescriptor.getId(), classname);
                }
            }
        });
    }

    protected void setWidth(Composite parent, int chars) {
        int w = SPClassTypeCombo.getCharWidth((Control)this.combo) * chars;
        if (w > 100) {
            w = 100;
        }
        if (parent.getLayout() instanceof RowLayout) {
            RowData rd = new RowData();
            rd.width = w;
            this.combo.setLayoutData((Object)rd);
        } else if (parent.getLayout() instanceof GridLayout) {
            GridData rd = new GridData(768);
            rd.minimumWidth = w;
            rd.widthHint = w;
            this.combo.setLayoutData((Object)rd);
        }
    }

    protected void handleTextChanged(AbstractSection section, Object property, String text) {
        if (text != null && text.trim().isEmpty()) {
            text = null;
        }
        section.changeProperty(property, text);
    }

    @Override
    public void setData(APropertyNode pnode, Object b) {
        this.btn.setEnabled(pnode.isEditable());
        super.setData(pnode, b);
    }
}

