/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.section.widgets;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.DefaultValue;
import com.jaspersoft.studio.model.text.MFont;
import com.jaspersoft.studio.property.combomenu.ComboItem;
import com.jaspersoft.studio.property.combomenu.ComboItemAction;
import com.jaspersoft.studio.property.combomenu.ComboItemSeparator;
import com.jaspersoft.studio.property.combomenu.WritableComboTableViewer;
import com.jaspersoft.studio.property.descriptor.combo.FontNamePropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.combo.RWComboBoxPropertyDescriptor;
import com.jaspersoft.studio.property.section.AbstractSection;
import com.jaspersoft.studio.property.section.widgets.ASPropertyWidget;
import com.jaspersoft.studio.property.section.widgets.SPFontNamePopUp;
import com.jaspersoft.studio.property.section.widgets.SPFontSize;
import com.jaspersoft.studio.swt.widgets.NumericTableCombo;
import com.jaspersoft.studio.utils.ImageUtils;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.UIUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRDesignFont;
import net.sf.jasperreports.engine.fonts.FontUtil;
import net.sf.jasperreports.engine.util.StyleResolver;
import org.eclipse.core.resources.IResource;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.wb.swt.ResourceManager;

public class SPFont
extends ASPropertyWidget<IPropertyDescriptor> {
    private PreferenceListener preferenceListener = new PreferenceListener();
    private WritableComboTableViewer fontName;
    private NumericTableCombo fontSize;
    private ToolItem boldButton;
    private ToolBar boldToolbar;
    private ToolItem italicButton;
    private ToolBar italicToolbar;
    private ToolItem underlineButton;
    private ToolBar underlineToolbar;
    private ToolItem strikeTroughtButton;
    private ToolBar strikeTroughtToolbar;
    private boolean itemsSetted;
    private MFont mfont;
    private APropertyNode parentNode;
    private Composite mainContainer;
    private Composite group;

    public SPFont(Composite parent, AbstractSection section, IPropertyDescriptor pDescriptor) {
        super(parent, section, pDescriptor);
        IResource f = (IResource)section.getJasperReportsContext().get("ifile");
        JaspersoftStudioPlugin.getInstance().addPreferenceListener(this.preferenceListener, f);
        this.itemsSetted = false;
    }

    @Override
    public Control getControl() {
        return this.mainContainer;
    }

    public void propertyChange(AbstractSection section, String property, String value, FontNamePropertyDescriptor pd) {
        this.changeProperty(section, this.pDescriptor.getId(), pd.getId(), value);
    }

    private int indexOf(Combo combo, String searchedString) {
        String[] elements = combo.getItems();
        int i = 0;
        while (i < elements.length) {
            if (elements[i].equals(searchedString)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    protected void refreshFont() {
        if (this.parentNode == null) {
            return;
        }
        List<String[]> fontsList = ModelUtils.getFontNames(this.parentNode.getJasperConfiguration());
        ArrayList<ComboItem> itemsList = new ArrayList<ComboItem>();
        int i = 0;
        FontUtil util = FontUtil.getInstance((JasperReportsContext)this.parentNode.getJasperConfiguration());
        int index = 0;
        while (index < fontsList.size()) {
            String[] fonts;
            String[] stringArray = fonts = fontsList.get(index);
            int n = fonts.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                Image resolvedImage = ResourceManager.getImage((String)element);
                if (resolvedImage == null) {
                    resolvedImage = new Image((Device)UIUtils.getDisplay(), ImageUtils.convertToSWT(SPFontNamePopUp.createFontImage(element, util)));
                    ResourceManager.addImage((String)element, (Image)resolvedImage);
                }
                itemsList.add(new ComboItem(element, true, resolvedImage, i, element, element));
                ++i;
                ++n2;
            }
            if (index + 1 != fontsList.size() && fonts.length > 0) {
                itemsList.add(new ComboItemSeparator(i));
                ++i;
            }
            ++index;
        }
        this.fontName.setItems(itemsList);
    }

    @Override
    protected void createComponent(Composite parent) {
        this.mainContainer = new Composite(parent, 0);
        GridLayout mainContainerLayout = new GridLayout(1, false);
        mainContainerLayout.horizontalSpacing = 0;
        mainContainerLayout.verticalSpacing = 0;
        mainContainerLayout.marginHeight = 0;
        mainContainerLayout.marginWidth = 0;
        this.mainContainer.setLayout((Layout)mainContainerLayout);
        this.mfont = new MFont((JRFont)new JRDesignFont(null));
        this.mfont.setJasperConfiguration(this.section.getElement().getJasperConfiguration());
        this.group = this.section.getWidgetFactory().createSection(this.mainContainer, this.pDescriptor.getDisplayName(), true, 3);
        this.group.getParent().setLayoutData((Object)new GridData(768));
        final FontNamePropertyDescriptor pd = (FontNamePropertyDescriptor)this.mfont.getPropertyDescriptor("fontName");
        this.fontName = new WritableComboTableViewer(this.group, 0x4000002);
        this.fontName.setToolTipText(pd.getDescription());
        this.fontName.addSelectionListener(new ComboItemAction(){

            @Override
            public void exec() {
                SPFont.this.propertyChange(SPFont.this.section, "fontName", SPFont.this.fontName.getSelectionValue() != null ? SPFont.this.fontName.getSelectionValue().toString() : null, pd);
            }
        });
        this.fontName.getControl().setLayoutData((Object)new GridData(768));
        this.fontName.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                JaspersoftStudioPlugin.getInstance().removePreferenceListener(SPFont.this.preferenceListener);
            }
        });
        final RWComboBoxPropertyDescriptor pd1 = (RWComboBoxPropertyDescriptor)this.mfont.getPropertyDescriptor("fontSize");
        this.fontSize = this.getFontSizeCombo(this.group, pd1.getItems());
        this.fontSize.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Float value = SPFont.this.fontSize.getValueAsFloat();
                SPFont.this.changeProperty(SPFont.this.section, SPFont.this.pDescriptor.getId(), pd1.getId(), value);
                int stringLength = SPFont.this.fontSize.getText().length();
                SPFont.this.fontSize.setSelection(new Point(stringLength, stringLength));
            }
        });
        this.fontSize.setToolTipText(pd1.getDescription());
        new SPChartButtom(this, this.group, this.section, (IPropertyDescriptor)pd1, (APropertyNode)this.mfont, this.pDescriptor.getId().toString());
        Composite toolbarsConainer = new Composite(this.group, 0);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        toolbarsConainer.setLayoutData((Object)gd);
        GridLayout containerLayout = new GridLayout(4, false);
        containerLayout.horizontalSpacing = 0;
        containerLayout.verticalSpacing = 0;
        containerLayout.marginWidth = 0;
        containerLayout.marginHeight = 0;
        toolbarsConainer.setLayout((Layout)containerLayout);
        this.boldToolbar = new ToolBar(toolbarsConainer, 0x804040);
        this.boldButton = this.createItem(this.boldToolbar, "isBold", "icons/resources/edit-bold.png");
        this.italicToolbar = new ToolBar(toolbarsConainer, 0x804040);
        this.italicButton = this.createItem(this.italicToolbar, "isItalic", "icons/resources/edit-italic.png");
        this.underlineToolbar = new ToolBar(toolbarsConainer, 0x804040);
        this.underlineButton = this.createItem(this.underlineToolbar, "isUnderline", "icons/resources/edit-underline.png");
        this.strikeTroughtToolbar = new ToolBar(toolbarsConainer, 0x804040);
        this.strikeTroughtButton = this.createItem(this.strikeTroughtToolbar, "isStrikeThrough", "icons/resources/edit-strike.png");
    }

    protected NumericTableCombo getFontSizeCombo(Composite parent, String[] items) {
        NumericTableCombo result = new NumericTableCombo(parent, 0x800000, 0, 6);
        result.setMaximum(new Double(3.4028234663852886E38));
        result.setItems(items);
        return result;
    }

    private ToolItem createItem(ToolBar toolBar, Object id, String image) {
        final IPropertyDescriptor ipd = this.mfont.getPropertyDescriptor(id);
        final ToolItem item = new ToolItem(toolBar, 32);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SPFont.this.changeProperty(SPFont.this.section, SPFont.this.pDescriptor.getId(), ipd.getId(), new Boolean(item.getSelection()));
            }
        });
        item.setImage(JaspersoftStudioPlugin.getInstance().getImage(image));
        item.setToolTipText(ipd.getDescription());
        return item;
    }

    private void changeProperty(AbstractSection section, Object property, Object prop, Object value) {
        section.changePropertyOn(prop, value, this.mfont);
        if (property != null && this.parentNode != null) {
            JRDesignFont oldFont = (JRDesignFont)this.mfont.getValue();
            section.changePropertyOn(property, new MFont((JRFont)oldFont.clone()), this.parentNode);
        }
    }

    public void setFontSizeNumber(Number resolvedNumber, Number ownNumber) {
        this.fontSize.setValue(resolvedNumber);
        this.fontSize.setInherited(ownNumber == null);
        this.createContextualMenu(this.mfont, (Control)this.fontSize, "fontSize");
    }

    @Override
    public void setData(APropertyNode pnode, Object value) {
        this.parentNode = pnode;
        this.mfont = (MFont)value;
        if (this.mfont != null) {
            JRFont fontValue = this.mfont.getValue();
            if (!this.itemsSetted) {
                this.refreshFont();
                this.createContextualMenu(this.mfont, (Control)this.fontName.getControl(), "fontName");
                this.itemsSetted = true;
            }
            String strfontname = StyleResolver.getInstance().getFontName(fontValue);
            this.fontName.setText(strfontname);
            if (fontValue.getOwnFontName() != null) {
                this.fontName.setForeground(ColorConstants.black);
            } else {
                this.fontName.setForeground(UIUtils.INHERITED_COLOR);
            }
            this.setFontSizeNumber(Float.valueOf(fontValue.getFontsize()), fontValue.getOwnFontsize());
            Boolean b = StyleResolver.getInstance().isBold(fontValue);
            this.boldButton.setSelection(b != null ? b : false);
            this.createContextualMenu(this.mfont, (Control)this.boldToolbar, "isBold");
            b = StyleResolver.getInstance().isItalic(fontValue);
            this.italicButton.setSelection(b != null ? b : false);
            this.createContextualMenu(this.mfont, (Control)this.italicToolbar, "isItalic");
            b = StyleResolver.getInstance().isUnderline(fontValue);
            this.underlineButton.setSelection(b != null ? b : false);
            this.createContextualMenu(this.mfont, (Control)this.underlineToolbar, "isUnderline");
            b = StyleResolver.getInstance().isStrikeThrough(fontValue);
            this.strikeTroughtButton.setSelection(b != null ? b : false);
            this.createContextualMenu(this.mfont, (Control)this.strikeTroughtToolbar, "isStrikeThrough");
        }
    }

    @Override
    protected void createContextualMenu(APropertyNode node, final Control control, final String propertyID) {
        if (node != null && control != null && !control.isDisposed()) {
            DefaultValue defaultEntry;
            boolean handleComboListener;
            boolean bl = handleComboListener = Util.isMac() && control.getClass() == Combo.class;
            if (handleComboListener) {
                control.removeMouseListener((MouseListener)macComboMenuOpener);
            }
            boolean entryCreated = false;
            Map<String, DefaultValue> defaultMap = node.getDefaultsPropertiesMap();
            if (defaultMap != null && (defaultEntry = defaultMap.get(propertyID)) != null && (defaultEntry.isNullable() || defaultEntry.hasDefault())) {
                Menu controlMenu = new Menu(control);
                if (defaultEntry.hasDefault()) {
                    MenuItem resetItem = new MenuItem(controlMenu, 0);
                    entryCreated = true;
                    resetItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            SPFont.this.changeProperty(SPFont.this.section, SPFont.this.pDescriptor.getId(), propertyID, defaultEntry.getValue());
                            if (!(control instanceof ToolBar)) {
                                UIUtil.updateFocus(control);
                            }
                        }
                    });
                    resetItem.setText(Messages.ASPropertyWidget_0);
                }
                if (defaultEntry.isNullable()) {
                    MenuItem nullItem = new MenuItem(controlMenu, 0);
                    entryCreated = true;
                    nullItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            SPFont.this.changeProperty(SPFont.this.section, SPFont.this.pDescriptor.getId(), propertyID, null);
                            if (!(control instanceof ToolBar)) {
                                UIUtil.updateFocus(control);
                            }
                        }
                    });
                    nullItem.setText(Messages.ASPropertyWidget_1);
                }
                if (control.getMenu() != null) {
                    control.getMenu().dispose();
                }
                control.setMenu(controlMenu);
                if (handleComboListener) {
                    control.addMouseListener((MouseListener)macComboMenuOpener);
                }
            }
            if (!entryCreated) {
                control.setMenu(null);
            }
        }
    }

    private final class PreferenceListener
    implements IPropertyChangeListener {
        private PreferenceListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("FONT_LIST") && SPFont.this.parentNode != null) {
                SPFont.this.refreshFont();
            }
        }
    }

    private class SPChartButtom<T extends IPropertyDescriptor>
    extends SPFontSize<T> {
        public SPChartButtom(AbstractSection parent, T section, APropertyNode pDescriptor, String fontValue) {
            super((Composite)parent, (AbstractSection)section, pDescriptor, (APropertyNode)((Object)fontValue));
        }

        @Override
        protected void createCommand(boolean increment) {
            Float currentFont = SPFont.this.fontSize.getValueAsFloat();
            Float newValue = Float.valueOf(2.0f);
            if (currentFont != null) {
                newValue = currentFont;
                Float plus = null;
                plus = increment ? Float.valueOf(Math.round(new Float(newValue.floatValue()).floatValue() / 100.0f * (float)SPFontSize.factor.intValue()) + 1) : Float.valueOf(Math.round(new Float(newValue.floatValue()).floatValue() / 100.0f * (float)(-SPFontSize.factor.intValue())) - 1);
                if (newValue.floatValue() + plus.floatValue() > 99.0f) {
                    newValue = Float.valueOf(99.0f);
                } else if (newValue.floatValue() + plus.floatValue() > 0.0f) {
                    newValue = Float.valueOf(newValue.floatValue() + plus.floatValue());
                }
                SPFont.this.changeProperty(this.section, SPFont.this.pDescriptor.getId(), "fontSize", newValue);
            }
        }
    }
}

