/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.section.widgets;

import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.property.section.AbstractSection;
import com.jaspersoft.studio.property.section.widgets.ASPropertyWidget;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.wb.swt.ResourceManager;

public class SPGenericToolbar
extends ASPropertyWidget<IPropertyDescriptor> {
    private List<ToolItemDescription> toolItems;
    private ToolBar toolBar;
    private Composite buttonComposite;
    private Style style;

    public SPGenericToolbar(Composite parent, AbstractSection section, IPropertyDescriptor pDescriptor, Style style) {
        super(parent, section, pDescriptor);
        this.style = style;
    }

    public void addItem(SelectionListener listener, String toolTip, String text, ImageDescriptor image) {
        this.toolItems.add(new ToolItemDescription(listener, toolTip, text, image));
    }

    @Override
    public Control getControl() {
        if (Style.toolbar.equals((Object)this.style)) {
            return this.toolBar;
        }
        return this.buttonComposite;
    }

    @Override
    protected void createComponent(Composite parent) {
        this.toolItems = new ArrayList<ToolItemDescription>();
        if (Style.toolbar.equals((Object)this.style)) {
            this.toolBar = new ToolBar(parent, 8519744);
        } else {
            this.buttonComposite = new Composite(parent, 0);
            RowLayout layout = new RowLayout();
            layout.marginBottom = 0;
            layout.marginLeft = 0;
            layout.marginRight = 1;
            layout.marginTop = 0;
            this.buttonComposite.setLayout((Layout)layout);
        }
    }

    public void createItems() {
        if (Style.toolbar.equals((Object)this.style)) {
            this.createItemsToolbar();
        } else {
            this.createItemsButtons();
        }
    }

    private void createItemsButtons() {
        for (ToolItemDescription desc : this.toolItems) {
            Button btn = new Button(this.buttonComposite, 0);
            if (desc.getText() != null && !desc.getText().isEmpty()) {
                btn.setText(desc.getText());
            }
            btn.setToolTipText(desc.getTooltip());
            btn.setData((Object)desc.getListener());
            if (desc.getImage() != null) {
                btn.setImage(ResourceManager.getImage((ImageDescriptor)desc.getImage()));
            }
            btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Object data = e.widget.getData();
                    if (data instanceof SelectionListener) {
                        ((SelectionListener)data).widgetSelected(e);
                    }
                }
            });
        }
    }

    private void createItemsToolbar() {
        for (ToolItemDescription desc : this.toolItems) {
            ToolItem newItem = new ToolItem(this.toolBar, 8);
            if (desc.getText() != null && !desc.getText().isEmpty()) {
                newItem.setText(desc.getText());
            }
            newItem.setToolTipText(desc.getTooltip());
            newItem.setData((Object)desc.getListener());
            if (desc.getImage() != null) {
                newItem.setImage(ResourceManager.getImage((ImageDescriptor)desc.getImage()));
            }
            newItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Object data = e.widget.getData();
                    if (data instanceof SelectionListener) {
                        ((SelectionListener)data).widgetSelected(e);
                    }
                }
            });
        }
    }

    @Override
    public void setData(APropertyNode pnode, Object b) {
    }

    public static enum Style {
        toolbar,
        buttons;

    }

    private class ToolItemDescription {
        private SelectionListener listener;
        private String tooltip;
        private String text;
        private ImageDescriptor image;

        public ToolItemDescription(SelectionListener listener, String tooltip, String text, ImageDescriptor image) {
            this.listener = listener;
            this.tooltip = tooltip;
            this.text = text;
            this.image = image;
        }

        public SelectionListener getListener() {
            return this.listener;
        }

        public String getTooltip() {
            return this.tooltip;
        }

        public String getText() {
            return this.text;
        }

        public ImageDescriptor getImage() {
            return this.image;
        }
    }
}

