/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.section.widgets;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.property.section.AbstractSection;
import com.jaspersoft.studio.property.section.widgets.AHistorySPropertyWidget;
import com.jaspersoft.studio.property.section.widgets.CustomAutoCompleteField;
import com.jaspersoft.studio.swt.widgets.NullableSpinner;
import com.jaspersoft.studio.utils.UIUtil;
import com.jaspersoft.studio.utils.ValidatedDecimalFormat;
import com.jaspersoft.studio.utils.inputhistory.InputHistoryCache;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class SPNumber
extends AHistorySPropertyWidget<IPropertyDescriptor> {
    protected NullableSpinner ftext;
    private Number min = null;
    private Number max = null;
    private int minDigitsShown = 0;
    private int maxDigitsAccepted = 0;
    private Class<? extends Number> outputType = Integer.class;

    public SPNumber(Composite parent, AbstractSection section, IPropertyDescriptor pDescriptor) {
        super(parent, section, pDescriptor);
    }

    @Override
    public Control getControl() {
        return this.ftext;
    }

    @Override
    protected Text getTextControl() {
        return this.ftext.getTextControl();
    }

    @Override
    protected void createComponent(Composite parent) {
        this.ftext = new NullableSpinner(parent, 133120, 0, 0);
        if (this.min != null) {
            this.ftext.setMinimum(this.min.intValue());
        }
        if (this.max != null) {
            this.ftext.setMaximum(this.max.intValue());
        }
        this.ftext.setNullable(true);
        this.autocomplete = new CustomAutoCompleteField((Control)this.ftext, (IControlContentAdapter)new TextContentAdapter(), InputHistoryCache.get(this.getHistoryKey()));
        this.ftext.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SPNumber.this.changeValue();
            }
        });
        this.ftext.setToolTipText(this.pDescriptor.getDescription());
        this.setWidth(parent, 6);
    }

    protected void changeValue() {
        Number newValue = this.getValue();
        boolean valueChanged = this.section.changeProperty(this.pDescriptor.getId(), newValue);
        if (valueChanged) {
            this.setData(this.section.getElement(), this.section.getElement().getPropertyActualValue(this.pDescriptor.getId()), newValue);
        }
    }

    protected Number getValue() {
        if (this.outputType == Integer.class) {
            return this.ftext.getValueAsInteger();
        }
        if (this.outputType == Long.class) {
            return this.ftext.getValueAsLong();
        }
        if (this.outputType == Float.class) {
            return this.ftext.getValueAsFloat();
        }
        if (this.outputType == Double.class) {
            return this.ftext.getValueAsDouble();
        }
        throw new RuntimeException("Format " + this.outputType.getName() + " not supported by the SPNumber conversion");
    }

    protected void setWidth(Composite parent, int chars) {
        int w = SPNumber.getCharWidth((Control)this.ftext) * chars + 50;
        if (parent.getLayout() instanceof RowLayout) {
            RowData rd = new RowData();
            rd.width = w;
            this.ftext.setLayoutData(rd);
        } else if (parent.getLayout() instanceof GridLayout) {
            GridData rd = new GridData();
            rd.widthHint = w;
            this.ftext.setLayoutData(rd);
        }
    }

    @Override
    public void setData(APropertyNode pnode, Object b) {
        this.setData(pnode, b, b);
    }

    @Override
    public void setData(APropertyNode pnode, Object resolvedValue, Object elementValue) {
        this.createContextualMenu(pnode);
        this.ftext.setEnabled(pnode.isEditable());
        Number resolvedNumber = (Number)resolvedValue;
        Number ownNumber = (Number)elementValue;
        this.setDataNumber(resolvedNumber, ownNumber);
        if (elementValue == null) {
            this.ftext.setForeground(UIUtils.INHERITED_COLOR);
            this.ftext.setToolTipText(String.valueOf(Messages.common_inherited_attribute) + this.pDescriptor.getDescription());
            if (this.getLabel() != null) {
                this.getLabel().setToolTipText(String.valueOf(Messages.common_inherited_attribute) + this.pDescriptor.getDescription());
                this.getLabel().setForeground(UIUtils.INHERITED_COLOR);
            }
        } else {
            this.ftext.setForeground(ColorConstants.black);
            this.ftext.setToolTipText(this.pDescriptor.getDescription());
            if (this.getLabel() != null) {
                this.getLabel().setToolTipText(this.pDescriptor.getDescription());
                this.getLabel().setForeground(UIUtil.getColor("org.eclipse.ui.workbench.INFORMATION_FOREGROUND"));
            }
        }
    }

    public void setDataNumber(Number resolvedNumber, Number ownNumber) {
        if (resolvedNumber != null) {
            int oldpos = this.ftext.getCaretPosition();
            if (ownNumber == null) {
                this.ftext.setDefaultValue(resolvedNumber);
            }
            this.ftext.setValue(ownNumber);
            if (this.ftext.getText().length() >= oldpos) {
                this.ftext.setSelection(oldpos, oldpos);
            }
        } else if (ownNumber != null) {
            int oldpos = this.ftext.getCaretPosition();
            this.ftext.setValue(ownNumber);
            if (this.ftext.getText().length() >= oldpos) {
                this.ftext.setSelection(oldpos, oldpos);
            }
        } else {
            this.ftext.setValue(null);
        }
    }

    public void setNullable(boolean value) {
        if (this.ftext != null) {
            this.ftext.setNullable(value);
        }
    }

    public void setDigits(int minDigitsShown, int maxDigitsAccepted, Class<? extends Number> outputType) {
        this.outputType = outputType;
        if (this.minDigitsShown != minDigitsShown || this.maxDigitsAccepted != maxDigitsAccepted) {
            this.minDigitsShown = minDigitsShown;
            this.maxDigitsAccepted = maxDigitsAccepted;
            if (this.ftext != null) {
                this.ftext.setFormat(new ValidatedDecimalFormat(minDigitsShown, maxDigitsAccepted));
            }
        }
    }

    public void setBounds(Number min, Number max) {
        this.min = min;
        this.max = max;
        if (this.ftext != null) {
            this.ftext.setMinimum(min.doubleValue());
            this.ftext.setMaximum(max.doubleValue());
        }
    }
}

